/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db.table;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;

@Profile(value={"it"})
public class TableDeserializer
extends JsonDeserializer<DbTable> {
    private static final Logger log = LoggerFactory.getLogger(TableDeserializer.class);

    public DbTable deserialize(JsonParser jp, DeserializationContext ctxt) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList list = (ArrayList)objectMapper.convertValue((Object)node.get("header").get("rows").get(0).get("columns"), ArrayList.class);
            for (Object obj : list) {
                columns.add(((Map)objectMapper.convertValue(obj, Map.class)).get("value").toString());
            }
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            list = (ArrayList)objectMapper.convertValue((Object)node.get("body").get("rows"), ArrayList.class);
            for (Object obj : list) {
                ArrayList<String> insideData = new ArrayList<String>();
                ArrayList listForInside = (ArrayList)objectMapper.convertValue(((Map)objectMapper.convertValue(obj, Map.class)).get("columns"), ArrayList.class);
                for (Object insObj : listForInside) {
                    insideData.add(((Map)objectMapper.convertValue(insObj, Map.class)).get("value").toString());
                }
                data.add(insideData);
            }
            return new DbTable(columns, data);
        }
        catch (Exception e) {
            log.error("Can't deserialize object [{}]", (Object)e.getMessage());
            return new DbTable();
        }
    }
}

