/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.entity;

import com.vladmihalcea.hibernate.type.json.JsonType;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.PotSessionException;
import org.qubership.atp.mia.model.pot.ProcessStatus;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.entity.PotSession;

@Entity
@Table(name="pot_execution_step")
@TypeDef(name="json", typeClass=JsonType.class)
public class PotExecutionStep {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="UUID")
    @GenericGenerator(name="UUID", strategy="org.hibernate.id.UUIDGenerator")
    @Column(name="id", nullable=false, updatable=false)
    private UUID id;
    private String stepName;
    @Column(name="environment_name")
    private String environmentName;
    private String executedCommand;
    @Column(name="process_status", columnDefinition="json")
    @Type(type="json")
    private ProcessStatus processStatus;
    @Column(name="links", columnDefinition="json")
    @Type(type="json")
    private List<Link> links;
    @Column(name="validations", columnDefinition="json")
    @Type(type="json")
    private List<SqlResponse> validations;
    @Column(name="errors", columnDefinition="json")
    @Type(type="json")
    private List<PotSessionException> errors;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pot_session_id", nullable=false)
    private PotSession potSession;

    public void setErrors(List<Exception> errors) {
        this.errors = CollectionUtils.emptyIfNull(errors).stream().map(PotSessionException::new).collect(Collectors.toList());
    }

    public PotExecutionStep setPotSession(PotSession recordingSession) {
        this.potSession = recordingSession;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getExecutedCommand() {
        return this.executedCommand;
    }

    public ProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public List<SqlResponse> getValidations() {
        return this.validations;
    }

    public List<PotSessionException> getErrors() {
        return this.errors;
    }

    public PotSession getPotSession() {
        return this.potSession;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public void setExecutedCommand(String executedCommand) {
        this.executedCommand = executedCommand;
    }

    public void setProcessStatus(ProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setValidations(List<SqlResponse> validations) {
        this.validations = validations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PotExecutionStep)) {
            return false;
        }
        PotExecutionStep other = (PotExecutionStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PotExecutionStep;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "PotExecutionStep(id=" + this.getId() + ", stepName=" + this.getStepName() + ", environmentName=" + this.getEnvironmentName() + ", executedCommand=" + this.getExecutedCommand() + ", processStatus=" + this.getProcessStatus() + ", links=" + this.getLinks() + ", validations=" + this.getValidations() + ", errors=" + this.getErrors() + ", potSession=" + this.getPotSession() + ")";
    }
}

