/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.qubership.atp.mia.component.QueryDriverFactory;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotCreateFileFailedException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotFileToWriteNotFoundException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotHeaderTypeUnsupportedException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotIoException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotProcessStatusMissedException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotResultsSavingException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotSessionNotFoundException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotStepListEmptyException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotTemplateCanNotBeClosedException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotTemplateNotFoundOnPathException;
import org.qubership.atp.mia.exceptions.proofoftesting.PotWriteFailedException;
import org.qubership.atp.mia.model.configuration.PotHeaderConfiguration;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.PotHeader;
import org.qubership.atp.mia.model.impl.executable.PotHeaderType;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.Marker;
import org.qubership.atp.mia.model.pot.PotSessionException;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.TableMarkerResult;
import org.qubership.atp.mia.model.pot.entity.PotExecutionStep;
import org.qubership.atp.mia.model.pot.entity.PotSession;
import org.qubership.atp.mia.repo.impl.ShellRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.execution.RecordingSessionsService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class ProofOfTestingRepository {
    private static final Logger log = LoggerFactory.getLogger(ProofOfTestingRepository.class);
    private static final String RED = "fd483d";
    private static final String GREEN = "008000";
    private static final String YELLOW = "ffff00";
    private static final String YELLOW_STATUS = "ee9d30";
    private static final String GREY = "8b8d90";
    private static final String BLUE = "0000FF";
    private static final String POT_DOCX = "POT_%s.docx";
    private static final String POT_ARCHIVE = "POT_archive_%s.zip";
    private static final String shrinkSymbol = "...";
    private final ShellRepository shellRepository;
    private final MiaFileService miaFileService;
    private final QueryDriverFactory queryDriverFactory;
    private final MiaContext miaContext;
    private final RecordingSessionsService recordingSessionsService;
    private final String fileDownloadPrefix;
    @Value(value="${mia.pot.minLogLength:5}")
    private int minimumAmountOfLinesInFileToPrint;
    @Value(value="${mia.pot.maxLinesLogs:1000}")
    private int maxPrintedLines;
    @Value(value="${mia.pot.maxTableRows}")
    private int maxPrintedLinesSqlTable;
    private int printedLines = 0;

    public List<Link> downloadProofOfTesting() {
        UUID sessionId = this.miaContext.getFlowData().getSessionId();
        log.info("Start save POT for [" + sessionId + "] session");
        Path parentPath = this.miaContext.getLogPath();
        File potDocxFile = parentPath.resolve(String.format(POT_DOCX, sessionId)).toFile();
        File potArchiveFile = parentPath.resolve(String.format(POT_ARCHIVE, sessionId)).toFile();
        Optional<PotSession> session = this.recordingSessionsService.getSession(sessionId);
        if (session.isPresent()) {
            if (!parentPath.toFile().exists()) {
                try {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new PotCreateFileFailedException(parentPath.toString(), e);
                }
            }
            List<Link> result = this.saveProofOfTesting(session.get(), potDocxFile);
            log.info("POT saved for [" + sessionId + "] session");
            return result;
        }
        ArrayList<Link> resultFiles = new ArrayList<Link>();
        try {
            this.miaFileService.getFile(potDocxFile);
            resultFiles.add(MiaContext.getLogLinkOnUi(potDocxFile.getAbsolutePath()));
        }
        catch (Exception e) {
            try {
                this.miaFileService.getFile(potArchiveFile);
                resultFiles.add(MiaContext.getLogLinkOnUi(potArchiveFile.getAbsolutePath()));
            }
            catch (Exception e1) {
                throw new PotSessionNotFoundException();
            }
        }
        return resultFiles;
    }

    public List<Link> saveProofOfTesting(PotSession session, File targetFile) {
        if (session == null || session.getId() == null) {
            throw new PotSessionNotFoundException();
        }
        if (!targetFile.getAbsolutePath().endsWith("docx")) {
            throw new RuntimeException("You should use docx file");
        }
        List<PotExecutionStep> stepList = session.getPotExecutionSteps();
        if (stepList == null || stepList.size() < 1) {
            throw new PotStepListEmptyException();
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        File potTemplate = this.miaContext.getPotTemplate();
        try (XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(potTemplate));){
            try (FileOutputStream out = new FileOutputStream(targetFile);){
                document.createParagraph().setPageBreak(true);
                this.printHeaders(document, session);
                XWPFParagraph paragraph = document.createParagraph();
                paragraph.setStyle("Heading1");
                XWPFRun run = paragraph.createRun();
                run.setText("Table of Contents");
                XWPFParagraph paragraphWithContent = document.createParagraph();
                paragraphWithContent.createRun();
                int bookmarkId = 0;
                ArrayList<String> stepsTitles = new ArrayList<String>();
                for (PotExecutionStep step : stepList) {
                    stepsTitles.add(this.printExecutionStep(document, step, filePaths, bookmarkId));
                    ++bookmarkId;
                }
                bookmarkId = 0;
                for (int i = 0; i < stepList.size(); ++i) {
                    String anchor = stepList.get(i).getStepName().replace(" ", "_") + "_" + bookmarkId;
                    XWPFHyperlinkRun hyperLinkRun = this.createHyperlinkRunToAnchor(paragraphWithContent, anchor);
                    hyperLinkRun.setText((String)stepsTitles.get(i));
                    hyperLinkRun.setColor(BLUE);
                    paragraphWithContent.createRun().addBreak();
                    ++bookmarkId;
                }
                if (document.getParagraphs().size() > 3) {
                    while (((XWPFParagraph)document.getParagraphs().get(0)).getText().startsWith("Heading")) {
                        document.removeBodyElement(0);
                    }
                }
                document.write((OutputStream)out);
                log.trace("Written document");
            }
            catch (FileNotFoundException e) {
                throw new PotFileToWriteNotFoundException(targetFile.toString(), e);
            }
            catch (IOException e) {
                throw new PotWriteFailedException(targetFile.toString(), e);
            }
        }
        catch (FileNotFoundException e) {
            throw new PotTemplateNotFoundOnPathException(potTemplate.toString(), e);
        }
        catch (IOException e) {
            throw new PotTemplateCanNotBeClosedException(potTemplate.toString(), e);
        }
        catch (Exception e) {
            throw new PotResultsSavingException(e);
        }
        ArrayList<Link> resultFiles = new ArrayList<Link>();
        if (filePaths.size() > 0) {
            filePaths.add(targetFile.getAbsolutePath());
            Path archivePath = targetFile.getParentFile().toPath().resolve(String.format(POT_ARCHIVE, session.getId()));
            Link link2 = this.miaContext.zipCommandOutputs(filePaths, archivePath);
            resultFiles.add(link2);
            FileMetaData fileMetaData = FileMetaData.log(this.miaContext.getProjectId(), archivePath.toFile().getPath());
            this.miaFileService.saveLogFile(fileMetaData, archivePath.toFile());
        } else {
            FileMetaData fileMetaData = FileMetaData.log(this.miaContext.getProjectId(), targetFile.getPath());
            resultFiles.add(MiaContext.getLogLinkOnUi(targetFile.getAbsolutePath()));
            this.miaFileService.saveLogFile(fileMetaData, targetFile);
        }
        resultFiles.forEach(link -> {
            this.miaFileService.getFile(link.getPath());
            link.setPath(this.fileDownloadPrefix + link.getPath());
        });
        return resultFiles;
    }

    private void validatePathTraversal(Path filePath, Path baseDir) {
        Path normalizedPath = filePath.toAbsolutePath().normalize();
        if (!normalizedPath.startsWith(baseDir)) {
            throw new SecurityException("Invalid path: Path traversal attempt detected: " + normalizedPath);
        }
    }

    private boolean analyseAndPrintTable(XWPFDocument document, String content, TableMarkerResult tableMarkerResult) {
        this.assertTableRowCount(document, tableMarkerResult);
        if (tableMarkerResult.getColumnStatuses() == null || tableMarkerResult.getColumnStatuses().size() < 1) {
            return this.printTable(document, content);
        }
        TableContentInfo tci = new TableContentInfo(content);
        this.printTableDescription(tci, document);
        for (int i = 0; i < (int)Math.ceil((double)tci.countOfColumns / (double)tci.columnsInString); ++i) {
            XWPFRun run;
            XWPFTableCell cell;
            XWPFTable table = document.createTable();
            XWPFTableRow row = this.setTableStyleAndCreateRow(table);
            ArrayList<String> columnStatuses = new ArrayList<String>();
            for (int j = 0; j < tci.columnsInString && i * tci.columnsInString + j < tci.countOfColumns; ++j) {
                cell = row.createCell();
                run = this.getRunForColumnNameCell(cell);
                String columnName = tci.columnNames[i * tci.columnsInString + j];
                run.setText(columnName);
                if (tableMarkerResult.getColumnStatuses().stream().anyMatch(s -> s.getColumnName().equalsIgnoreCase(columnName))) {
                    String columnStatus = String.valueOf((Object)tableMarkerResult.getColumnStatuses().stream().filter(s -> s.getColumnName().equalsIgnoreCase(columnName)).findFirst().get().getStatus());
                    columnStatuses.add(columnStatus);
                    continue;
                }
                columnStatuses.add("");
            }
            this.printTableRow(table, Arrays.asList(tci.tableRows[1].split(",", -1)), tci.columnsInString, tci.countOfColumns, i);
            List<String> data = Arrays.asList(tci.tableRows[2].split(",", -1));
            row = table.createRow();
            for (int j = 0; j < tci.columnsInString && i * tci.columnsInString + j < tci.countOfColumns; ++j) {
                cell = row.getCell(j);
                if (((String)columnStatuses.get(j)).equals(Statuses.SUCCESS.toString())) {
                    cell.setColor(GREEN);
                } else if (((String)columnStatuses.get(j)).equals(Statuses.FAIL.toString())) {
                    cell.setColor(RED);
                }
                run = this.getRunForCell(cell);
                run.setText(data.get(i * tci.columnsInString + j));
            }
            document.createParagraph();
        }
        document.createParagraph();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyseAndPrintTextFile(XWPFParagraph paragraph, LineIterator it, Marker logMarkerEntity) {
        boolean shouldWePrintFile = false;
        int amountLinesToPrint = this.getMinimumAmountOfLinesInFileToPrint();
        int i = 0;
        try {
            while (it.hasNext()) {
                XWPFRun run;
                if (i++ == amountLinesToPrint) {
                    shouldWePrintFile = true;
                    run = paragraph.createRun();
                    run.setFontSize(8);
                    run.setText(shrinkSymbol);
                    run.addBreak();
                    break;
                }
                String str = it.next();
                run = paragraph.createRun();
                run.setFontSize(8);
                if (logMarkerEntity != null) {
                    if (logMarkerEntity.getPassedMarkerForLog() != null && logMarkerEntity.getPassedMarkerForLog().stream().anyMatch(passMarker -> Pattern.compile(passMarker).matcher(str).find())) {
                        run.setColor(GREEN);
                    } else if (logMarkerEntity.getFailedMarkersForLog() != null && logMarkerEntity.getFailedMarkersForLog().stream().anyMatch(failMarker -> Pattern.compile(failMarker).matcher(str).find())) {
                        run.setColor(RED);
                    } else if (logMarkerEntity.getWarnMarkersForLog() != null && logMarkerEntity.getWarnMarkersForLog().stream().anyMatch(warnMarker -> Pattern.compile(warnMarker).matcher(str).find())) {
                        run.setColor(YELLOW);
                    }
                }
                run.setText(str);
                run.addBreak();
                ++this.printedLines;
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        return shouldWePrintFile;
    }

    private void assertTableRowCount(XWPFDocument document, TableMarkerResult tableMarkerResult) {
        if (tableMarkerResult != null && tableMarkerResult.getTableRowCount() != null) {
            XWPFParagraph paragraph = document.createParagraph();
            XWPFRun run = paragraph.createRun();
            run.setBold(true);
            run.setText("Records count  ");
            run = paragraph.createRun();
            run.setColor(GREY);
            run.setText("ER: ");
            run = paragraph.createRun();
            run.setBold(true);
            run.setText(tableMarkerResult.getTableRowCount().getExpectedResult());
            run = paragraph.createRun();
            run.setColor(GREY);
            run.setText("  AR: ");
            run = paragraph.createRun();
            run.setBold(true);
            if (Statuses.SUCCESS.equals((Object)tableMarkerResult.getTableRowCount().getStatus())) {
                run.setColor(GREEN);
            } else {
                run.setColor(RED);
            }
            run.setText(tableMarkerResult.getTableRowCount().getActualResult());
        }
    }

    private XWPFParagraph createBookmarkedParagraph(XWPFDocument document, String anchor, int bookmarkId) {
        XWPFParagraph paragraph = document.createParagraph();
        CTBookmark bookmark = paragraph.getCTP().addNewBookmarkStart();
        bookmark.setName(anchor);
        bookmark.setId(BigInteger.valueOf(bookmarkId));
        paragraph.getCTP().addNewBookmarkEnd().setId(BigInteger.valueOf(bookmarkId));
        return paragraph;
    }

    private XWPFHyperlinkRun createHyperlinkRunToAnchor(XWPFParagraph paragraph, String anchor) {
        CTHyperlink cthyperLink = paragraph.getCTP().addNewHyperlink();
        cthyperLink.setAnchor(anchor);
        cthyperLink.addNewR();
        return new XWPFHyperlinkRun(cthyperLink, cthyperLink.getRArray(0), (IRunBody)paragraph);
    }

    private XWPFRun createRunForEmptyHeaderCell(XWPFTableCell cell) {
        cell.setColor("ffffff");
        cell.getCTTc().getTcPr().addNewTcW().setW(BigInteger.valueOf(5000L));
        return this.getXwpfRunFromParagraph((XWPFParagraph)cell.getParagraphs().get(0), 11);
    }

    private LineIterator getLineIterator(File outputFile) {
        try {
            return FileUtils.lineIterator((File)outputFile, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new PotIoException(outputFile.toString());
        }
    }

    private int getMinimumAmountOfLinesInFileToPrint() {
        int amountLinesToPrint = this.maxPrintedLines - this.printedLines;
        if (amountLinesToPrint < 1) {
            amountLinesToPrint = this.minimumAmountOfLinesInFileToPrint;
        }
        return amountLinesToPrint;
    }

    private XWPFRun getRunForCell(XWPFTableCell cell) {
        return this.getXwpfRunFromParagraph((XWPFParagraph)cell.getParagraphs().get(0), 6);
    }

    private XWPFRun getRunForColumnNameCell(XWPFTableCell cell) {
        cell.setColor("E3FCDF");
        cell.getCTTc().getTcPr().addNewTcW().setW(BigInteger.valueOf(1500L));
        return this.getXwpfRunFromParagraph((XWPFParagraph)cell.getParagraphs().get(0), 6);
    }

    private XWPFRun getRunForFirstHeaderCell(XWPFTableCell cell) {
        cell.setColor("E3FCDF");
        cell.getCTTc().getTcPr().addNewTcW().setW(BigInteger.valueOf(2000L));
        XWPFRun run = this.getXwpfRunFromParagraph((XWPFParagraph)cell.getParagraphs().get(0), 11);
        run.setBold(true);
        return run;
    }

    private XWPFRun getXwpfRunFromParagraph(XWPFParagraph paragraph, int fontSize) {
        paragraph.setIndentFromLeft(50);
        paragraph.setIndentFromRight(30);
        paragraph.setSpacingAfter(30);
        paragraph.setSpacingBefore(30);
        XWPFRun run = paragraph.createRun();
        run.setFontSize(fontSize);
        return run;
    }

    private void printError(XWPFRun run, PotSessionException error) {
        run.setColor(RED);
        run.setFontSize(8);
        run.setText(error.getMessage());
        run.addBreak();
    }

    private String printExecutionStep(XWPFDocument document, PotExecutionStep step, List<String> filePaths, int bookmarkId) {
        log.info("Start saving '{}' step in POT", (Object)step.getStepName());
        XWPFParagraph titleParagraph = this.createBookmarkedParagraph(document, step.getStepName() + "_" + bookmarkId, bookmarkId);
        titleParagraph.setPageBreak(true);
        titleParagraph.setStyle("Heading1");
        XWPFRun run = titleParagraph.createRun();
        run.setBold(true);
        run.setFontSize(14);
        run.setText(step.getStepName());
        run = titleParagraph.createRun();
        run.setBold(true);
        run.setFontSize(14);
        if (step.getProcessStatus() != null && step.getProcessStatus().getStatus().equals((Object)Statuses.SUCCESS)) {
            run.setColor(GREEN);
            run.setText(" : " + step.getProcessStatus().getStatus().toString());
        } else if (step.getProcessStatus() != null && step.getProcessStatus().getStatus().equals((Object)Statuses.WARNING)) {
            run.setColor(YELLOW_STATUS);
            run.setText(" : " + Statuses.WARNING.toString());
        } else {
            run.setColor(RED);
            run.setText(" : " + Statuses.FAIL.toString());
        }
        XWPFParagraph paragraph = document.createParagraph();
        paragraph.setStyle("Heading2");
        run = paragraph.createRun();
        run.setText("Execution");
        run = document.createParagraph().createRun();
        if (step.getExecutedCommand() != null) {
            for (String str : step.getExecutedCommand().split("\r\n")) {
                run.setText(str);
                run.addBreak();
            }
        }
        for (Link link : step.getLinks()) {
            if (step.getProcessStatus() == null) {
                throw new PotProcessStatusMissedException(step.getStepName());
            }
            this.printOutputFile(document, link, step.getProcessStatus().getMarker(), null, filePaths);
        }
        if (step.getValidations().size() > 0) {
            paragraph = document.createParagraph();
            paragraph.setStyle("Heading2");
            run = paragraph.createRun();
            run.setFontSize(12);
            run.setBold(true);
            run.setText("Validations");
        }
        for (SqlResponse sqlResponse : step.getValidations()) {
            this.printValidation(document, sqlResponse, filePaths);
        }
        if (step.getErrors().size() > 0) {
            paragraph = document.createParagraph();
            paragraph.setStyle("Heading2");
            run = paragraph.createRun();
            run.setFontSize(12);
            run.setBold(true);
            run.setText("Errors");
        }
        for (PotSessionException error : step.getErrors()) {
            this.printError(document.createParagraph().createRun(), error);
        }
        log.info("'{}' step was saved", (Object)step.getStepName());
        return titleParagraph.getText();
    }

    private void printFileLink(XWPFDocument document, Link link, List<String> filePaths) {
        if (link != null) {
            XWPFHyperlinkRun hyperlinkRun = document.createParagraph().createHyperlinkRun(this.fileDownloadPrefix + MiaContext.getLogLinkOnUi(link.getPath()).getPath());
            hyperlinkRun.setText(link.getName());
            hyperlinkRun.setFontSize(10);
            hyperlinkRun.setColor(BLUE);
            hyperlinkRun.setUnderline(UnderlinePatterns.SINGLE);
            if (filePaths != null) {
                filePaths.add(link.getPath());
            }
        } else {
            XWPFRun errorTextRun = document.createParagraph().createRun();
            errorTextRun.setText("Output file not found, link is empty.");
            errorTextRun.setFontSize(10);
            errorTextRun.setColor(RED);
        }
    }

    private void printFileName(XWPFDocument document, Link link) {
        this.printFileLink(document, link, null);
    }

    private void printHeader(XWPFTable table, PotHeader header) {
        String value;
        XWPFTableRow row = table.createRow();
        XWPFRun run = this.getRunForFirstHeaderCell(row.getCell(0));
        run.setText(header.getName());
        run = this.createRunForEmptyHeaderCell(row.getCell(1));
        String type = header.getType();
        PotHeaderType headerType = PotHeaderType.valueOf(type);
        Holder system = new Holder(null);
        try {
            system.value = this.miaContext.getFlowData().getSystem(header.getSystem());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (system.value != null) {
            Arrays.stream(Server.ConnectionType.values()).forEach(t -> {
                try {
                    this.miaContext.getFlowData().addParameters(((System)system.value).getServer((Server.ConnectionType)((Object)t)).getProperties());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            });
        }
        switch (headerType) {
            case TEXT: {
                value = header.getValue();
                break;
            }
            case INPUT: {
                value = this.miaContext.evaluate(header.getValue());
                break;
            }
            case SSH: {
                if (system.value != null) {
                    try {
                        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(new Command("POT_header", "SSH", header.getSystem(), Utils.listToSet(header.getValue())));
                        if (commandResponse.getCommandOutputs().size() > 0) {
                            value = String.join((CharSequence)"\n", commandResponse.getCommandOutputs().get(0).contentFromFile());
                            break;
                        }
                        value = "No output file for SSH command execution '" + header.getValue() + "'";
                    }
                    catch (IllegalArgumentException e) {
                        value = "SSH connection for system '" + header.getSystem() + "' not found";
                    }
                    catch (RuntimeException e) {
                        value = "SSH command execution '" + header.getValue() + "'failed for system '" + header.getSystem() + "'";
                    }
                    break;
                }
                value = "System '" + header.getSystem() + "' not found";
                break;
            }
            case SQL: {
                if (system.value != null) {
                    try {
                        Server server = ((System)system.value).getServer(Server.ConnectionType.DB);
                        value = this.queryDriverFactory.getDriver(server).executeQueryAndGetFirstValue(server, this.miaContext.evaluate(header.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        value = "Database connection for system '" + header.getSystem() + "' not found";
                    }
                    break;
                }
                value = "System '" + header.getSystem() + "' not found";
                break;
            }
            default: {
                throw new PotHeaderTypeUnsupportedException(type);
            }
        }
        run.setText(value);
    }

    private void printHeaders(XWPFDocument document, PotSession session) {
        PotHeaderConfiguration potHeaderConfiguration = this.miaContext.getConfig().getPotHeaderConfiguration();
        if (potHeaderConfiguration.getHeaders().size() == 0 || !potHeaderConfiguration.getHeaders().stream().anyMatch(header -> header.getName().equalsIgnoreCase("Environment"))) {
            potHeaderConfiguration.getHeaders().add(0, new PotHeader("Environment", PotHeaderType.INPUT.toString(), null, session.getPotExecutionSteps().stream().map(PotExecutionStep::getEnvironmentName).collect(Collectors.toList()).toString()));
        }
        XWPFTable table = document.createTable();
        XWPFTableRow row = this.setTableStyleAndCreateRow(table);
        XWPFRun run = this.getRunForFirstHeaderCell(row.createCell());
        run.setText("Test line");
        this.createRunForEmptyHeaderCell(row.createCell());
        for (PotHeader header2 : potHeaderConfiguration.getHeaders()) {
            this.printHeader(table, header2);
        }
        table.removeRow(0);
        document.createParagraph().setPageBreak(true);
    }

    private void printOutputFile(XWPFDocument document, Link link, Marker logMarkerEntity, TableMarkerResult tableMarkerResult, List<String> filePaths) {
        boolean shouldWePrintFile;
        block12: {
            File outputFile = new File(link.getPath());
            try {
                this.miaFileService.getFile(outputFile);
                if (outputFile.isDirectory()) {
                    throw new IOException("File not found, it's directory path:" + outputFile);
                }
            }
            catch (IOException | MiaException e) {
                log.error(ErrorCodes.MIA_2158_POT_PRINT_FILE_NOT_FOUND.getMessage(((Throwable)e).getMessage()), (Throwable)e);
                return;
            }
            this.printFileName(document, link);
            shouldWePrintFile = false;
            if (link.getName().endsWith(".csv")) {
                try {
                    String content = new String(Files.readAllBytes(outputFile.toPath()));
                    if (tableMarkerResult != null) {
                        shouldWePrintFile = this.analyseAndPrintTable(document, content, tableMarkerResult);
                        break block12;
                    }
                    shouldWePrintFile = this.printTable(document, content);
                }
                catch (IOException e) {
                    log.error(ErrorCodes.MIA_2158_POT_PRINT_FILE_NOT_FOUND.getMessage(e.getMessage()), (Throwable)e);
                }
            } else if (link.getName().endsWith(".log") || link.getName().endsWith(".txt")) {
                LineIterator it = this.getLineIterator(outputFile);
                shouldWePrintFile = logMarkerEntity != null ? this.analyseAndPrintTextFile(document.createParagraph(), it, logMarkerEntity) : this.printTextFile(document.createParagraph().createRun(), it);
            } else if (link.getName().endsWith(".json")) {
                shouldWePrintFile = true;
            }
        }
        if (shouldWePrintFile) {
            filePaths.add(link.getPath());
        }
    }

    private boolean printTable(XWPFDocument document, String content) {
        TableContentInfo tci = new TableContentInfo(content);
        this.printTableDescription(tci, document);
        for (int i = 0; i < (int)Math.ceil((double)tci.columnNames.length / (double)tci.columnsInString); ++i) {
            XWPFRun run;
            XWPFTable table = document.createTable();
            XWPFTableRow row = this.setTableStyleAndCreateRow(table);
            for (int j = 0; j < tci.columnsInString && i * tci.columnsInString + j < tci.countOfColumns; ++j) {
                XWPFTableCell cell = row.createCell();
                run = this.getRunForColumnNameCell(cell);
                run.setText(tci.columnNames[i * tci.columnsInString + j]);
            }
            for (int d = 1; d < tci.tableRows.length && d <= this.maxPrintedLinesSqlTable; ++d) {
                this.printTableRow(table, Arrays.asList(tci.tableRows[d].split(",", -1)), tci.columnsInString, tci.countOfColumns, i);
            }
            XWPFParagraph paragraph = document.createParagraph();
            if (tci.tableRows.length <= this.maxPrintedLinesSqlTable) continue;
            run = paragraph.createRun();
            run.setFontSize(8);
            run.setText(shrinkSymbol);
            run.addBreak();
        }
        document.createParagraph();
        return tci.tableRows.length > this.maxPrintedLinesSqlTable;
    }

    private void printTableDescription(TableContentInfo tci, XWPFDocument document) {
        if (tci.description.length > 0) {
            XWPFRun run = document.createParagraph().createRun();
            if (Arrays.toString(tci.description).matches(".*Message.*Cause.*StackTrace.*")) {
                run.setColor(RED);
                run.setFontSize(12);
            } else {
                run.setFontSize(8);
            }
            Arrays.stream(tci.description).forEach(d -> {
                run.setText(d);
                run.addBreak();
            });
        }
    }

    private void printTableRow(XWPFTable table, List<String> data, int columnsInString, int countOfColumns, int partOfTable) {
        XWPFTableRow row = table.createRow();
        for (int j = 0; j < columnsInString && partOfTable * columnsInString + j < countOfColumns; ++j) {
            try {
                XWPFTableCell cell = row.getCell(j);
                XWPFRun run = this.getRunForCell(cell);
                run.setText(data.get(partOfTable * columnsInString + j));
                continue;
            }
            catch (Exception e) {
                log.error(ErrorCodes.MIA_2157_POT_PRINT_ROW_ERROR.getMessage(new Object[0]), new Object[]{countOfColumns, partOfTable * columnsInString + j, data.size()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printTextFile(XWPFRun run, LineIterator it) {
        boolean shouldWePrintFile = false;
        int amountLinesToPrint = this.getMinimumAmountOfLinesInFileToPrint();
        int i = 0;
        try {
            run.setFontSize(8);
            while (it.hasNext()) {
                if (i++ == amountLinesToPrint) {
                    run.setText(shrinkSymbol);
                    run.addBreak();
                    shouldWePrintFile = true;
                    break;
                }
                run.setText(it.next());
                run.addBreak();
                ++this.printedLines;
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        return shouldWePrintFile;
    }

    private void printValidation(XWPFDocument document, SqlResponse sqlResponse, List<String> filePaths) {
        XWPFParagraph paragraph = document.createParagraph();
        XWPFRun run = paragraph.createRun();
        run.setFontSize(8);
        if (sqlResponse.getQuery() != null) {
            for (String str : sqlResponse.getQuery().split("\r\n")) {
                run.setText(str);
                run.addBreak();
            }
        }
        if (sqlResponse.getLink() != null) {
            if (sqlResponse.isSaveToWordFile()) {
                this.printOutputFile(document, sqlResponse.getLink(), null, sqlResponse.getTableMarkerResult(), filePaths);
            }
            if (sqlResponse.isSaveToZipFile()) {
                this.printFileLink(document, sqlResponse.getLink(), filePaths);
            }
        }
    }

    private XWPFTableRow setTableStyleAndCreateRow(XWPFTable table) {
        table.setWidth(7000);
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        CTJc jc = tblPr.isSetJc() ? tblPr.getJc() : tblPr.addNewJc();
        STJc.Enum en = STJc.Enum.forInt((int)ParagraphAlignment.LEFT.getValue());
        jc.setVal(en);
        table.removeRow(0);
        return table.createRow();
    }

    public ProofOfTestingRepository(ShellRepository shellRepository, MiaFileService miaFileService, QueryDriverFactory queryDriverFactory, MiaContext miaContext, RecordingSessionsService recordingSessionsService, String fileDownloadPrefix) {
        this.shellRepository = shellRepository;
        this.miaFileService = miaFileService;
        this.queryDriverFactory = queryDriverFactory;
        this.miaContext = miaContext;
        this.recordingSessionsService = recordingSessionsService;
        this.fileDownloadPrefix = fileDownloadPrefix;
    }

    private class TableContentInfo {
        public final String[] tableRows;
        public final String[] columnNames;
        public final int countOfColumns;
        public final int columnsInString = 8;
        public String table = "";
        public String query = "";
        public String[] description = new String[0];

        public TableContentInfo(String content) {
            String[] blocks = content.split("\n,\n");
            if (blocks.length > 0) {
                this.table = blocks[0];
                if (blocks.length > 1) {
                    this.query = blocks[1];
                    if (blocks.length > 2) {
                        this.description = blocks[2].split("\n");
                    }
                }
            }
            this.tableRows = this.table.split("\n");
            this.columnNames = this.tableRows[0].split(",");
            this.countOfColumns = this.columnNames.length;
        }
    }
}

