/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import clover.com.google.common.base.Strings;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshExecutionTimeoutException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshExecutionWrongExitException;
import org.qubership.atp.mia.model.environment.ConnectionProps;
import org.qubership.atp.mia.repo.impl.SshSession;
import org.qubership.atp.mia.repo.impl.pool.ssh.ChannelType;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SshConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionManager.class);
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(100);
    private static final AtomicLong instancesCounter = new AtomicLong();
    private static final String INTERRUPT_SIGNAL = "INT";
    private final ConnectionProps properties;
    private final String managerInstanceNumber;
    private final String externalPrefix;
    private final boolean saveFilesToWorkingDir;
    private final SshSession sshSession;
    private final MiaContext miaContext;
    private StringBuilder commandToExecute;

    public SshConnectionManager(SshSession session, String extPrefix, MiaContext miaContext) {
        this.miaContext = miaContext;
        this.sshSession = session;
        this.properties = session.getProperties();
        this.externalPrefix = extPrefix;
        this.saveFilesToWorkingDir = miaContext.getConfig().getCommonConfiguration().isSaveFilesToWorkingDir();
        this.managerInstanceNumber = "ssh_conn_manager_N_" + instancesCounter.incrementAndGet();
        log.trace("Ssh manager \u2116{} created and has environment properties: {}.", (Object)this.managerInstanceNumber, (Object)this.properties.fullInfo());
    }

    public synchronized String runCommand(@Nonnull String command) {
        StringBuffer output = new StringBuffer();
        String prefix = this.isPrefixPresent() ? this.externalPrefix + "\n" : "";
        this.commandToExecute = new StringBuilder(command);
        if (command.contains("pbrun -u infinys")) {
            this.commandToExecute.append("'");
        }
        log.info("Execute ssh command:\n{}{}", (Object)prefix, (Object)this.commandToExecute);
        String stopCode = "STOP " + UUID.randomUUID();
        String echoStopCode = "echo \"" + stopCode + "\"";
        String finalCommand = this.commandToExecute.toString() + "\n" + echoStopCode + "\n exit";
        AtomicBoolean isExecutedFlag = new AtomicBoolean(false);
        this.channelFlow(ChannelType.SHELL, false, "Could not run command [" + command + "]", channel -> {
            ChannelShell channelShell = (ChannelShell)channel;
            channelShell.setPty(this.properties.isPty());
            channelShell.setExtOutputStream((OutputStream)new PipedOutputStream());
            long start = System.currentTimeMillis();
            channelShell.connect(this.properties.getTimeoutConnect());
            ScheduledFuture<?> future = this.interruptExecutionOnTimeout(command, isExecutedFlag, (Channel)channelShell);
            try (PrintStream input = new PrintStream(channelShell.getOutputStream());){
                input.print(prefix);
                input.print("\n");
                input.print(finalCommand);
                input.print("\n");
                try (InputStream inputStream = channelShell.getInputStream();
                     InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                     BufferedReader reader = new BufferedReader(inputStreamReader);){
                    String line;
                    input.flush();
                    int i = 0;
                    while ((line = reader.readLine()) != null) {
                        log.trace("{}) Line output: {}", (Object)(++i), (Object)line);
                        if (line.matches("> " + echoStopCode)) {
                            log.trace("{}) Line has {}: {}", new Object[]{i, "Incorrect command", line});
                            throw new SshExecutionWrongExitException(this.managerInstanceNumber, finalCommand);
                        }
                        if (line.equals(stopCode)) {
                            log.trace("{}) Line correct exit: {}", (Object)i, (Object)line);
                            break;
                        }
                        output.append(line).append("\n");
                    }
                }
                finally {
                    if (channelShell.getInputStream() != null) {
                        channelShell.getInputStream().close();
                    }
                }
            }
            finally {
                isExecutedFlag.set(true);
            }
            if (future.isDone()) {
                throw new SshExecutionTimeoutException(command, this.properties.getTimeoutExecute());
            }
            future.cancel(true);
            log.debug("Exec took {} ms", (Object)(System.currentTimeMillis() - start));
            log.trace("Output of {} execution:\n{}", (Object)ChannelType.SHELL, (Object)output);
        });
        return output.toString();
    }

    @NotNull
    private ScheduledFuture<?> interruptExecutionOnTimeout(@NotNull String command, AtomicBoolean isExecutedFlag, Channel channelShell) {
        Map mdcMap = MDC.getCopyOfContextMap();
        log.debug("Create SSH interrupt scheduler for channel {} with timeout {}", (Object)channelShell.getId(), (Object)this.properties.getTimeoutExecute());
        return executorService.schedule(() -> {
            Thread.currentThread().setName("mia_ssh_timeout_channel_" + channelShell.getId());
            MdcUtils.setContextMap((Map)mdcMap);
            if (!isExecutedFlag.get()) {
                try {
                    channelShell.sendSignal(INTERRUPT_SIGNAL);
                    log.info("Ssh command execution was interrupted by timeout.\ncommand: [" + command + "], timeout: [" + this.properties.getTimeoutExecute() + " ms]");
                }
                catch (Exception e) {
                    log.info("Can't get channelShell output to interrupt timeout connection [chId = {}]", (Object)channelShell.getId());
                }
                finally {
                    log.info("Closing channel due timeout [chId = {}]", (Object)channelShell.getId());
                    channelShell.disconnect();
                    Thread.currentThread().interrupt();
                }
            }
        }, (long)this.properties.getTimeoutExecute(), TimeUnit.MILLISECONDS);
    }

    public void uploadFileOnServer(File file, String pathToUpLoad, String workingDirectory) {
        boolean isTmpPathForUpload = this.isPrefixPresent() || this.saveFilesToWorkingDir;
        String tmpPathForUpload = isTmpPathForUpload ? workingDirectory : pathToUpLoad;
        log.info("Upload file {} to {}", (Object)file, (Object)tmpPathForUpload);
        String command = "mkdir -p " + tmpPathForUpload + "\nchmod 777 " + tmpPathForUpload;
        this.runCommand(this.updateCommandForExternalEnv(command));
        this.putFileFromServer(file.toPath(), tmpPathForUpload);
        if (isTmpPathForUpload) {
            this.runCommand(this.updateCommandForExternalEnv("chmod 777 " + workingDirectory));
            String tmpPathToFile = FileUtils.tempFileName(workingDirectory, file.getName());
            this.transferFileOnServer(tmpPathToFile, pathToUpLoad);
        }
    }

    public void transferFileOnServer(String pathToFile, String pathToUpLoad) {
        log.info("Transferring file from [ " + pathToFile + " ] to [ " + pathToUpLoad + " ]");
        String command = "chmod 777 " + pathToFile + "\ncp -p " + pathToFile + " " + pathToUpLoad;
        this.runCommand(this.updateCommandForExternalEnv(command));
    }

    public File getFileFromServer(String path, String workingDirectory) {
        log.info("Getting file {}", (Object)path);
        String tempPath = path;
        String fileName = FilenameUtils.getName((String)path);
        if (this.isPrefixPresent() || this.saveFilesToWorkingDir) {
            log.debug("moving file to working directory before downloading it, src: {}, dest: {}", (Object)path, (Object)workingDirectory);
            try {
                this.transferFileOnServer(path, workingDirectory);
                tempPath = FileUtils.tempFileName(workingDirectory, fileName);
            }
            catch (Exception e) {
                log.error("Can't move file to working directory before download to MIA. workingDirectory: {}, filePath: {}", new Object[]{workingDirectory, path, e});
            }
        }
        String src = tempPath;
        File dest = this.miaContext.getLogPath().resolve(fileName).toFile();
        dest.getParentFile().mkdirs();
        this.commandToExecute = new StringBuilder(String.format("get file from server [src: %s, dest: %s]", src, dest.getAbsolutePath()));
        String exceptionStr = "Failed to " + this.commandToExecute;
        this.channelFlow(ChannelType.SFTP, true, exceptionStr, channel -> ((ChannelSftp)channel).get(src, dest.getPath()));
        log.info("Got file, newPath: {}; oldPath: {}", (Object)dest, (Object)path);
        return dest;
    }

    public void putFileFromServer(Path pathToFile, String pathToUpLoad) {
        this.channelFlow(ChannelType.SFTP, true, String.format("Error while put file %s to %s", pathToFile, pathToUpLoad), channel -> {
            ChannelSftp sftpChannel = (ChannelSftp)channel;
            sftpChannel.put(pathToFile.toString(), pathToUpLoad.trim());
            String pathToUploaded = FileUtils.tempFileName(pathToUpLoad, pathToFile.getFileName().toString());
            try {
                sftpChannel.chmod(Integer.parseInt("777", 8), pathToUploaded);
            }
            catch (SftpException e) {
                if (e.id == 2) {
                    log.error("Can't use chmod at uploaded file [{}], it doesn't exist anymore!", (Object)pathToUploaded);
                }
                throw e;
            }
        });
    }

    public void removeFileFromServer(String pathToFile) {
        this.channelFlow(ChannelType.SFTP, true, "Error while remove file %s" + pathToFile, channel -> ((ChannelSftp)channel).rm(pathToFile));
    }

    /*
     * Exception decompiling
     */
    private void channelFlow(ChannelType channelType, boolean connect, String exceptionString, ThrowingConsumer<Exception> throwingConsumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String updateCommandForExternalEnv(String command) {
        if (this.isPrefixPresent() && !this.properties.isPty()) {
            command = command + " &";
        }
        return command;
    }

    public String getExecutedCommand() {
        return this.commandToExecute == null ? "" : this.commandToExecute.toString();
    }

    private boolean isPrefixPresent() {
        return !Strings.isNullOrEmpty((String)this.externalPrefix);
    }

    public Map<String, String> connectionInfo() {
        HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("host", this.properties.getHostname());
        connectionInfo.put("user", this.properties.getUsername());
        return connectionInfo;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<E extends Exception> {
        public void accept(Channel var1) throws E;
    }
}

