/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.migration.v3;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.mia.config.BeanAwareSpringLiquibase;
import org.qubership.atp.mia.exceptions.configuration.DeserializeJsonConfigFailedException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.IncorrectEnvironmentResponseException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectsJson;
import org.qubership.atp.mia.model.environment.AbstractConfiguratorModel;
import org.qubership.atp.mia.service.configuration.EnvironmentsService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadProjectsFromJson
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(LoadProjectsFromJson.class);
    private ProjectConfigurationService projectConfigurationService;
    private EnvironmentsService environmentsService;
    private Path miaConfigPath;

    public LoadProjectsFromJson() {
        try {
            this.environmentsService = BeanAwareSpringLiquibase.getBean(EnvironmentsService.class);
            this.projectConfigurationService = BeanAwareSpringLiquibase.getBean(ProjectConfigurationService.class);
            this.miaConfigPath = BeanAwareSpringLiquibase.getBean(Path.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(Database database) {
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName("atp-mia-migration-v3");
        Set<Object> projectsJsonList = new HashSet();
        try {
            this.projectConfigurationService.findByProjectId(new UUID(0L, 0L));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            List<AbstractConfiguratorModel> projects = this.environmentsService.getProjects();
            projectsJsonList = ((Set)new ObjectMapper().readValue(this.miaConfigPath.resolve("project").resolve("projects_config.json").toFile(), (TypeReference)new TypeReference<Set<ProjectsJson>>(){})).stream().filter(p -> {
                try {
                    UUID projectId = UUID.fromString(p.getId());
                    if (p.getConfigUrl() == null) {
                        log.error("Url for config not defined! No need for migration", (Object)p.getId());
                        return false;
                    }
                    Optional<AbstractConfiguratorModel> project = projects.stream().filter(proj -> proj.getId().equals(projectId)).findFirst();
                    if (!project.isPresent()) {
                        log.error("Project with ID '{}' not found", (Object)p.getId());
                        return false;
                    }
                    p.setName(project.get().getName());
                    return true;
                }
                catch (IllegalArgumentException e) {
                    log.error("Project with ID '{}' can't be load", (Object)p.getId());
                    return false;
                }
            }).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(projectsJsonList)) {
                ExecutorService threadPoolForProjects = Executors.newFixedThreadPool(projectsJsonList.size());
                ArrayList futures = new ArrayList();
                projectsJsonList.forEach(projectJson -> futures.add(threadPoolForProjects.submit(new LoadProjectCallable((ProjectsJson)projectJson, this.projectConfigurationService))));
                threadPoolForProjects.shutdown();
                boolean successExecution = true;
                for (Future future : futures) {
                    try {
                        ProjectsJson resultExecution = (ProjectsJson)future.get(3L, TimeUnit.MINUTES);
                        successExecution &= resultExecution.isSuccessfulLoad();
                        if (resultExecution.isSuccessfulLoad()) {
                            log.info("Project with ID '{}' and name '{}' has been successful loaded from git URL '{}'", new Object[]{resultExecution.getId(), resultExecution.getName(), resultExecution.getConfigUrl()});
                            continue;
                        }
                        log.error("Project with ID '{}' and name '{}' load fail  from git URL '{}' with reason: {}", new Object[]{resultExecution.getId(), resultExecution.getName(), resultExecution.getConfigUrl(), resultExecution.getException().getMessage()});
                    }
                    catch (InterruptedException e) {
                        log.error("LoadProjectsFromJson InterruptedException: {}", (Throwable)e);
                        successExecution = false;
                    }
                    catch (ExecutionException e) {
                        log.error("LoadProjectsFromJson ExecutionException: {}", (Throwable)e);
                        successExecution = false;
                    }
                    catch (TimeoutException e) {
                        log.error("LoadProjectsFromJson aborted by timeout");
                        successExecution = false;
                    }
                }
                if (!successExecution) {
                    throw new DeserializeJsonConfigFailedException("Not at all projects has been loaded from projects_config.json", "");
                }
            } else {
                log.warn("Nothing to load from projects_config.json");
            }
        }
        catch (IncorrectEnvironmentResponseException e) {
            if (e.getMessage().contains("MIA-5006")) {
                log.error("{} Skip that step", (Object)e.getMessage());
            }
        }
        catch (IOException e) {
            throw new DeserializeJsonConfigFailedException("Fail load projects_config.json", e.getMessage());
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public void setUp() {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    class LoadProjectCallable
    implements Callable<ProjectsJson> {
        private final ProjectsJson projectJson;
        private final ProjectConfigurationService projectConfigurationService;

        @Override
        public ProjectsJson call() throws Exception {
            UUID projectId = UUID.fromString(this.projectJson.getId());
            Thread.currentThread().setName("atp-mia-migration-v3-" + projectId);
            log.info("Load from json for project " + projectId);
            try {
                ProjectConfiguration projectConfiguration;
                Optional<ProjectConfiguration> projectConfigurationOptional = this.projectConfigurationService.findByProjectId(projectId);
                DateAuditorEntity dateAuditorEntity = projectConfiguration = projectConfigurationOptional.isPresent() ? projectConfigurationOptional.get() : ((ProjectConfiguration.ProjectConfigurationBuilder)((ProjectConfiguration.ProjectConfigurationBuilder)ProjectConfiguration.builder().projectId(projectId)).projectName(this.projectJson.getName())).build();
                if (projectConfiguration.isPrimaryMigrationDone()) {
                    log.info("Project with ID '{}' already migrated", (Object)projectId);
                } else {
                    projectConfiguration.setGitUrl(this.projectJson.getConfigUrl());
                    this.projectConfigurationService.loadConfigurationFromGit(projectConfiguration, true);
                }
                this.projectJson.setSuccessfulLoad(true);
            }
            catch (Exception e) {
                this.projectJson.setSuccessfulLoad(false);
                this.projectJson.setException(e);
            }
            return this.projectJson;
        }

        public LoadProjectCallable(ProjectsJson projectJson, ProjectConfigurationService projectConfigurationService) {
            this.projectJson = projectJson;
            this.projectConfigurationService = projectConfigurationService;
        }
    }
}

