/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.CompoundShortDto;
import org.qubership.atp.mia.exceptions.configuration.CompoundNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.CreateCompoundException;
import org.qubership.atp.mia.exceptions.configuration.DeleteCompoundException;
import org.qubership.atp.mia.exceptions.configuration.DuplicateCompoundException;
import org.qubership.atp.mia.exceptions.configuration.UpdateCompoundException;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.repo.configuration.CompoundConfigurationRepository;
import org.qubership.atp.mia.service.configuration.ProcessConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.qubership.atp.mia.service.history.impl.AbstractEntityHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CompoundConfigurationService
extends AbstractEntityHistoryService<CompoundConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(CompoundConfigurationService.class);
    private final CompoundConfigurationRepository compoundConfigurationRepository;
    private final ModelMapper modelMapper;
    private final ProjectConfigurationService projectConfigurationService;

    public CompoundDto addCompound(ProjectConfiguration projectConfiguration, CompoundDto compoundDto) {
        log.info("Attempting to create compound: '{}'", (Object)compoundDto);
        if (projectConfiguration.getCompounds().stream().anyMatch(cc -> cc.getName().equals(compoundDto.getName()))) {
            log.error("Duplicate compound detected: '{}'", (Object)compoundDto.getName());
            throw new DuplicateCompoundException(compoundDto.getName());
        }
        try {
            CompoundConfiguration compoundConfiguration = (CompoundConfiguration)this.modelMapper.map((Object)compoundDto, CompoundConfiguration.class);
            compoundConfiguration.setProjectConfiguration(projectConfiguration);
            projectConfiguration.getCompounds().add(compoundConfiguration);
            log.debug("Updating sections and processes for new compound '{}'", (Object)compoundDto.getName());
            this.syncCompoundSectionsAndProcesses(projectConfiguration, compoundConfiguration, compoundDto);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.compoundConfigurationRepository.save(compoundConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully created compound '{}'", (Object)compoundConfiguration);
            return this.toDto(compoundConfiguration);
        }
        catch (Exception e) {
            log.error("Error while creating compound '{}': {}", (Object)compoundDto.getName(), (Object)e.getMessage());
            throw new CreateCompoundException(e);
        }
    }

    public List<CompoundShortDto> compoundsDto(List<CompoundConfiguration> compoundConfigurationList) {
        log.trace("Converting {} compound configurations to DTOs", (Object)compoundConfigurationList.size());
        Type listType = new TypeToken<List<CompoundShortDto>>(){}.getType();
        return (List)this.modelMapper.map(compoundConfigurationList, listType);
    }

    public List<CompoundShortDto> deleteCompound(ProjectConfiguration projectConfiguration, UUID compoundId) {
        log.info("Attempting to delete compound with ID '{}'", (Object)compoundId);
        CompoundConfiguration compoundConfiguration = this.getCompoundById(projectConfiguration, compoundId);
        try {
            log.debug("Removing compound '{}' from sections and processes", (Object)compoundConfiguration.getName());
            projectConfiguration.getAllSections().forEach(s -> s.getCompounds().remove(compoundConfiguration));
            projectConfiguration.getProcesses().forEach(p -> {
                p.getInCompounds().remove(compoundConfiguration);
                p.getCompounds().remove(compoundConfiguration.getName());
            });
            compoundConfiguration.setInSections(new ArrayList<SectionConfiguration>());
            compoundConfiguration.setProcesses(new ArrayList<ProcessConfiguration>());
            projectConfiguration.getCompounds().remove(compoundConfiguration);
            log.debug("Executing database delete for compound '{}'", (Object)compoundConfiguration.getName());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.compoundConfigurationRepository.delete(compoundConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully deleted compound '{}'", (Object)compoundConfiguration);
        }
        catch (Exception e) {
            log.error("Error while deleting compound with ID '{}': {}", (Object)compoundConfiguration.getId(), (Object)e.getMessage());
            throw new DeleteCompoundException(e);
        }
        return this.compoundsDto(projectConfiguration.getCompounds());
    }

    public static LinkedList<CompoundConfiguration> filterCompounds(List<CompoundConfiguration> compounds, List<UUID> compoundsUuid) {
        log.trace("Filtering {} compounds with {} compound UUIDs", (Object)compounds.size(), (Object)compoundsUuid.size());
        LinkedList<CompoundConfiguration> filteredCompounds = new LinkedList<CompoundConfiguration>();
        compoundsUuid.forEach(compoundUUID -> compounds.stream().filter(s -> s.getId().equals(compoundUUID)).findAny().ifPresent(filteredCompounds::add));
        return filteredCompounds;
    }

    public CompoundDto toDto(CompoundConfiguration compoundConfiguration) {
        return (CompoundDto)this.modelMapper.map((Object)compoundConfiguration, CompoundDto.class);
    }

    public CompoundDto updateCompound(ProjectConfiguration projectConfiguration, CompoundDto compoundDto) {
        log.info("Attempting to update compound '{}'", (Object)compoundDto);
        CompoundConfiguration compoundConfiguration = projectConfiguration.getCompounds().stream().filter(cf -> cf.getId().equals(compoundDto.getId())).findFirst().orElseThrow(() -> {
            log.error("Compound not found for update with ID '{}'", (Object)compoundDto.getId());
            return new CompoundNotFoundException(compoundDto.getId());
        });
        try {
            log.debug("Updating compound properties for '{}'", (Object)compoundDto.getName());
            compoundConfiguration.setName(compoundDto.getName());
            compoundConfiguration.setReferToInput(compoundDto.getReferToInput());
            this.syncCompoundSectionsAndProcesses(projectConfiguration, compoundConfiguration, compoundDto);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.compoundConfigurationRepository.save(compoundConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully updated compound '{}'", (Object)compoundDto.getName());
            return this.toDto(compoundConfiguration);
        }
        catch (Exception e) {
            log.error("Error while updating compound '{}': {}", (Object)compoundDto.getName(), (Object)e.getMessage());
            throw new UpdateCompoundException(e);
        }
    }

    public CompoundConfiguration getCompoundById(ProjectConfiguration projectConfiguration, UUID compoundId) {
        log.trace("Founding compound with ID '{}'", (Object)compoundId);
        return projectConfiguration.getCompounds().stream().filter(c -> c.getId().equals(compoundId)).findFirst().orElseThrow(() -> {
            log.error("Compound not found: ID '{}'", (Object)compoundId);
            return new CompoundNotFoundException(compoundId);
        });
    }

    private void syncCompoundSectionsAndProcesses(ProjectConfiguration projectConfiguration, CompoundConfiguration compoundConfiguration, CompoundDto compoundDto) {
        if (compoundDto.getInSections() != null) {
            log.debug("Updating sections for compound '{}'", (Object)compoundConfiguration.getName());
            List<SectionConfiguration> sectionBefore = compoundConfiguration.getInSections();
            List<SectionConfiguration> sectionConfigurationList = SectionConfigurationService.filterSections(projectConfiguration.getAllSections(), compoundDto.getInSections());
            compoundConfiguration.setInSections(sectionConfigurationList);
            sectionConfigurationList.forEach(s -> {
                if (!s.getCompounds().contains(compoundConfiguration)) {
                    s.getCompounds().add(compoundConfiguration);
                }
            });
            if (sectionBefore != null) {
                sectionBefore.stream().filter(s -> !sectionConfigurationList.contains(s)).forEach(s -> s.getCompounds().remove(compoundConfiguration));
            }
            log.debug("Successfully updated sections for compound '{}'", (Object)compoundConfiguration.getName());
        }
        if (compoundDto.getProcesses() != null) {
            log.debug("Updating processes for compound '{}'", (Object)compoundConfiguration.getName());
            LinkedList<ProcessConfiguration> processConfigurationList = ProcessConfigurationService.filterProcesses(projectConfiguration.getProcesses(), compoundDto.getProcesses());
            compoundConfiguration.setProcesses(processConfigurationList);
            log.debug("Successfully updated processes for compound '{}'", (Object)compoundConfiguration.getName());
        }
    }

    @Override
    public CompoundConfiguration get(UUID id) {
        return (CompoundConfiguration)this.compoundConfigurationRepository.findById(id).orElseThrow(MiaHistoryRevisionRestoreException::new);
    }

    @Override
    public CompoundConfiguration restore(DateAuditorEntity entity) {
        log.info("Restoring compound configuration '{}'", (Object)entity);
        CompoundConfiguration compoundConfiguration = (CompoundConfiguration)entity;
        ProjectConfiguration projectConfiguration = compoundConfiguration.getProjectConfiguration();
        ProcessConfigurationService.checkProcessesById(projectConfiguration, compoundConfiguration.getProcesses());
        this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
            this.compoundConfigurationRepository.save(compoundConfiguration);
            return projectConfiguration;
        }, false);
        log.info("Successfully restored compound configuration '{}'", (Object)compoundConfiguration.getName());
        return compoundConfiguration;
    }

    public CompoundConfigurationService(CompoundConfigurationRepository compoundConfigurationRepository, ModelMapper modelMapper, ProjectConfigurationService projectConfigurationService) {
        this.compoundConfigurationRepository = compoundConfigurationRepository;
        this.modelMapper = modelMapper;
        this.projectConfigurationService = projectConfigurationService;
    }
}

