/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeToken;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessShortDto;
import org.qubership.atp.mia.exceptions.configuration.CompoundNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.CreateProcessException;
import org.qubership.atp.mia.exceptions.configuration.DeleteProcessException;
import org.qubership.atp.mia.exceptions.configuration.DuplicateProcessException;
import org.qubership.atp.mia.exceptions.configuration.ProcessNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.UpdateProcessException;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;
import org.qubership.atp.mia.repo.configuration.ProcessConfigurationRepository;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.qubership.atp.mia.service.history.impl.AbstractEntityHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessConfigurationService
extends AbstractEntityHistoryService<ProcessConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ProcessConfigurationService.class);
    private final ModelMapper modelMapper;
    private final ProcessConfigurationRepository processConfigurationRepository;
    private final ProjectConfigurationService projectConfigurationService;

    public ProcessDto addProcess(ProjectConfiguration projectConfiguration, ProcessDto processDto) {
        log.info("Attempting to create process: '{}'", (Object)processDto);
        if (projectConfiguration.getProcesses().stream().anyMatch(pc -> pc.getName().equals(processDto.getName()))) {
            log.error("Duplicate process detected: '{}'", (Object)processDto.getName());
            throw new DuplicateProcessException(processDto.getName());
        }
        try {
            ProcessConfiguration processConfiguration = (ProcessConfiguration)this.modelMapper.map((Object)processDto, ProcessConfiguration.class);
            processConfiguration.setProjectConfiguration(projectConfiguration);
            projectConfiguration.getProcesses().add(processConfiguration);
            processConfiguration.setPathToFile(processDto.getName() + ".json");
            processConfiguration.setProcessSettings((ProcessSettings)this.modelMapper.map((Object)processDto.getProcessSettings(), ProcessSettings.class));
            processConfiguration.getProcessSettings().setName(processDto.getName());
            this.syncProcessSections(projectConfiguration, processConfiguration, processDto);
            if (processDto.getInCompounds() != null) {
                log.debug("Processing compound associations for process '{}'", (Object)processDto.getName());
                List<CompoundConfiguration> compoundConfigurationList = processDto.getInCompounds().stream().map(uuid -> projectConfiguration.getCompounds().stream().filter(c -> c.getId().equals(uuid)).findFirst().orElseThrow(() -> {
                    log.error("Compound not found with ID '{}'", uuid);
                    return new CompoundNotFoundException((UUID)uuid);
                })).collect(Collectors.toList());
                processConfiguration.setInCompounds(compoundConfigurationList);
                compoundConfigurationList.forEach(s -> s.getProcesses().add(processConfiguration));
            }
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.processConfigurationRepository.save(processConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully created process '{}'", (Object)processConfiguration);
            return this.toDto(processConfiguration);
        }
        catch (Exception e) {
            log.error("Error while creating process '{}': {}", new Object[]{processDto.getName(), e.getMessage(), e});
            throw new CreateProcessException(e);
        }
    }

    public List<ProcessShortDto> deleteProcess(ProjectConfiguration projectConfiguration, UUID processId) {
        log.info("Attempting to delete process with ID '{}'", (Object)processId);
        ProcessConfiguration processConfiguration = this.getProcessById(projectConfiguration, processId);
        try {
            projectConfiguration.getAllSections().forEach(s -> s.getProcesses().remove(processConfiguration));
            projectConfiguration.getCompounds().forEach(c -> c.getProcesses().remove(processConfiguration));
            log.debug("Clearing associations for process '{}'", (Object)processConfiguration.getName());
            processConfiguration.setInSections(new ArrayList<SectionConfiguration>());
            processConfiguration.setInCompounds(new ArrayList<CompoundConfiguration>());
            processConfiguration.setCompounds(new ArrayList<String>());
            processConfiguration.setSections(new ArrayList<String>());
            projectConfiguration.getProcesses().remove(processConfiguration);
            log.debug("Executing database delete for process '{}'", (Object)processConfiguration.getName());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.processConfigurationRepository.delete(processConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully deleted process '{}'", (Object)processConfiguration);
        }
        catch (Exception e) {
            log.error("Error while deleting process with ID '{}': {}", new Object[]{processId, e.getMessage(), e});
            throw new DeleteProcessException(e);
        }
        return this.processesDto(projectConfiguration.getProcesses());
    }

    public static LinkedList<ProcessConfiguration> filterProcesses(List<ProcessConfiguration> processes, List<ProcessDto> processesDto) {
        log.trace("Filtering {} processes with {} processesDto", (Object)processes.size(), (Object)processesDto.size());
        LinkedList<ProcessConfiguration> filteredProcesses = new LinkedList<ProcessConfiguration>();
        processesDto.forEach(processDto -> processes.stream().filter(p -> p.getId().equals(processDto.getId())).findAny().ifPresent(filteredProcesses::add));
        return filteredProcesses;
    }

    public static List<ProcessConfiguration> filterProcess(List<ProcessConfiguration> processes, List<UUID> processesUuid) {
        log.trace("Filtering {} processes by {} UUIDs", (Object)processes.size(), (Object)processesUuid.size());
        ArrayList<ProcessConfiguration> filteredProcesses = new ArrayList<ProcessConfiguration>();
        processesUuid.forEach(processUuid -> processes.stream().filter(p -> p.getId().equals(processUuid)).findAny().ifPresent(filteredProcesses::add));
        return filteredProcesses;
    }

    public static List<ProcessConfiguration> filterProcessesByIdOrSourceId(List<ProcessConfiguration> processes, List<UUID> processesUuid) {
        log.trace("Filtering processes by ID or source ID, input size: {}", (Object)processesUuid.size());
        LinkedList<ProcessConfiguration> filteredProcesses = new LinkedList<ProcessConfiguration>();
        processesUuid.forEach(pUuid -> processes.stream().filter(s -> pUuid != null && (pUuid.equals(s.getId()) || pUuid.equals(s.getSourceId()))).findAny().ifPresent(filteredProcesses::add));
        return filteredProcesses;
    }

    public static void checkProcessesById(ProjectConfiguration projectConfiguration, List<ProcessConfiguration> processes) {
        processes.forEach(process -> projectConfiguration.getProcesses().stream().filter(proc -> proc.getId().equals(process.getId())).findFirst().orElseThrow(() -> {
            log.error("Process not found with ID '{}'", (Object)process.getId());
            return new ProcessNotFoundException(process.getId());
        }));
    }

    public ProcessConfiguration getProcessById(ProjectConfiguration projectConfiguration, UUID processId) {
        return projectConfiguration.getProcesses().stream().filter(proc -> proc.getId().equals(processId)).findFirst().orElseThrow(() -> {
            log.error("Process not found with ID '{}'", (Object)processId);
            return new ProcessNotFoundException(processId);
        });
    }

    public List<ProcessShortDto> processesDto(List<ProcessConfiguration> processConfigurationList) {
        if (processConfigurationList != null) {
            Type listType = new TypeToken<List<ProcessShortDto>>(){}.getType();
            return (List)this.modelMapper.map(processConfigurationList, listType);
        }
        return new ArrayList<ProcessShortDto>();
    }

    public ProcessDto toDto(ProcessConfiguration processConfiguration) {
        ProcessDto retValue = (ProcessDto)this.modelMapper.map((Object)processConfiguration, ProcessDto.class);
        retValue.getProcessSettings().getCommand().setAtpValues(processConfiguration.getProcessSettings().getCommand().getAtpValues());
        retValue.getProcessSettings().getCommand().setVariablesToExtractFromLog(processConfiguration.getProcessSettings().getCommand().getVariablesToExtractFromLog());
        return retValue;
    }

    public ProcessDto updateProcess(ProjectConfiguration projectConfiguration, ProcessDto processDto) {
        log.info("Attempting to update process: '{}'", (Object)processDto);
        ProcessConfiguration processConfiguration = projectConfiguration.getProcesses().stream().filter(proc -> proc.getId().equals(processDto.getId())).findFirst().orElseThrow(() -> {
            log.error("Process not found for update with ID '{}'", (Object)processDto.getId());
            return new ProcessNotFoundException(processDto.getId());
        });
        try {
            processConfiguration.setName(processDto.getName());
            if (processConfiguration.getPathToFile() == null || processConfiguration.getPathToFile().isEmpty()) {
                processConfiguration.setPathToFile(processDto.getName() + ".json");
            }
            this.syncProcessSections(projectConfiguration, processConfiguration, processDto);
            this.syncProcessCompounds(processConfiguration);
            log.debug("Updating process settings for '{}'", (Object)processConfiguration.getName());
            processConfiguration.setProcessSettings((ProcessSettings)this.modelMapper.map((Object)processDto.getProcessSettings(), ProcessSettings.class));
            processConfiguration.getProcessSettings().setName(processDto.getName());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.processConfigurationRepository.save(processConfiguration);
                return projectConfiguration;
            }, false);
            log.info("Successfully updated process '{}'", (Object)processConfiguration);
            return this.toDto(processConfiguration);
        }
        catch (Exception e) {
            log.error("Error while updating process '{}': '{}'", new Object[]{processConfiguration.getName(), e.getMessage(), e});
            throw new UpdateProcessException(e);
        }
    }

    private void syncProcessSections(ProjectConfiguration projectConfiguration, ProcessConfiguration processConfiguration, ProcessDto processDto) {
        if (processDto.getInSections() != null) {
            log.debug("Updating sections for process '{}'", (Object)processConfiguration.getName());
            List<SectionConfiguration> newSectionConfigurationList = SectionConfigurationService.filterSections(projectConfiguration.getAllSections(), processDto.getInSections());
            List<SectionConfiguration> oldSectionConfigurationList = processConfiguration.getInSections();
            if (!newSectionConfigurationList.equals(oldSectionConfigurationList)) {
                newSectionConfigurationList.forEach(newS -> {
                    if (!oldSectionConfigurationList.contains(newS)) {
                        newS.getProcesses().add(processConfiguration);
                    }
                });
                oldSectionConfigurationList.forEach(oldS -> {
                    if (!newSectionConfigurationList.contains(oldS)) {
                        oldS.getProcesses().remove(processConfiguration);
                    }
                });
                processConfiguration.setInSections(newSectionConfigurationList);
                log.debug("Successfully updated sections for process '{}'", (Object)processConfiguration.getName());
                processConfiguration.setSections(newSectionConfigurationList.stream().map(SectionConfiguration::getName).collect(Collectors.toList()));
                log.debug("Updated section names for process '{}'", (Object)processConfiguration.getName());
            }
            if (processConfiguration.getSections() == null || processConfiguration.getSections().isEmpty()) {
                processConfiguration.setSections(newSectionConfigurationList.stream().map(SectionConfiguration::getName).collect(Collectors.toList()));
                log.debug("Updated section names for process '{}'", (Object)processConfiguration.getName());
            }
        }
    }

    private void syncProcessCompounds(ProcessConfiguration processConfiguration) {
        if (processConfiguration.getCompounds() == null || processConfiguration.getCompounds().isEmpty()) {
            processConfiguration.setCompounds(processConfiguration.getInCompounds().stream().map(CompoundConfiguration::getName).collect(Collectors.toList()));
            log.debug("Updated compound names for process '{}'", (Object)processConfiguration.getName());
        }
    }

    @Override
    public ProcessConfiguration get(UUID id) {
        return (ProcessConfiguration)this.processConfigurationRepository.findById(id).orElseThrow(MiaHistoryRevisionRestoreException::new);
    }

    @Override
    public ProcessConfiguration restore(DateAuditorEntity entity) {
        log.info("Restoring process configuration '{}'", (Object)entity);
        ProcessConfiguration processConfiguration = (ProcessConfiguration)entity;
        ProjectConfiguration projectConfiguration = processConfiguration.getProjectConfiguration();
        this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
            this.processConfigurationRepository.save(processConfiguration);
            return projectConfiguration;
        }, false);
        log.info("Successfully restored process configuration '{}'", (Object)processConfiguration.getName());
        return processConfiguration;
    }

    public ProcessConfigurationService(ModelMapper modelMapper, ProcessConfigurationRepository processConfigurationRepository, ProjectConfigurationService projectConfigurationService) {
        this.modelMapper = modelMapper;
        this.processConfigurationRepository = processConfigurationRepository;
        this.projectConfigurationService = projectConfigurationService;
    }
}

