/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.util.Strings;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectConfigurationDto;
import org.qubership.atp.mia.exceptions.configuration.DeserializeJsonConfigFailedException;
import org.qubership.atp.mia.exceptions.configuration.UpdateConfigurationException;
import org.qubership.atp.mia.exceptions.fileservice.ArchiveFileNotFoundException;
import org.qubership.atp.mia.exceptions.fileservice.ArchiveIoExceptionDuringClose;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.repo.configuration.ProjectConfigurationRepository;
import org.qubership.atp.mia.repo.db.RecordingSessionRepository;
import org.qubership.atp.mia.service.configuration.ConfigurationFileDeserializer;
import org.qubership.atp.mia.service.configuration.ConfigurationFileSerializer;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.service.git.GitService;
import org.qubership.atp.mia.service.history.impl.AbstractEntityHistoryService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ProjectConfigurationService
extends AbstractEntityHistoryService<ProjectConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ProjectConfigurationService.class);
    private final ConfigurationFileDeserializer configurationFileDeserializer;
    private final ConfigurationFileSerializer configurationFileSerializer;
    private final MiaFileService miaFileService;
    private final GitService gitService;
    private final Path miaConfigPath;
    private final ModelMapper modelMapper;
    private final ProjectConfigurationRepository projectConfigurationRepository;
    private final RecordingSessionRepository recordingSessionRepository;
    private final ProjectConfigurationService self;
    private final ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<Resource> archiveConfigToZip(UUID projectId) {
        ProjectConfiguration projectConfiguration = this.getConfigByProjectId(projectId);
        UUID sessionId = UUID.randomUUID();
        Path pathForConfiguration = this.getProjectPathWithType(projectId, ProjectFileType.MIA_FILE_TYPE_LOG, sessionId).resolve("project_configuration");
        pathForConfiguration.toFile().mkdirs();
        try {
            this.configurationFileSerializer.serializeToPath(projectConfiguration, pathForConfiguration);
            String zipName = String.format("project_configuration_%s_%s.zip", projectId, sessionId);
            Path zipPath = this.getProjectPathWithType(projectId, ProjectFileType.MIA_FILE_TYPE_LOG, sessionId).resolve(zipName);
            try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipPath.toFile())));){
                File[] files = pathForConfiguration.toFile().listFiles();
                if (files != null) {
                    for (File file : files) {
                        FileUtils.addDirToZipArchive(zos, file, null, null);
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new ArchiveFileNotFoundException(pathForConfiguration);
            }
            catch (IOException e) {
                throw new ArchiveIoExceptionDuringClose(pathForConfiguration, e);
            }
            ResponseEntity<Resource> responseEntity = this.miaFileService.downloadFile(projectId, ProjectFileType.MIA_FILE_TYPE_LOG, sessionId, zipName, this.servletContext);
            return responseEntity;
        }
        finally {
            FileUtils.deleteFolder(pathForConfiguration.toFile(), true);
        }
    }

    public Optional<ProjectConfiguration> findByProjectId(UUID projectId) {
        return this.projectConfigurationRepository.findById(projectId);
    }

    @Cacheable(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectId", condition="#projectId != null")
    public ProjectConfiguration getConfigByProjectId(UUID projectId) {
        return this.getConfiguration(projectId);
    }

    public ProjectConfiguration getConfiguration(UUID projectId) {
        return this.findByProjectId(projectId).orElseGet(() -> {
            Path pathForConfiguration = this.getProjectPathWithType(projectId, ProjectFileType.MIA_FILE_TYPE_CONFIGURATION, null).resolve(String.valueOf(System.currentTimeMillis()));
            Path pathForDefaultConfiguration = this.miaConfigPath.resolve("project").resolve("default");
            try {
                pathForConfiguration.toFile().mkdirs();
                FileUtils.copyFolder(pathForDefaultConfiguration, pathForConfiguration);
                ProjectConfiguration defaultProjectConfiguration = this.loadConfigurationFromFile((ProjectConfiguration)((ProjectConfiguration.ProjectConfigurationBuilder)ProjectConfiguration.builder().projectId(projectId)).build(), pathForConfiguration, false);
                log.info("DEFAULT configuration parsed successfully. Save it!");
                ProjectConfiguration projectConfiguration = (ProjectConfiguration)this.projectConfigurationRepository.save(defaultProjectConfiguration);
                return projectConfiguration;
            }
            catch (Exception e) {
                throw new DeserializeJsonConfigFailedException("Failed copy files for DEFAULT project to " + pathForConfiguration, e.getMessage());
            }
            finally {
                FileUtils.deleteFolder(pathForConfiguration.toFile(), true);
            }
        });
    }

    public FlowConfigDto getOldConfig(UUID projectId) {
        return this.configurationFileSerializer.getOldConfig(this.self.getConfigByProjectId(projectId), false);
    }

    public Path getProjectPathWithType(UUID projectId, ProjectFileType projectFileType, UUID sessionId) {
        log.trace("Creating project path for projectId: '{}', type: '{}', sessionId: '{}'", new Object[]{projectId, projectFileType, sessionId});
        Path path = FileMetaData.PROJECT_FOLDER.resolve(projectId.toString()).resolve(projectFileType.name()).resolve(sessionId == null ? "" : sessionId.toString());
        FileUtils.createDirectories(path);
        return path;
    }

    @Transactional
    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectConfiguration.projectId", condition="#projectConfiguration.projectId != null")
    public ProjectConfiguration hardReloadConfiguration(ProjectConfiguration projectConfiguration) {
        return this.hardReloadConfiguration(projectConfiguration, false);
    }

    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectConfiguration.projectId", condition="#projectConfiguration.projectId != null")
    public ProjectConfiguration hardReloadConfiguration(ProjectConfiguration projectConfiguration, boolean isMigration) {
        try {
            if (projectConfiguration.getGitUrl() != null && !projectConfiguration.getGitUrl().isEmpty()) {
                return this.loadConfigurationFromGit(projectConfiguration, isMigration);
            }
        }
        catch (IOException e) {
            log.error("Error while loading Configuration from GIT: {}", (Object)e.getMessage());
        }
        return projectConfiguration;
    }

    @Transactional
    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectId", condition="#projectId != null")
    public ProjectConfiguration loadConfigFromZip(UUID projectId, MultipartFile file) {
        File archivePath = null;
        try {
            ProjectConfiguration projectConfiguration;
            block10: {
                archivePath = FileMetaData.PROJECT_FOLDER.resolve(projectId.toString()).resolve(this.miaFileService.uploadConfigurationFileOnBe(file)).toFile();
                File unzippedDir = null;
                try {
                    ProjectConfiguration projectConfiguration2;
                    unzippedDir = FileUtils.unzipConfig(archivePath, new File(archivePath.getParent(), "unzipped-" + System.currentTimeMillis()));
                    projectConfiguration = projectConfiguration2 = this.loadConfigurationFromGit((ProjectConfiguration)((ProjectConfiguration.ProjectConfigurationBuilder)((ProjectConfiguration.ProjectConfigurationBuilder)ProjectConfiguration.builder().projectId(projectId)).gitUrl(unzippedDir.toString())).build(), true);
                    if (unzippedDir == null) break block10;
                }
                catch (IOException e) {
                    try {
                        throw new ArchiveIoExceptionDuringClose(unzippedDir, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (unzippedDir != null) {
                            FileUtils.deleteFolder(unzippedDir, true);
                        }
                        throw throwable;
                    }
                }
                FileUtils.deleteFolder(unzippedDir, true);
            }
            return projectConfiguration;
        }
        finally {
            if (archivePath != null && archivePath.exists() && !archivePath.isDirectory()) {
                archivePath.delete();
            }
        }
    }

    public ProjectConfiguration loadConfigurationFromGit(ProjectConfiguration projectConfiguration, boolean isMigration) throws IOException {
        log.info("Load configuration for '{}' from '{}'", (Object)projectConfiguration.getProjectId(), (Object)projectConfiguration.getGitUrl());
        Path pathForConfiguration = this.getProjectPathWithType(projectConfiguration.getProjectId(), ProjectFileType.MIA_FILE_TYPE_CONFIGURATION, null).resolve(String.valueOf(System.currentTimeMillis()));
        try {
            pathForConfiguration.toFile().mkdirs();
            if (projectConfiguration.getGitUrl().startsWith("http")) {
                this.gitService.downloadGitRepo(projectConfiguration.getGitUrl(), pathForConfiguration);
            } else {
                FileUtils.copyFolder(Paths.get(projectConfiguration.getGitUrl(), new String[0]), pathForConfiguration);
            }
            this.loadConfigurationFromFile(projectConfiguration, pathForConfiguration, isMigration);
            projectConfiguration.setLastLoadedWhen(LocalDateTime.now());
            log.info("Project with ID '{}' has been parsed successfully, save it", (Object)projectConfiguration.getProjectId());
            if (isMigration) {
                this.self.removeProject(projectConfiguration.getProjectId(), false);
                projectConfiguration.setPrimaryMigrationDone(true);
            }
            if (Strings.isNotBlank((String)projectConfiguration.getGitUrl()) && !projectConfiguration.getGitUrl().startsWith("http")) {
                projectConfiguration.setGitUrl(null);
            }
            ProjectConfiguration projectConfiguration2 = (ProjectConfiguration)this.projectConfigurationRepository.save(projectConfiguration);
            return projectConfiguration2;
        }
        catch (IOException e) {
            throw new DeserializeJsonConfigFailedException("Failed copy files from " + projectConfiguration.getGitUrl() + " to " + pathForConfiguration, e.getMessage());
        }
        catch (Exception e) {
            log.error("Failed to deserialize configuration for project '{}': {}", (Object)projectConfiguration.getProjectId(), (Object)e.getMessage());
            throw new DeserializeJsonConfigFailedException("Failed to deserialize", e.getMessage());
        }
        finally {
            FileUtils.deleteFolder(pathForConfiguration.toFile(), true);
        }
    }

    @Transactional
    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectId", condition="#projectId != null")
    public void removeProject(UUID projectId, Boolean withPot) {
        this.projectConfigurationRepository.deleteByProjectId(projectId);
        if (withPot != null && withPot.booleanValue()) {
            this.recordingSessionRepository.deleteByProjectId(projectId);
        }
        log.info("Project with ID {} removed successfully!", (Object)projectId);
    }

    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectId")
    @Transactional
    public void synchronizeConfiguration(UUID projectId, Supplier<ProjectConfiguration> saveConfiguration, boolean isEthalonFiles) {
        ProjectConfiguration updatedProjectConfiguration = saveConfiguration.get();
        if (updatedProjectConfiguration.getGitUrl() != null && !updatedProjectConfiguration.getGitUrl().isEmpty()) {
            Path pathForConfiguration = this.getProjectPathWithType(projectId, ProjectFileType.MIA_FILE_TYPE_CONFIGURATION, null).resolve(UUID.randomUUID().toString());
            this.configurationFileSerializer.serialize(updatedProjectConfiguration, pathForConfiguration, isEthalonFiles);
        }
    }

    public ProjectConfigurationDto toDto(ProjectConfiguration projectConfiguration) {
        return (ProjectConfigurationDto)this.modelMapper.map((Object)projectConfiguration, ProjectConfigurationDto.class);
    }

    @Transactional
    @CacheEvict(value={"ATP_MIA_CONFIGURATION_OS"}, key="#projectConfiguration.projectId", condition="#projectConfiguration.projectId != null")
    public ProjectConfigurationDto updateConfiguration(ProjectConfiguration projectConfiguration, ProjectConfigurationDto projectConfigurationDto) {
        log.info("Update project configuration: '{}'", (Object)projectConfigurationDto);
        try {
            UUID projectId = projectConfiguration.getProjectId();
            ProjectConfiguration projectConfigurationEntity = (ProjectConfiguration)this.modelMapper.map((Object)projectConfigurationDto, ProjectConfiguration.class);
            if (Strings.isNotBlank((String)projectConfigurationEntity.getGitUrl()) && !projectConfigurationEntity.getGitUrl().equals(projectConfiguration.getGitUrl())) {
                projectConfiguration = this.self.hardReloadConfiguration((ProjectConfiguration)((ProjectConfiguration.ProjectConfigurationBuilder)((ProjectConfiguration.ProjectConfigurationBuilder)ProjectConfiguration.builder().projectId(projectId)).gitUrl(projectConfigurationDto.getGitUrl())).build(), true);
            } else {
                projectConfiguration.setGitUrl(projectConfigurationEntity.getGitUrl());
                if (projectConfigurationDto.getCommonConfiguration() != null) {
                    projectConfigurationEntity.getCommonConfiguration().setProjectId(projectId);
                    projectConfigurationEntity.getCommonConfiguration().updateShellPrefixes();
                    projectConfiguration.setCommonConfiguration(projectConfigurationEntity.getCommonConfiguration());
                }
                if (projectConfigurationDto.getHeaderConfiguration() != null) {
                    projectConfigurationEntity.getHeaderConfiguration().setProjectId(projectId);
                    projectConfiguration.setHeaderConfiguration(projectConfigurationEntity.getHeaderConfiguration());
                }
                if (projectConfigurationDto.getPotHeaderConfiguration() != null) {
                    projectConfigurationEntity.getPotHeaderConfiguration().setProjectId(projectId);
                    projectConfiguration.setPotHeaderConfiguration(projectConfigurationEntity.getPotHeaderConfiguration());
                }
                this.updateProject(projectConfiguration, false);
            }
            log.info("Successfully updated configuration for project '{}'", (Object)projectConfiguration.getProjectId());
            return this.toDto(projectConfiguration);
        }
        catch (Exception e) {
            throw new UpdateConfigurationException(e);
        }
    }

    public void updateProject(ProjectConfiguration projectConfiguration, boolean isEthalonFiles) {
        this.self.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> (ProjectConfiguration)this.projectConfigurationRepository.save(projectConfiguration), isEthalonFiles);
    }

    public void updateProjectWithReplicationOff(ProjectConfiguration projectConfiguration, boolean isEthalonFiles) {
        this.self.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
            try {
                this.projectConfigurationRepository.setReplicationRoleReplica();
                ProjectConfiguration projectConfiguration2 = (ProjectConfiguration)this.projectConfigurationRepository.save(projectConfiguration);
                return projectConfiguration2;
            }
            finally {
                this.projectConfigurationRepository.setReplicationRoleOrigin();
            }
        }, isEthalonFiles);
    }

    private ProjectConfiguration loadConfigurationFromFile(ProjectConfiguration projectConfiguration, Path pathFlowJson, boolean isMigration) {
        log.trace("Loading configuration from file for project '{}' at path '{}'", (Object)projectConfiguration.getProjectId(), (Object)pathFlowJson);
        try {
            return this.configurationFileDeserializer.deserialize(pathFlowJson, projectConfiguration, this.getProjectPathWithType(projectConfiguration.getProjectId(), ProjectFileType.MIA_FILE_TYPE_PROJECT, null), isMigration);
        }
        catch (Exception e) {
            throw new DeserializeJsonConfigFailedException("Error in deserialize config", e);
        }
    }

    @Override
    public ProjectConfiguration get(UUID id) {
        return (ProjectConfiguration)this.projectConfigurationRepository.findById(id).orElseThrow(MiaHistoryRevisionRestoreException::new);
    }

    @Override
    public ProjectConfiguration restore(DateAuditorEntity entity) {
        log.info("Restoring project configuration '{}'", (Object)entity);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)entity;
        this.updateProject(projectConfiguration, false);
        log.info("Successfully restored project configuration '{}'", (Object)projectConfiguration.getProjectId());
        return projectConfiguration;
    }

    public ProjectConfigurationService(ConfigurationFileDeserializer configurationFileDeserializer, ConfigurationFileSerializer configurationFileSerializer, MiaFileService miaFileService, GitService gitService, Path miaConfigPath, ModelMapper modelMapper, ProjectConfigurationRepository projectConfigurationRepository, RecordingSessionRepository recordingSessionRepository, ProjectConfigurationService self, ServletContext servletContext) {
        this.configurationFileDeserializer = configurationFileDeserializer;
        this.configurationFileSerializer = configurationFileSerializer;
        this.miaFileService = miaFileService;
        this.gitService = gitService;
        this.miaConfigPath = miaConfigPath;
        this.modelMapper = modelMapper;
        this.projectConfigurationRepository = projectConfigurationRepository;
        this.recordingSessionRepository = recordingSessionRepository;
        this.self = self;
        this.servletContext = servletContext;
    }
}

