/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.configuration.CompoundHasNoProcessesException;
import org.qubership.atp.mia.exceptions.configuration.NotACompoundException;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.Switcher;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.model.impl.request.ProcessRequest;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.SseEmitterService;
import org.qubership.atp.mia.service.execution.ProcessService;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.HttpUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class CompoundService {
    private static final Logger log = LoggerFactory.getLogger(CompoundService.class);
    private final MiaContext miaContext;
    private final ProcessService processService;
    private final MetricsAggregateService metricsService;
    private final String miaEntityUrlFormat;
    private final SseEmitterService sseEmitterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AtpJaegerLog(spanTags={@AtpSpanTag(key="compound.name", value="#request.compound.name")})
    public LinkedList<ExecutionResponse> executeCompound(ExecutionRequest request, UUID sseId) {
        String compoundName = request.getCompound() == null ? null : request.getCompound().getName();
        log.info("Execute compound with name '{}'", (Object)compoundName);
        LinkedList<ExecutionResponse> responses = new LinkedList<ExecutionResponse>();
        ProjectConfiguration config = this.miaContext.getConfig();
        UUID projectId = config.getProjectId();
        this.metricsService.compoundExecutionWasStarted();
        if (request.getCompound() != null) {
            try {
                CompoundConfiguration compound = config.getCompoundByName(compoundName);
                MDC.put((String)"miaCompoundId", (String)compound.getId().toString());
                if (this.skipByReferToInput(compound.getReferToInput())) {
                    String warning = "SKIPPED Compound '" + compound.getName() + "' for project with ID " + projectId + " due to '" + compound.getReferToInput() + "' parameter";
                    log.warn(warning);
                    ExecutionResponse response = new ExecutionResponse();
                    response.setProcessName(compound.getProcesses().get(0).getName());
                    response.setWarn(warning);
                    responses.add(response);
                    this.sseEmitterService.updateResponseAndSendToEmitter(response, sseId, true, 0);
                    return responses;
                }
                List<Switcher> systemSwitchersBe = config.getHeaderConfiguration().getSystemSwitchers();
                this.processService.getActualStateOfSwitchers(systemSwitchersBe, request.getSystemSwitchers());
                boolean stopOnFail = Utils.getSystemSwitcherByName(Constants.SystemSwitcherNames.stopOnFail, systemSwitchersBe).isValue();
                log.info("Define process to execute of compound with name '{}'", (Object)compoundName);
                List<ProcessConfiguration> processesList = compound.getProcesses();
                if (processesList == null) {
                    throw new CompoundHasNoProcessesException(compound.getName());
                }
                ArrayList processesListFromRequest = request.getCompound() != null && request.getCompound().getProcessList() != null ? request.getCompound().getProcessList() : new ArrayList();
                for (int processId = 0; processId < processesList.size(); ++processId) {
                    boolean statusFail;
                    ProcessConfiguration proc = processesList.get(processId);
                    ExecutionResponse response = new ExecutionResponse();
                    response.setProcessName(proc.getName());
                    try {
                        request.setProcess(proc.getName());
                        if (processId < processesListFromRequest.size()) {
                            ProcessRequest requestProcess = (ProcessRequest)processesListFromRequest.get(processId);
                            if ("MIA_REEXECUTE_SKIP".equals(requestProcess.getName())) {
                                response.setWarn("Process skipped due to re-execution");
                                continue;
                            }
                            if (requestProcess.getName().equals(proc.getName()) && requestProcess.getCommand() != null) {
                                if (!Strings.isNullOrEmpty((String)requestProcess.getCommand().getValue())) {
                                    request.setCommand(requestProcess.getCommand().getValue());
                                } else {
                                    request.setCommand(null);
                                }
                                request.setRest(requestProcess.getCommand().getRest());
                            }
                        }
                        if (this.skipByReferToInput(proc.getProcessSettings().getReferToInput())) {
                            String warning = "SKIPPED process " + proc.getName() + " in scope of Compound '" + compound.getName() + "' for project with ID " + projectId + " due to '" + proc.getProcessSettings().getReferToInput() + "' parameter";
                            log.warn(warning);
                            response.setWarn(warning);
                        } else {
                            response = this.processService.executeProcess(request, null);
                            response.setEntityId(compound.getId());
                            response.setEntityUrl(HttpUtils.getMiaEntityUrl(this.miaEntityUrlFormat, this.miaContext.getProjectId(), compound.getId()));
                        }
                    }
                    catch (MiaException e) {
                        log.error("{} Error during process execution {}", (Object)e.getReason(), (Object)e.getMessage());
                        response.setError(e);
                    }
                    catch (Exception e) {
                        log.error("Error during process execution {}", (Object)e.getMessage());
                        response.setError(new MiaException(e));
                    }
                    finally {
                        responses.add(response);
                        request.setProcess(null);
                        request.setCommand(null);
                        if (response.getGlobalVariables() != null) {
                            this.miaContext.getFlowData().addParameters(response.getGlobalVariables());
                        }
                    }
                    boolean bl = statusFail = response.getProcessStatus() != null && response.getProcessStatus().getStatus() == Statuses.FAIL;
                    if (stopOnFail && (response.getError() != null || statusFail)) {
                        log.warn(ErrorCodes.MIA_0001_STOP_ON_FAIL.getMessage(proc.getName(), response.getError() == null ? "response don't have error" : "status is FAIL"));
                        this.sseEmitterService.updateResponseAndSendToEmitter(response, sseId, true, processId);
                        break;
                    }
                    this.sseEmitterService.updateResponseAndSendToEmitter(response, sseId, processId == processesList.size() - 1, processId);
                }
            }
            catch (ClassCastException e) {
                NotACompoundException exception = new NotACompoundException(request.getCompound().getName());
                if (sseId != null) {
                    this.sseEmitterService.sendError(sseId, exception);
                }
                throw exception;
            }
        }
        return responses;
    }

    private boolean skipByReferToInput(String referToInput) {
        boolean skip = false;
        if (!Strings.isNullOrEmpty((String)referToInput)) {
            Map<String, String> parameters = this.miaContext.getFlowData().getParameters();
            skip = !parameters.containsKey(referToInput) || parameters.entrySet().stream().anyMatch(stringStringEntry -> ((String)stringStringEntry.getKey()).equals(referToInput) && (Strings.isNullOrEmpty((String)((String)stringStringEntry.getValue())) || "false".equals(stringStringEntry.getValue())));
        }
        return skip;
    }

    public CompoundService(MiaContext miaContext, ProcessService processService, MetricsAggregateService metricsService, String miaEntityUrlFormat, SseEmitterService sseEmitterService) {
        this.miaContext = miaContext;
        this.processService = processService;
        this.metricsService = metricsService;
        this.miaEntityUrlFormat = miaEntityUrlFormat;
        this.sseEmitterService = sseEmitterService;
    }
}

