/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.xml.ws.Holder;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.mia.component.QueryDriverFactory;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlBillDateFailException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlCommandUnsupportedException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.StoreCsvExceptionDuringSave;
import org.qubership.atp.mia.exceptions.businesslogic.sql.StoreCsvFileNotFoundException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.StoreCsvIoExceptionDuringClose;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.Validation;
import org.qubership.atp.mia.model.pot.db.DbAnswer;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.repo.driver.QueryDriver;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SqlExecutionHelperService {
    private static final Logger log = LoggerFactory.getLogger(SqlExecutionHelperService.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;
    private final QueryDriverFactory driverFactory;
    private final String fileDownloadPrefix;
    @Value(value="${db.execution.records.limit:50}")
    protected int dbExecutionRecordsLimit;

    private static void storeTableToCsv(SqlResponse sqlResponse, File targetFile) {
        log.info("Initiating CSV export to: {}", (Object)targetFile.getAbsolutePath());
        Path safeDir = Optional.ofNullable(targetFile.getParentFile()).map(File::toPath).orElse(Paths.get(".", new String[0])).toAbsolutePath().normalize();
        Path safePath = safeDir.resolve(targetFile.getName()).normalize();
        FileUtils.createFolder(safePath.toFile());
        log.debug("Resolved safe path for CSV: {}", (Object)safePath);
        try (FileOutputStream stream = new FileOutputStream(safePath.toFile());){
            if (sqlResponse.getData() != null) {
                List<String> columns = sqlResponse.getData().getColumns();
                SqlExecutionHelperService.writeLine(columns, stream, true);
                List<List<String>> data = sqlResponse.getData().getData();
                data.forEach(row -> SqlExecutionHelperService.writeLine(row, stream, true));
            } else {
                SqlExecutionHelperService.writeLine(Collections.singleton(""), stream, true);
            }
            SqlExecutionHelperService.writeLine(Collections.singleton(""), stream, true);
            if (sqlResponse.getQuery() != null) {
                SqlExecutionHelperService.writeLine(Collections.singleton(sqlResponse.getQuery()), stream, false);
            } else {
                SqlExecutionHelperService.writeLine(Collections.singleton(""), stream, true);
            }
            SqlExecutionHelperService.writeLine(Collections.singleton(""), stream, true);
            if (sqlResponse.getDescription() != null) {
                SqlExecutionHelperService.writeLine(Collections.singleton(sqlResponse.getDescription()), stream, true);
            } else {
                SqlExecutionHelperService.writeLine(Collections.singleton(""), stream, true);
            }
            log.info("CSV export completed: {}", (Object)safePath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new StoreCsvFileNotFoundException(targetFile.toPath());
        }
        catch (IOException e) {
            throw new StoreCsvIoExceptionDuringClose(targetFile.toPath(), e);
        }
        catch (Exception e) {
            throw new StoreCsvExceptionDuringSave(targetFile.toPath(), e);
        }
    }

    private static void writeLine(Collection<String> columns, FileOutputStream stream, boolean replace) {
        columns.forEach(column -> {
            try {
                byte[] value;
                if (column == null) {
                    value = EMPTY_BYTES;
                } else {
                    if (replace) {
                        column = column.replace(",", ".");
                    }
                    value = column.getBytes(StandardCharsets.UTF_8);
                }
                stream.write(value);
                stream.write(44);
            }
            catch (IOException e) {
                throw new SqlBillDateFailException(columns, e);
            }
        });
        try {
            stream.write(10);
        }
        catch (IOException e) {
            throw new SqlBillDateFailException(columns, e);
        }
    }

    @AtpJaegerLog
    public List<CommandResponse> executeCommand(String query, String system, Map<String, String> additionalParams, boolean toLimitRecords) {
        ArrayList<CommandResponse> responses = new ArrayList<CommandResponse>();
        Server server = this.miaContext.getFlowData().getSystem(system).getServer(Server.ConnectionType.DB);
        this.miaContext.getFlowData().addParameters(server.getProperties());
        query = this.miaContext.evaluate(query);
        if (query.toLowerCase().endsWith(".sql")) {
            String content = FileUtils.readFile(this.miaFileService.getFile(query).toPath());
            String sqlToExecute = this.miaContext.evaluate(this.miaContext.evaluate(content), additionalParams);
            if (sqlToExecute.toLowerCase().startsWith("declare") || sqlToExecute.toLowerCase().startsWith("begin") || sqlToExecute.toLowerCase().startsWith("do")) {
                SqlResponse sqlResponse = new SqlResponse(server);
                sqlResponse.setQuery(sqlToExecute);
                this.driverFactory.getDriver(server).executeStoredProcedure(server, sqlToExecute);
                String status = "SUCCESS";
                DbTable dbTable = new DbTable(Collections.singletonList("STORE PROCEDURE STATUS"), Collections.singletonList(Collections.singletonList("SUCCESS")));
                sqlResponse.setData(dbTable);
                sqlResponse.setRecords(1);
                responses.add(new CommandResponse(sqlResponse));
                this.saveSqlTableToFile(Collections.singletonList(sqlResponse));
            } else {
                for (SqlResponse sqlResponse : this.handleSingleQuery(sqlToExecute, server, toLimitRecords)) {
                    responses.add(new CommandResponse(sqlResponse));
                }
            }
        } else {
            for (SqlResponse sqlResponse : this.handleSingleQuery(query, server, toLimitRecords)) {
                responses.add(new CommandResponse(sqlResponse));
            }
        }
        return responses;
    }

    public List<CommandResponse> executeCommand(@Nonnull String query, @Nonnull String system) {
        return this.executeCommand(query, system, new HashMap<String, String>(), true);
    }

    @AtpJaegerLog
    public List<SqlResponse> executeValidations(List<Validation> validations, Command command) {
        ArrayList<SqlResponse> response = new ArrayList<SqlResponse>();
        CountDownLatch latch = new CountDownLatch(validations.size());
        for (Validation validation : validations) {
            List<String> queries;
            String tableName;
            String value;
            Server server;
            block7: {
                String systemName = validation.getSystem();
                validation.setSystem(this.miaContext.evaluate(systemName));
                if (this.skipValidation(validation, command)) {
                    log.debug("Validation has been skipped : " + validation);
                    latch.countDown();
                    continue;
                }
                server = this.miaContext.getFlowData().getSystem(systemName).getServer(Server.ConnectionType.DB);
                this.miaContext.getFlowData().addParameters(server.getProperties());
                value = this.miaContext.evaluate(validation.getValue());
                tableName = validation.getTableName();
                log.trace("Prepare query: " + value);
                if (value != null && value.endsWith(".sql")) {
                    try {
                        Path safePath = this.getSafeValidatedPath(value);
                        String content = this.miaContext.evaluate(FileUtils.readFile(safePath));
                        queries = Arrays.asList(content.split(";\\r?\\n?"));
                        break block7;
                    }
                    catch (SecurityException se) {
                        String error = "Invalid SQL file path detected (path traversal attempt?): " + value;
                        this.addSqlResponseWithError(response, error, server);
                        log.error(error, (Throwable)se);
                        latch.countDown();
                        continue;
                    }
                }
                queries = Collections.singletonList(value);
            }
            if (queries.size() > 0) {
                for (String query : queries) {
                    log.debug("Execute validation query: " + query);
                    response.add(this.executeQuery(server, query, tableName, validation.isSaveToWordFile(), validation.isSaveToZipFile()));
                }
                continue;
            }
            String warnMessage = String.format("No queries were found in the file %s for validation", value);
            this.addSqlResponseWithError(response, warnMessage, server);
            log.warn(warnMessage);
        }
        this.saveSqlTableToFile(response);
        response.stream().map(SqlResponse::getLink).filter(Objects::nonNull).forEach(link -> link.setPath(this.fileDownloadPrefix + link.getPath()));
        return response;
    }

    private Path getSafeValidatedPath(String relativePath) {
        Path baseDir = this.miaContext.getProjectFilePath().toAbsolutePath().normalize();
        Path targetPath = baseDir.resolve(relativePath).normalize();
        if (!targetPath.startsWith(baseDir)) {
            throw new SecurityException("Path traversal attempt detected: " + relativePath);
        }
        if (!Files.exists(targetPath, new LinkOption[0]) || !Files.isRegularFile(targetPath, new LinkOption[0])) {
            throw new SecurityException("SQL file does not exist or is not a regular file: " + relativePath);
        }
        return targetPath;
    }

    @AtpJaegerLog
    public List<SqlResponse> handleSingleQuery(String query, Server server, boolean toLimitRecords) {
        query = this.miaContext.evaluate(query);
        ArrayList<String> queries = new ArrayList<String>();
        ArrayList<SqlResponse> responses = new ArrayList<SqlResponse>();
        if (query.contains(";")) {
            queries.addAll(Arrays.asList(query.split(";\\r?\\n?")));
        } else {
            queries.add(query);
        }
        QueryDriver<?> driver = this.driverFactory.getDriver(server);
        for (String queryFromList : queries) {
            queryFromList = queryFromList.trim();
            SqlResponse response = new SqlResponse(server);
            response.setQuery(queryFromList);
            log.debug("Execute query: " + query);
            if (queryFromList.toLowerCase().startsWith("select")) {
                DbTable dbTable = driver.executeQuery(server, queryFromList, toLimitRecords ? this.dbExecutionRecordsLimit : 0);
                if (toLimitRecords && dbTable.getActualDataSizeBeforeLimit() > this.dbExecutionRecordsLimit) {
                    response.setLimitRecordsMessage("The number of returned rows exceeds the maximum allowed number of " + this.dbExecutionRecordsLimit + " rows");
                    log.info("The number of returned rows exceeds the maximum allowed number of {} rows. Actual Records size is {}", (Object)this.dbExecutionRecordsLimit, (Object)dbTable.getActualDataSizeBeforeLimit());
                }
                response.setData(dbTable);
                response.setRecords(dbTable.getData().size());
            } else if (queryFromList.toLowerCase().startsWith("update") || queryFromList.toLowerCase().startsWith("insert") || queryFromList.toLowerCase().startsWith("drop") || queryFromList.toLowerCase().startsWith("create") || queryFromList.toLowerCase().startsWith("delete")) {
                int affected = driver.executeUpdate(server, queryFromList);
                response.setDescription("Affected rows: " + affected);
            } else if (queryFromList.toLowerCase().startsWith("with")) {
                DbAnswer res = driver.executeStoredProcedure(server, queryFromList);
                res.updateSqlResponse(response);
            } else {
                throw new SqlCommandUnsupportedException(queryFromList);
            }
            responses.add(response);
        }
        this.saveSqlTableToFile(responses);
        return responses;
    }

    @AtpJaegerLog
    public String getNextBillDate() {
        String nextBillDateSql = this.miaContext.getConfig().getCommonConfiguration().getNextBillDateSql();
        String system = this.miaContext.getConfig().getCommonConfiguration().getDefaultSystem();
        String accountNumberTrim = this.miaContext.getFlowData().getCustom(Constants.CustomParameters.ACCOUNT_NUMBER, this.miaContext).trim().replaceAll(" ", "_");
        log.trace("Performing of nextBillDate query for {} system", (Object)system);
        Server server = this.miaContext.getFlowData().getSystem(system).getServer(Server.ConnectionType.DB);
        try {
            return this.driverFactory.getDriver(server).executeQueryAndGetFirstValue(server, nextBillDateSql.replace(":accountNumber", accountNumberTrim));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SqlBillDateFailException(accountNumberTrim, e);
        }
    }

    @AtpJaegerLog
    public boolean resetDbCache() {
        CommonConfiguration commonConfig = this.miaContext.getConfig().getCommonConfiguration();
        String system = commonConfig.getDefaultSystem();
        log.trace("Performing of resetCache for {} system", (Object)system);
        Server server = this.miaContext.getFlowData().getSystem(system).getServer(Server.ConnectionType.DB);
        return this.driverFactory.getDriver(server).executeStoredProcedure(server, commonConfig.getResetCacheSql()).isStatus();
    }

    public void saveSqlTableToFile(List<SqlResponse> sqlResponses) {
        if (this.miaContext.getConfig().getCommonConfiguration().isSaveSqlTablesToFile()) {
            for (SqlResponse sqlResponse : sqlResponses) {
                String fileName = this.miaContext.createTableFileName(sqlResponse.getTableName());
                Holder file = new Holder((Object)this.miaContext.getLogPath().resolve(fileName).toFile());
                SqlExecutionHelperService.storeTableToCsv(sqlResponse, (File)file.value);
                String internalPathToFile = ((File)file.value).getPath();
                sqlResponse.setInternalPathToFile(internalPathToFile, this.miaContext);
            }
        }
    }

    private boolean skipValidation(@Nonnull Validation validation, @Nonnull Command command) {
        List<String> refers = validation.getReferToCommandExecution();
        return refers != null && !refers.stream().anyMatch(r -> r.equalsIgnoreCase("any") || command.getToExecute().toLowerCase().contains(r.toLowerCase()));
    }

    private void addSqlResponseWithError(List<SqlResponse> response, String error, Server server) {
        SqlResponse sqlResponse = new SqlResponse(server);
        sqlResponse.setDescription(error);
        response.add(sqlResponse);
    }

    private SqlResponse executeQuery(Server server, String query, String tableName, boolean saveToWordFile, boolean saveToZipFile) {
        return this.driverFactory.getDriver(server).executeQuery(server, query, tableName, saveToWordFile, saveToZipFile, this.dbExecutionRecordsLimit);
    }

    public SqlExecutionHelperService(MiaContext miaContext, MiaFileService miaFileService, QueryDriverFactory driverFactory, String fileDownloadPrefix) {
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
        this.driverFactory = driverFactory;
        this.fileDownloadPrefix = fileDownloadPrefix;
    }
}

