/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.Objects;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.service.history.Mapper;

public abstract class AbstractMapper<S, D>
implements Mapper<S, D> {
    protected ModelMapper mapper;
    protected Class<S> sourceClass;
    protected Class<D> destinationClass;

    AbstractMapper(Class<S> sourceClass, Class<D> destinationClass, ModelMapper mapper) {
        this.sourceClass = sourceClass;
        this.destinationClass = destinationClass;
        this.mapper = mapper;
    }

    @Override
    public D map(S source) {
        return (D)(Objects.isNull(source) ? null : this.mapper.map(source, this.destinationClass));
    }

    @Override
    public void map(S shadow, S current) {
        if (!Objects.isNull(shadow)) {
            this.mapper.map(shadow, current);
        }
    }

    Converter<S, D> mapConverter() {
        return context -> {
            Object source = context.getSource();
            Object destination = context.getDestination();
            this.mapSpecificFields(source, destination);
            return context.getDestination();
        };
    }

    void mapSpecificFields(S source, D destination) {
    }
}

