/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.javers.core.Javers;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.exceptions.configuration.ProcessNotFoundException;
import org.qubership.atp.mia.exceptions.history.MiaCompoundHistoryRevisionRestoreException;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.service.history.EntityHistoryService;
import org.qubership.atp.mia.service.history.impl.AbstractEntityHistoryService;
import org.qubership.atp.mia.service.history.impl.AbstractRestoreHistoryService;
import org.qubership.atp.mia.service.history.impl.AbstractRestoreMapper;
import org.qubership.atp.mia.service.history.impl.CompoundRestoreMapper;
import org.qubership.atp.mia.service.history.impl.ProcessConfigurationRestoreHistoryService;
import org.qubership.atp.mia.service.history.impl.ValidateReferenceExistsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompoundConfigurationRestoreHistoryService
extends AbstractRestoreHistoryService<CompoundConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(CompoundConfigurationRestoreHistoryService.class);
    protected final Javers javers;
    protected final EntityHistoryService<CompoundConfiguration> entityHistoryService;
    private final ValidateReferenceExistsService validateReferenceExistsService;
    protected final AbstractRestoreMapper modelMapper;
    protected final ProcessConfigurationRestoreHistoryService processConfigurationRestoreHistoryService;

    public CompoundConfigurationRestoreHistoryService(Javers javers, AbstractEntityHistoryService<CompoundConfiguration> entityHistoryService, ValidateReferenceExistsService validateReferenceExistsService, CompoundRestoreMapper modelMapper, ProcessConfigurationRestoreHistoryService processConfigurationRestoreHistoryService) {
        super(javers, entityHistoryService, validateReferenceExistsService, modelMapper);
        this.entityHistoryService = entityHistoryService;
        this.validateReferenceExistsService = validateReferenceExistsService;
        this.modelMapper = modelMapper;
        this.javers = javers;
        this.processConfigurationRestoreHistoryService = processConfigurationRestoreHistoryService;
    }

    @Override
    public HistoryItemTypeDto getItemType() {
        return HistoryItemTypeDto.COMPOUND;
    }

    public Class getEntityClass() {
        return CompoundConfiguration.class;
    }

    @Override
    protected void copyValues(CompoundConfiguration shadow, CompoundConfiguration actualObject) {
        this.modelMapper.map(shadow, actualObject);
    }

    @Override
    public Object restoreToRevision(UUID id, long revisionId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, (Class)this.getEntityClass()).withVersion(revisionId).withScopeDeepPlus().build();
        CompoundConfiguration actualObject = (CompoundConfiguration)this.getObject(id);
        this.validateReferenceExistsService.validateEntity(actualObject);
        List shadows = this.javers.findShadows(query);
        if (CollectionUtils.isEmpty((Collection)shadows)) {
            log.error("No shadows found for entity '{}' with revision='{}' and uuid='{}'", new Object[]{this.getItemType(), revisionId, id});
            throw new MiaHistoryRevisionRestoreException();
        }
        Shadow objectShadow = (Shadow)shadows.iterator().next();
        Object restoredObject = this.restoreValues(objectShadow, actualObject);
        try {
            return this.saveRestoredObject((CompoundConfiguration)restoredObject);
        }
        catch (ProcessNotFoundException ex) {
            throw new MiaCompoundHistoryRevisionRestoreException(revisionId);
        }
    }
}

