/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.http.HttpResponse;
import org.qubership.atp.mia.exceptions.fileservice.ReadFailIoExceptionDuringOperation;
import org.qubership.atp.mia.exceptions.itflite.IncorrectProcessNameException;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.configuration.Switcher;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.exception.MiaException;
import org.qubership.atp.mia.model.pot.db.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("'_'MMddHHmmssSSS", Locale.US);
    private static final String REQUEST_TOO_BIG_ERROR = "Connection terminated as request was larger than";

    public static void nameProcessValidator(String name) {
        if (!name.matches("^[\\w ]+$")) {
            throw new IncorrectProcessNameException(name);
        }
    }

    public static int correctPlaceInList(List<?> list, int place) {
        return Math.max(0, Math.min(place, list.size()));
    }

    public static DbType getDbType(Server server) {
        DbType dbType;
        String dbTypeEnvironmentProperty = "db_type";
        String propertyFromServer = server.getProperty(dbTypeEnvironmentProperty);
        if (propertyFromServer == null || propertyFromServer.isEmpty()) {
            dbType = DbType.ORACLE;
        } else {
            try {
                dbType = DbType.valueOf(propertyFromServer.toUpperCase());
            }
            catch (Exception e) {
                dbType = DbType.UNDEFINED;
            }
        }
        return dbType;
    }

    public static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            log.warn("Can not close resource: " + closeable, (Throwable)e);
        }
    }

    @Nonnull
    public static <T> Stream<T> streamOf(@Nonnull Iterator<T> iterator) {
        Spliterator<T> split = Spliterators.spliteratorUnknownSize(iterator, 16);
        return StreamSupport.stream(split, false);
    }

    public static ArrayList<String> getPathToFileOutOfLog(String outputFilePath, String regex) {
        ArrayList<String> paths = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        try {
            String result = new String(Files.readAllBytes(Paths.get(outputFilePath, new String[0])), StandardCharsets.UTF_8);
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                String pathToFileFound = matcher.group();
                log.info("Found path to file in log: {}", (Object)pathToFileFound);
                paths.add(pathToFileFound);
            }
        }
        catch (IOException e) {
            throw new ReadFailIoExceptionDuringOperation(outputFilePath, e);
        }
        return paths;
    }

    public static String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getTimestampFile() {
        return DATE_FORMATTER.format(LocalDateTime.now());
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String getFileNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getFileNameWithTimestamp(String fileName) {
        String newFileName = Utils.getFileNameWithoutExtension(fileName);
        String ext = fileName.substring(fileName.lastIndexOf("."));
        return newFileName + Utils.getTimestampFile() + ext;
    }

    public static boolean isHeaderNamePresent(HttpResponse httpResponse, String headerName) {
        return Arrays.stream(httpResponse.getAllHeaders()).anyMatch(h -> h.getName().equalsIgnoreCase(headerName));
    }

    public static String getHeaderValue(HttpResponse httpResponse, String headerName) {
        return Arrays.stream(httpResponse.getAllHeaders()).filter(h -> h.getName().equalsIgnoreCase(headerName)).map(v -> v.getValue()).reduce("", String::concat);
    }

    public static String urlEvaluator(String url, Map<String, String> parameters) {
        if (parameters != null) {
            url = url + "?" + parameters.keySet().stream().map(key -> key + "=" + (String)parameters.get(key)).collect(Collectors.joining("&"));
        }
        return url;
    }

    public static String prepareRestHeaders(Map<String, String> headers) {
        if (headers != null) {
            return headers.keySet().stream().map(key -> key + ":" + (String)headers.get(key)).collect(Collectors.joining("\n"));
        }
        return "";
    }

    public static String getFirstGroupFromStringByRegexp(String string, String regex) {
        String value = null;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            value = matcher.group(1);
        }
        return value;
    }

    public static boolean checkCondition(String erValue, String arValue) {
        boolean equality = true;
        int operator = erValue.length() > 0 ? (int)erValue.charAt(0) : 61;
        try {
            switch (operator) {
                case 62: {
                    int intValue = Integer.parseInt(erValue.substring(1).trim());
                    if (Integer.parseInt(arValue) <= intValue) {
                        equality = false;
                    }
                    break;
                }
                case 60: {
                    int intValue = Integer.parseInt(erValue.substring(1).trim());
                    if (Integer.parseInt(arValue) >= intValue) {
                        equality = false;
                    }
                    break;
                }
                default: {
                    equality = arValue.matches(erValue);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            equality = false;
        }
        return equality;
    }

    public static MiaException error(Logger log, ErrorCodes errorCode, Object ... params) {
        if (errorCode == null) {
            log.error("Unknown error code! Please fix this error.");
            errorCode = ErrorCodes.MIA_8000_UNEXPECTED_ERROR;
        }
        if (!Objects.isNull(params) && params.length > 1) {
            try {
                Exception e = (Exception)params[0];
                log.error(errorCode.getMessage(new Object[0]), (Throwable)e);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return new MiaException(errorCode, params);
    }

    public static LinkedHashSet<String> listToSet(List<String> list) {
        return new LinkedHashSet<String>(list);
    }

    public static LinkedHashSet<String> listToSet(String ... list) {
        return Utils.listToSet(Arrays.asList(list));
    }

    public static Switcher getSystemSwitcherByName(Constants.SystemSwitcherNames name, List<Switcher> systemSwitchers) {
        return systemSwitchers.stream().filter(switcher -> switcher.getName().equals(name.toString())).findFirst().get();
    }

    public static String getPrettyStringFromXml(String xmlData) {
        log.info("Get pretty string from Xml");
        log.debug("Xml to transform: " + xmlData);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            StreamSource xmlInput = new StreamSource(new StringReader(xmlData));
            transformer.transform(xmlInput, xmlOutput);
            xmlData = xmlOutput.getWriter().toString();
            log.trace("Pretty string: \n{}", (Object)xmlData);
        }
        catch (Exception e) {
            log.error("Errors occurred while transforming XML response to pretty string.");
        }
        return xmlData;
    }

    public static String maxExcelString(String stringForCell) {
        return stringForCell.length() > 32670 ? stringForCell.substring(0, 32670) : stringForCell;
    }

    public static long parseLongValueOrDefault(String valueToParse, long defaultValue, String valueName) {
        long tempValue;
        try {
            tempValue = Long.parseLong(valueToParse);
        }
        catch (NumberFormatException e) {
            tempValue = defaultValue;
            log.debug("Error can't parse {} value [{}], use the standard [{}]", new Object[]{valueName, valueToParse, defaultValue});
        }
        return tempValue;
    }

    public static Exception handleException(Exception e) {
        String msg = e.getMessage() == null ? ErrorCodes.MIA_8000_UNEXPECTED_ERROR.getMessage(e) : e.getMessage();
        return msg.contains(REQUEST_TOO_BIG_ERROR) ? Utils.error(log, ErrorCodes.MIA_8002_REQUEST_TOO_BIG, new Object[0]) : new Exception(msg, e);
    }

    public static void sleepForTimeInMillSeconds(long millSeconds) {
        if (millSeconds > 0L) {
            try {
                log.debug("Waiting for {} milli seconds", (Object)millSeconds);
                Thread.sleep(millSeconds);
            }
            catch (InterruptedException e) {
                log.debug("InterruptedException while waiting for above timeout", (Throwable)e);
            }
        }
    }

    public static long calculateDuration(long startDateTimestamp) {
        return System.currentTimeMillis() - startDateTimestamp;
    }
}

