/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.qubership.atp.mia.utils.converters.String2UuidConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DtoConvertService {
    private static final Logger log = LoggerFactory.getLogger(DtoConvertService.class);
    private final ModelMapper modelMapper = new ModelMapper();

    public DtoConvertService() {
        this.modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        this.modelMapper.getConfiguration().getConverters().add(new String2UuidConverter());
    }

    public ModelMapper getModelMapper() {
        return this.modelMapper;
    }

    public <T> T convert(Object from, Class<T> to) {
        return (T)this.modelMapper.map(from, to);
    }

    public <T> List<T> convertList(List from, Class<T> to) {
        if (from == null) {
            return new ArrayList();
        }
        return from.stream().map(o -> this.convert(o, to)).collect(Collectors.toList());
    }

    public <T> List<T> convertSetToList(Set from, Class<T> to) {
        if (from == null) {
            return new ArrayList();
        }
        return from.stream().map(o -> this.convert(o, to)).collect(Collectors.toList());
    }
}

