/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils.dos2unix.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import org.qubership.atp.mia.exceptions.dos2unix.Dos2unixLinuxFailException;
import org.qubership.atp.mia.utils.dos2unix.Dos2Unix;
import org.qubership.atp.mia.utils.dos2unix.utils.Dos2UnixUtils;
import org.qubership.atp.mia.utils.dos2unix.utils.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxDos2Unix
implements Dos2Unix {
    private static final Logger log = LoggerFactory.getLogger(LinuxDos2Unix.class);
    private static final String PERMISSION_ERROR = "Permission denied";
    private static final String DOS2UNIX = "dos2unix";
    private final String pathToDos2Unix;

    public LinuxDos2Unix(String pathToDos2Unix) {
        this.pathToDos2Unix = pathToDos2Unix;
    }

    @Override
    public void runDos2Unix(Path destSource) {
        log.info("Run dos2unix for linux");
        String dest = Dos2UnixUtils.destinationToRealPath(destSource).toString();
        if (this.runDos2Unix(DOS2UNIX, dest, false) == 0) {
            log.info("File conversion to Unix Format is Success (1st try PATH present)! filepath: {}", (Object)dest);
        } else {
            log.warn("File conversion to Unix Format is Fail (1st try PATH is not present)!, filepath: {};", (Object)dest);
            String dosPath = Dos2UnixUtils.getDos2UnixPath(this.pathToDos2Unix, new String[0]).toString();
            log.info("Try to run dos2unix in this path: {}", (Object)dosPath);
            if (this.runDos2Unix(dosPath, dest, false) == 0) {
                log.info("File conversion to Unix Format is Success (2nd try)! filepath: {}", (Object)dest);
            } else {
                log.error("Dos2Unix error (2nd try): dos2unix path provided by user not working: {}", (Object)this.pathToDos2Unix);
                throw new Dos2unixLinuxFailException(dest, dosPath);
            }
        }
    }

    private int runDos2Unix(String command, String dest, boolean isRetry) {
        int exitVal = -1;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(command, dest);
            Process process = builder.start();
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            exitVal = process.waitFor();
            log.info("dos2unix executed with code: {}", (Object)exitVal);
        }
        catch (IOException e) {
            log.warn("Dos2Unix error: IOException {}", (Object)e.getMessage());
            if (e.getMessage().contains(PERMISSION_ERROR) && !isRetry) {
                log.warn("Dos2Unix error: contains permission error, try to run chmod +x on dos2unix tool");
                this.runChmod(command);
                exitVal = this.runDos2Unix(command, dest, true);
            }
        }
        catch (InterruptedException e) {
            log.warn("Dos2Unix error: Can't wait dos2unix process to the end, it was interrupted!");
        }
        return exitVal;
    }

    private void runChmod(String path) {
        log.trace("running chmod +x on path: {}", (Object)path);
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("chmod", "+x", path);
            Process process = builder.start();
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            int exitVal = process.waitFor();
            if (exitVal == 0) {
                log.trace("chmod +x is Success! Path: {}", (Object)path);
            } else {
                log.trace("chmod +x is Fail! Path: {}", (Object)path);
            }
        }
        catch (IOException e) {
            log.warn("chmod error: path: [{}], IOException {}", (Object)path, (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            log.warn("chmod error: Can't wait chmod process to the end, it was interrupted! path: [{}],  {}", (Object)path, (Object)e.getMessage());
        }
    }
}

