/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.6.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.mia.controllers.api;

import org.qubership.atp.mia.controllers.api.dto.AbstractConfiguratorModelDto;
import org.qubership.atp.mia.controllers.api.dto.EnvironmentDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDto;
import org.qubership.atp.mia.controllers.api.dto.SystemEnvironmentsViewDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:32.725100697Z[Etc/UTC]")
@Validated
@Tag(name = "mia-environment-controller", description = "MIA Environment Controller")
public interface MiaEnvironmentControllerApi {

    /**
     * GET /rest/environments : Get mia environment detail
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironments",
        summary = "Get mia environment detail",
        tags = { "mia-environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = AbstractConfiguratorModelDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<AbstractConfiguratorModelDto>> getEnvironments(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId
    );


    /**
     * GET /rest/environments/full : Get mia full environment details
     *
     * @param projectId projectId (required)
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentsFull",
        summary = "Get mia full environment details",
        tags = { "mia-environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/environments/full",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentDto> getEnvironmentsFull(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @NotNull @Parameter(name = "environmentId", description = "environmentId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "environmentId", required = true) UUID environmentId
    );


    /**
     * GET /rest/project : Get mia project detail
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProject",
        summary = "Get mia project detail",
        tags = { "mia-environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/project",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDto> getProject(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) String projectId
    );


    /**
     * GET /rest/projects : Get mia all projects details
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjects",
        summary = "Get mia all projects details",
        tags = { "mia-environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = AbstractConfiguratorModelDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/projects",
        produces = { "application/json" }
    )
    ResponseEntity<List<AbstractConfiguratorModelDto>> getProjects(
        
    );


    /**
     * GET /rest/environments/systems : Get mia system enviornment detail
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemsForProject",
        summary = "Get mia system enviornment detail",
        tags = { "mia-environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemEnvironmentsViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/environments/systems",
        produces = { "application/json" }
    )
    ResponseEntity<SystemEnvironmentsViewDto> getSystemsForProject(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId
    );

}
