/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.6.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.mia.controllers.api;

import org.qubership.atp.mia.controllers.api.dto.CompareEntityResponseDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemResponseDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:34.044919947Z[Etc/UTC]")
@Validated
@Tag(name = "mia-history-changes-controller", description = "MIA History Change controller")
public interface MiaHistoryChangesControllerApi {

    /**
     * GET /rest/history/{projectId}/{itemType}/{id} : finds all changes history for defined object
     *
     * @param projectId  (required)
     * @param itemType  (required)
     * @param id  (required)
     * @param offset  (optional, default to 0)
     * @param limit  (optional, default to 10)
     * @return OK (status code 200)
     *         or History for Entity type &#x3D; &#39;\&quot; + itemType + \&quot;&#39; is not supported (status code 400)
     *         or Entity Id not found (status code 404)
     */
    @Operation(
        operationId = "getAllHistory",
        summary = "finds all changes history for defined object",
        tags = { "mia-history-changes-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = HistoryItemResponseDto.class))
            }),
            @ApiResponse(responseCode = "400", description = "History for Entity type = '\" + itemType + \"' is not supported"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/history/{projectId}/{itemType}/{id}",
        produces = { "application/json" }
    )
    ResponseEntity<HistoryItemResponseDto> getAllHistory(
        @Parameter(name = "projectId", description = "", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "", required = true, in = ParameterIn.PATH) @PathVariable("itemType") String itemType,
        @Parameter(name = "id", description = "", required = true, in = ParameterIn.PATH) @PathVariable("id") UUID id,
        @Parameter(name = "offset", description = "", in = ParameterIn.QUERY) @Valid @RequestParam(value = "offset", required = false, defaultValue = "0") Integer offset,
        @Parameter(name = "limit", description = "", in = ParameterIn.QUERY) @Valid @RequestParam(value = "limit", required = false, defaultValue = "10") Integer limit
    );


    /**
     * GET /rest/entityversioning/{projectId}/{itemType}/{uuid} : getEntitiesByVersion
     *
     * @param projectId projectId (required)
     * @param itemType itemType (required)
     * @param uuid uuid (required)
     * @param versions versions (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEntitiesByVersion",
        summary = "getEntitiesByVersion",
        tags = { "mia-history-changes-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = CompareEntityResponseDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/entityversioning/{projectId}/{itemType}/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompareEntityResponseDto>> getEntitiesByVersion(
        @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "itemType", required = true, in = ParameterIn.PATH) @PathVariable("itemType") String itemType,
        @Parameter(name = "uuid", description = "uuid", required = true, in = ParameterIn.PATH) @PathVariable("uuid") UUID uuid,
        @NotNull @Parameter(name = "versions", description = "versions", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "versions", required = true) List<String> versions
    );


    /**
     * POST /rest/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId} : Restore the state of the provided entity to defined revision
     *
     * @param projectId  (required)
     * @param itemType  (required)
     * @param id  (required)
     * @param revisionId  (required)
     * @return OK (status code 200)
     *         or Forbidden (status code 403)
     *         or Entity Id not found (status code 404)
     *         or Revision was not restored (status code 500)
     */
    @Operation(
        operationId = "restoreToRevision",
        summary = "Restore the state of the provided entity to defined revision",
        tags = { "mia-history-changes-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Entity Id not found"),
            @ApiResponse(responseCode = "500", description = "Revision was not restored")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/rest/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId}"
    )
    ResponseEntity<Void> restoreToRevision(
        @Parameter(name = "projectId", description = "", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "itemType", description = "", required = true, in = ParameterIn.PATH) @PathVariable("itemType") String itemType,
        @Parameter(name = "id", description = "", required = true, in = ParameterIn.PATH) @PathVariable("id") UUID id,
        @Parameter(name = "revisionId", description = "", required = true, in = ParameterIn.PATH) @PathVariable("revisionId") Integer revisionId
    );

}
