package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.FileMarkerDto;
import org.qubership.atp.mia.controllers.api.dto.MarkerDto;
import org.qubership.atp.mia.controllers.api.dto.RestDto;
import org.qubership.atp.mia.controllers.api.dto.SoapDto;
import org.qubership.atp.mia.controllers.api.dto.TestDataParamsDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CommandDto
 */

@JsonTypeName("Command")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:34.044919947Z[Etc/UTC]")
public class CommandDto {

  private String pathForUpload;

  private String regexpForFileRetrieve;

  private String fileExtension;

  @Valid
  private List<String> namesOfFilesForGeneration;

  @Valid
  private List<String> ethalonFilesForGeneration;

  private String delayForGeneration;

  @Valid
  private List<String> pathsForDownload;

  @Valid
  private Map<String, String> variablesToExtractFromLog = new HashMap<>();

  private MarkerDto marker;

  private String description;

  private String warningDescription;

  private String logFileNameFormat;

  private String saveGeneratedFilesToParameter;

  private String charsetForGeneratedFile;

  private Boolean displayDownloadedFileContent;

  @Valid
  private List<String> filesForUpload;

  @Valid
  private Map<String, String> atpValues = new HashMap<>();

  @Valid
  private List<@Valid FileMarkerDto> fileMarkers;

  private String toExecute;

  private TestDataParamsDto testDataParams;

  private RestDto rest;

  private SoapDto soap;

  private String name;

  private String type;

  private String system;

  @Valid
  private List<String> values;

  private String value;

  public CommandDto pathForUpload(String pathForUpload) {
    this.pathForUpload = pathForUpload;
    return this;
  }

  /**
   * Get pathForUpload
   * @return pathForUpload
  */
  
  @Schema(name = "pathForUpload", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pathForUpload")
  public String getPathForUpload() {
    return pathForUpload;
  }

  public void setPathForUpload(String pathForUpload) {
    this.pathForUpload = pathForUpload;
  }

  public CommandDto regexpForFileRetrieve(String regexpForFileRetrieve) {
    this.regexpForFileRetrieve = regexpForFileRetrieve;
    return this;
  }

  /**
   * Get regexpForFileRetrieve
   * @return regexpForFileRetrieve
  */
  
  @Schema(name = "regexpForFileRetrieve", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("regexpForFileRetrieve")
  public String getRegexpForFileRetrieve() {
    return regexpForFileRetrieve;
  }

  public void setRegexpForFileRetrieve(String regexpForFileRetrieve) {
    this.regexpForFileRetrieve = regexpForFileRetrieve;
  }

  public CommandDto fileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * Get fileExtension
   * @return fileExtension
  */
  
  @Schema(name = "fileExtension", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fileExtension")
  public String getFileExtension() {
    return fileExtension;
  }

  public void setFileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
  }

  public CommandDto namesOfFilesForGeneration(List<String> namesOfFilesForGeneration) {
    this.namesOfFilesForGeneration = namesOfFilesForGeneration;
    return this;
  }

  public CommandDto addNamesOfFilesForGenerationItem(String namesOfFilesForGenerationItem) {
    if (this.namesOfFilesForGeneration == null) {
      this.namesOfFilesForGeneration = new ArrayList<>();
    }
    this.namesOfFilesForGeneration.add(namesOfFilesForGenerationItem);
    return this;
  }

  /**
   * Get namesOfFilesForGeneration
   * @return namesOfFilesForGeneration
  */
  
  @Schema(name = "namesOfFilesForGeneration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("namesOfFilesForGeneration")
  public List<String> getNamesOfFilesForGeneration() {
    return namesOfFilesForGeneration;
  }

  public void setNamesOfFilesForGeneration(List<String> namesOfFilesForGeneration) {
    this.namesOfFilesForGeneration = namesOfFilesForGeneration;
  }

  public CommandDto ethalonFilesForGeneration(List<String> ethalonFilesForGeneration) {
    this.ethalonFilesForGeneration = ethalonFilesForGeneration;
    return this;
  }

  public CommandDto addEthalonFilesForGenerationItem(String ethalonFilesForGenerationItem) {
    if (this.ethalonFilesForGeneration == null) {
      this.ethalonFilesForGeneration = new ArrayList<>();
    }
    this.ethalonFilesForGeneration.add(ethalonFilesForGenerationItem);
    return this;
  }

  /**
   * Get ethalonFilesForGeneration
   * @return ethalonFilesForGeneration
  */
  
  @Schema(name = "ethalonFilesForGeneration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ethalonFilesForGeneration")
  public List<String> getEthalonFilesForGeneration() {
    return ethalonFilesForGeneration;
  }

  public void setEthalonFilesForGeneration(List<String> ethalonFilesForGeneration) {
    this.ethalonFilesForGeneration = ethalonFilesForGeneration;
  }

  public CommandDto delayForGeneration(String delayForGeneration) {
    this.delayForGeneration = delayForGeneration;
    return this;
  }

  /**
   * Get delayForGeneration
   * @return delayForGeneration
  */
  
  @Schema(name = "delayForGeneration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("delayForGeneration")
  public String getDelayForGeneration() {
    return delayForGeneration;
  }

  public void setDelayForGeneration(String delayForGeneration) {
    this.delayForGeneration = delayForGeneration;
  }

  public CommandDto pathsForDownload(List<String> pathsForDownload) {
    this.pathsForDownload = pathsForDownload;
    return this;
  }

  public CommandDto addPathsForDownloadItem(String pathsForDownloadItem) {
    if (this.pathsForDownload == null) {
      this.pathsForDownload = new ArrayList<>();
    }
    this.pathsForDownload.add(pathsForDownloadItem);
    return this;
  }

  /**
   * Get pathsForDownload
   * @return pathsForDownload
  */
  
  @Schema(name = "pathsForDownload", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pathsForDownload")
  public List<String> getPathsForDownload() {
    return pathsForDownload;
  }

  public void setPathsForDownload(List<String> pathsForDownload) {
    this.pathsForDownload = pathsForDownload;
  }

  public CommandDto variablesToExtractFromLog(Map<String, String> variablesToExtractFromLog) {
    this.variablesToExtractFromLog = variablesToExtractFromLog;
    return this;
  }

  public CommandDto putVariablesToExtractFromLogItem(String key, String variablesToExtractFromLogItem) {
    if (this.variablesToExtractFromLog == null) {
      this.variablesToExtractFromLog = new HashMap<>();
    }
    this.variablesToExtractFromLog.put(key, variablesToExtractFromLogItem);
    return this;
  }

  /**
   * Get variablesToExtractFromLog
   * @return variablesToExtractFromLog
  */
  
  @Schema(name = "variablesToExtractFromLog", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variablesToExtractFromLog")
  public Map<String, String> getVariablesToExtractFromLog() {
    return variablesToExtractFromLog;
  }

  public void setVariablesToExtractFromLog(Map<String, String> variablesToExtractFromLog) {
    this.variablesToExtractFromLog = variablesToExtractFromLog;
  }

  public CommandDto marker(MarkerDto marker) {
    this.marker = marker;
    return this;
  }

  /**
   * Get marker
   * @return marker
  */
  @Valid 
  @Schema(name = "marker", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("marker")
  public MarkerDto getMarker() {
    return marker;
  }

  public void setMarker(MarkerDto marker) {
    this.marker = marker;
  }

  public CommandDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CommandDto warningDescription(String warningDescription) {
    this.warningDescription = warningDescription;
    return this;
  }

  /**
   * Get warningDescription
   * @return warningDescription
  */
  
  @Schema(name = "warningDescription", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("warningDescription")
  public String getWarningDescription() {
    return warningDescription;
  }

  public void setWarningDescription(String warningDescription) {
    this.warningDescription = warningDescription;
  }

  public CommandDto logFileNameFormat(String logFileNameFormat) {
    this.logFileNameFormat = logFileNameFormat;
    return this;
  }

  /**
   * Get logFileNameFormat
   * @return logFileNameFormat
  */
  
  @Schema(name = "logFileNameFormat", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("logFileNameFormat")
  public String getLogFileNameFormat() {
    return logFileNameFormat;
  }

  public void setLogFileNameFormat(String logFileNameFormat) {
    this.logFileNameFormat = logFileNameFormat;
  }

  public CommandDto saveGeneratedFilesToParameter(String saveGeneratedFilesToParameter) {
    this.saveGeneratedFilesToParameter = saveGeneratedFilesToParameter;
    return this;
  }

  /**
   * Get saveGeneratedFilesToParameter
   * @return saveGeneratedFilesToParameter
  */
  
  @Schema(name = "saveGeneratedFilesToParameter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveGeneratedFilesToParameter")
  public String getSaveGeneratedFilesToParameter() {
    return saveGeneratedFilesToParameter;
  }

  public void setSaveGeneratedFilesToParameter(String saveGeneratedFilesToParameter) {
    this.saveGeneratedFilesToParameter = saveGeneratedFilesToParameter;
  }

  public CommandDto charsetForGeneratedFile(String charsetForGeneratedFile) {
    this.charsetForGeneratedFile = charsetForGeneratedFile;
    return this;
  }

  /**
   * Get charsetForGeneratedFile
   * @return charsetForGeneratedFile
  */
  
  @Schema(name = "charsetForGeneratedFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("charsetForGeneratedFile")
  public String getCharsetForGeneratedFile() {
    return charsetForGeneratedFile;
  }

  public void setCharsetForGeneratedFile(String charsetForGeneratedFile) {
    this.charsetForGeneratedFile = charsetForGeneratedFile;
  }

  public CommandDto displayDownloadedFileContent(Boolean displayDownloadedFileContent) {
    this.displayDownloadedFileContent = displayDownloadedFileContent;
    return this;
  }

  /**
   * Get displayDownloadedFileContent
   * @return displayDownloadedFileContent
  */
  
  @Schema(name = "displayDownloadedFileContent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("displayDownloadedFileContent")
  public Boolean getDisplayDownloadedFileContent() {
    return displayDownloadedFileContent;
  }

  public void setDisplayDownloadedFileContent(Boolean displayDownloadedFileContent) {
    this.displayDownloadedFileContent = displayDownloadedFileContent;
  }

  public CommandDto filesForUpload(List<String> filesForUpload) {
    this.filesForUpload = filesForUpload;
    return this;
  }

  public CommandDto addFilesForUploadItem(String filesForUploadItem) {
    if (this.filesForUpload == null) {
      this.filesForUpload = new ArrayList<>();
    }
    this.filesForUpload.add(filesForUploadItem);
    return this;
  }

  /**
   * Get filesForUpload
   * @return filesForUpload
  */
  
  @Schema(name = "filesForUpload", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filesForUpload")
  public List<String> getFilesForUpload() {
    return filesForUpload;
  }

  public void setFilesForUpload(List<String> filesForUpload) {
    this.filesForUpload = filesForUpload;
  }

  public CommandDto atpValues(Map<String, String> atpValues) {
    this.atpValues = atpValues;
    return this;
  }

  public CommandDto putAtpValuesItem(String key, String atpValuesItem) {
    if (this.atpValues == null) {
      this.atpValues = new HashMap<>();
    }
    this.atpValues.put(key, atpValuesItem);
    return this;
  }

  /**
   * Get atpValues
   * @return atpValues
  */
  
  @Schema(name = "atpValues", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("atpValues")
  public Map<String, String> getAtpValues() {
    return atpValues;
  }

  public void setAtpValues(Map<String, String> atpValues) {
    this.atpValues = atpValues;
  }

  public CommandDto fileMarkers(List<@Valid FileMarkerDto> fileMarkers) {
    this.fileMarkers = fileMarkers;
    return this;
  }

  public CommandDto addFileMarkersItem(FileMarkerDto fileMarkersItem) {
    if (this.fileMarkers == null) {
      this.fileMarkers = new ArrayList<>();
    }
    this.fileMarkers.add(fileMarkersItem);
    return this;
  }

  /**
   * Get fileMarkers
   * @return fileMarkers
  */
  @Valid 
  @Schema(name = "fileMarkers", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fileMarkers")
  public List<@Valid FileMarkerDto> getFileMarkers() {
    return fileMarkers;
  }

  public void setFileMarkers(List<@Valid FileMarkerDto> fileMarkers) {
    this.fileMarkers = fileMarkers;
  }

  public CommandDto toExecute(String toExecute) {
    this.toExecute = toExecute;
    return this;
  }

  /**
   * Get toExecute
   * @return toExecute
  */
  
  @Schema(name = "toExecute", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("toExecute")
  public String getToExecute() {
    return toExecute;
  }

  public void setToExecute(String toExecute) {
    this.toExecute = toExecute;
  }

  public CommandDto testDataParams(TestDataParamsDto testDataParams) {
    this.testDataParams = testDataParams;
    return this;
  }

  /**
   * Get testDataParams
   * @return testDataParams
  */
  @Valid 
  @Schema(name = "testDataParams", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("testDataParams")
  public TestDataParamsDto getTestDataParams() {
    return testDataParams;
  }

  public void setTestDataParams(TestDataParamsDto testDataParams) {
    this.testDataParams = testDataParams;
  }

  public CommandDto rest(RestDto rest) {
    this.rest = rest;
    return this;
  }

  /**
   * Get rest
   * @return rest
  */
  @Valid 
  @Schema(name = "rest", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("rest")
  public RestDto getRest() {
    return rest;
  }

  public void setRest(RestDto rest) {
    this.rest = rest;
  }

  public CommandDto soap(SoapDto soap) {
    this.soap = soap;
    return this;
  }

  /**
   * Get soap
   * @return soap
  */
  @Valid 
  @Schema(name = "soap", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("soap")
  public SoapDto getSoap() {
    return soap;
  }

  public void setSoap(SoapDto soap) {
    this.soap = soap;
  }

  public CommandDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CommandDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CommandDto system(String system) {
    this.system = system;
    return this;
  }

  /**
   * Get system
   * @return system
  */
  
  @Schema(name = "system", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("system")
  public String getSystem() {
    return system;
  }

  public void setSystem(String system) {
    this.system = system;
  }

  public CommandDto values(List<String> values) {
    this.values = values;
    return this;
  }

  public CommandDto addValuesItem(String valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

  /**
   * Get values
   * @return values
  */
  
  @Schema(name = "values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("values")
  public List<String> getValues() {
    return values;
  }

  public void setValues(List<String> values) {
    this.values = values;
  }

  public CommandDto value(String value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
  */
  
  @Schema(name = "value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommandDto command = (CommandDto) o;
    return Objects.equals(this.pathForUpload, command.pathForUpload) &&
        Objects.equals(this.regexpForFileRetrieve, command.regexpForFileRetrieve) &&
        Objects.equals(this.fileExtension, command.fileExtension) &&
        Objects.equals(this.namesOfFilesForGeneration, command.namesOfFilesForGeneration) &&
        Objects.equals(this.ethalonFilesForGeneration, command.ethalonFilesForGeneration) &&
        Objects.equals(this.delayForGeneration, command.delayForGeneration) &&
        Objects.equals(this.pathsForDownload, command.pathsForDownload) &&
        Objects.equals(this.variablesToExtractFromLog, command.variablesToExtractFromLog) &&
        Objects.equals(this.marker, command.marker) &&
        Objects.equals(this.description, command.description) &&
        Objects.equals(this.warningDescription, command.warningDescription) &&
        Objects.equals(this.logFileNameFormat, command.logFileNameFormat) &&
        Objects.equals(this.saveGeneratedFilesToParameter, command.saveGeneratedFilesToParameter) &&
        Objects.equals(this.charsetForGeneratedFile, command.charsetForGeneratedFile) &&
        Objects.equals(this.displayDownloadedFileContent, command.displayDownloadedFileContent) &&
        Objects.equals(this.filesForUpload, command.filesForUpload) &&
        Objects.equals(this.atpValues, command.atpValues) &&
        Objects.equals(this.fileMarkers, command.fileMarkers) &&
        Objects.equals(this.toExecute, command.toExecute) &&
        Objects.equals(this.testDataParams, command.testDataParams) &&
        Objects.equals(this.rest, command.rest) &&
        Objects.equals(this.soap, command.soap) &&
        Objects.equals(this.name, command.name) &&
        Objects.equals(this.type, command.type) &&
        Objects.equals(this.system, command.system) &&
        Objects.equals(this.values, command.values) &&
        Objects.equals(this.value, command.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pathForUpload, regexpForFileRetrieve, fileExtension, namesOfFilesForGeneration, ethalonFilesForGeneration, delayForGeneration, pathsForDownload, variablesToExtractFromLog, marker, description, warningDescription, logFileNameFormat, saveGeneratedFilesToParameter, charsetForGeneratedFile, displayDownloadedFileContent, filesForUpload, atpValues, fileMarkers, toExecute, testDataParams, rest, soap, name, type, system, values, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommandDto {\n");
    sb.append("    pathForUpload: ").append(toIndentedString(pathForUpload)).append("\n");
    sb.append("    regexpForFileRetrieve: ").append(toIndentedString(regexpForFileRetrieve)).append("\n");
    sb.append("    fileExtension: ").append(toIndentedString(fileExtension)).append("\n");
    sb.append("    namesOfFilesForGeneration: ").append(toIndentedString(namesOfFilesForGeneration)).append("\n");
    sb.append("    ethalonFilesForGeneration: ").append(toIndentedString(ethalonFilesForGeneration)).append("\n");
    sb.append("    delayForGeneration: ").append(toIndentedString(delayForGeneration)).append("\n");
    sb.append("    pathsForDownload: ").append(toIndentedString(pathsForDownload)).append("\n");
    sb.append("    variablesToExtractFromLog: ").append(toIndentedString(variablesToExtractFromLog)).append("\n");
    sb.append("    marker: ").append(toIndentedString(marker)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    warningDescription: ").append(toIndentedString(warningDescription)).append("\n");
    sb.append("    logFileNameFormat: ").append(toIndentedString(logFileNameFormat)).append("\n");
    sb.append("    saveGeneratedFilesToParameter: ").append(toIndentedString(saveGeneratedFilesToParameter)).append("\n");
    sb.append("    charsetForGeneratedFile: ").append(toIndentedString(charsetForGeneratedFile)).append("\n");
    sb.append("    displayDownloadedFileContent: ").append(toIndentedString(displayDownloadedFileContent)).append("\n");
    sb.append("    filesForUpload: ").append(toIndentedString(filesForUpload)).append("\n");
    sb.append("    atpValues: ").append(toIndentedString(atpValues)).append("\n");
    sb.append("    fileMarkers: ").append(toIndentedString(fileMarkers)).append("\n");
    sb.append("    toExecute: ").append(toIndentedString(toExecute)).append("\n");
    sb.append("    testDataParams: ").append(toIndentedString(testDataParams)).append("\n");
    sb.append("    rest: ").append(toIndentedString(rest)).append("\n");
    sb.append("    soap: ").append(toIndentedString(soap)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    system: ").append(toIndentedString(system)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

