package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.CommandOutputDto;
import org.qubership.atp.mia.controllers.api.dto.CommandTypesEnumDto;
import org.qubership.atp.mia.controllers.api.dto.ExceptionDto;
import org.qubership.atp.mia.controllers.api.dto.HtmlPageDto;
import org.qubership.atp.mia.controllers.api.dto.SqlResponseDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CommandResponseDto
 */

@JsonTypeName("CommandResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class CommandResponseDto {

  private CommandTypesEnumDto type;

  private String command;

  @Valid
  private Map<String, String> connectionInfo = new HashMap<>();

  @Valid
  private List<@Valid CommandOutputDto> commandOutputs;

  private SqlResponseDto sqlResponse;

  private HtmlPageDto htmlPage;

  @Valid
  private List<String> description;

  @Valid
  private List<@Valid ExceptionDto> errors;

  private Boolean checkStatusCodeFlag;

  private String statusCode;

  @Valid
  private List<String> expectedCodes;

  private String postScriptExecutionReport;

  public CommandResponseDto type(CommandTypesEnumDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public CommandTypesEnumDto getType() {
    return type;
  }

  public void setType(CommandTypesEnumDto type) {
    this.type = type;
  }

  public CommandResponseDto command(String command) {
    this.command = command;
    return this;
  }

  /**
   * Get command
   * @return command
  */
  
  @Schema(name = "command", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("command")
  public String getCommand() {
    return command;
  }

  public void setCommand(String command) {
    this.command = command;
  }

  public CommandResponseDto connectionInfo(Map<String, String> connectionInfo) {
    this.connectionInfo = connectionInfo;
    return this;
  }

  public CommandResponseDto putConnectionInfoItem(String key, String connectionInfoItem) {
    if (this.connectionInfo == null) {
      this.connectionInfo = new HashMap<>();
    }
    this.connectionInfo.put(key, connectionInfoItem);
    return this;
  }

  /**
   * Get connectionInfo
   * @return connectionInfo
  */
  
  @Schema(name = "connectionInfo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("connectionInfo")
  public Map<String, String> getConnectionInfo() {
    return connectionInfo;
  }

  public void setConnectionInfo(Map<String, String> connectionInfo) {
    this.connectionInfo = connectionInfo;
  }

  public CommandResponseDto commandOutputs(List<@Valid CommandOutputDto> commandOutputs) {
    this.commandOutputs = commandOutputs;
    return this;
  }

  public CommandResponseDto addCommandOutputsItem(CommandOutputDto commandOutputsItem) {
    if (this.commandOutputs == null) {
      this.commandOutputs = new ArrayList<>();
    }
    this.commandOutputs.add(commandOutputsItem);
    return this;
  }

  /**
   * Get commandOutputs
   * @return commandOutputs
  */
  @Valid 
  @Schema(name = "commandOutputs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commandOutputs")
  public List<@Valid CommandOutputDto> getCommandOutputs() {
    return commandOutputs;
  }

  public void setCommandOutputs(List<@Valid CommandOutputDto> commandOutputs) {
    this.commandOutputs = commandOutputs;
  }

  public CommandResponseDto sqlResponse(SqlResponseDto sqlResponse) {
    this.sqlResponse = sqlResponse;
    return this;
  }

  /**
   * Get sqlResponse
   * @return sqlResponse
  */
  @Valid 
  @Schema(name = "sqlResponse", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sqlResponse")
  public SqlResponseDto getSqlResponse() {
    return sqlResponse;
  }

  public void setSqlResponse(SqlResponseDto sqlResponse) {
    this.sqlResponse = sqlResponse;
  }

  public CommandResponseDto htmlPage(HtmlPageDto htmlPage) {
    this.htmlPage = htmlPage;
    return this;
  }

  /**
   * Get htmlPage
   * @return htmlPage
  */
  @Valid 
  @Schema(name = "htmlPage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("htmlPage")
  public HtmlPageDto getHtmlPage() {
    return htmlPage;
  }

  public void setHtmlPage(HtmlPageDto htmlPage) {
    this.htmlPage = htmlPage;
  }

  public CommandResponseDto description(List<String> description) {
    this.description = description;
    return this;
  }

  public CommandResponseDto addDescriptionItem(String descriptionItem) {
    if (this.description == null) {
      this.description = new ArrayList<>();
    }
    this.description.add(descriptionItem);
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public List<String> getDescription() {
    return description;
  }

  public void setDescription(List<String> description) {
    this.description = description;
  }

  public CommandResponseDto errors(List<@Valid ExceptionDto> errors) {
    this.errors = errors;
    return this;
  }

  public CommandResponseDto addErrorsItem(ExceptionDto errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

  /**
   * Get errors
   * @return errors
  */
  @Valid 
  @Schema(name = "errors", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errors")
  public List<@Valid ExceptionDto> getErrors() {
    return errors;
  }

  public void setErrors(List<@Valid ExceptionDto> errors) {
    this.errors = errors;
  }

  public CommandResponseDto checkStatusCodeFlag(Boolean checkStatusCodeFlag) {
    this.checkStatusCodeFlag = checkStatusCodeFlag;
    return this;
  }

  /**
   * Get checkStatusCodeFlag
   * @return checkStatusCodeFlag
  */
  
  @Schema(name = "checkStatusCodeFlag", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("checkStatusCodeFlag")
  public Boolean getCheckStatusCodeFlag() {
    return checkStatusCodeFlag;
  }

  public void setCheckStatusCodeFlag(Boolean checkStatusCodeFlag) {
    this.checkStatusCodeFlag = checkStatusCodeFlag;
  }

  public CommandResponseDto statusCode(String statusCode) {
    this.statusCode = statusCode;
    return this;
  }

  /**
   * Get statusCode
   * @return statusCode
  */
  
  @Schema(name = "statusCode", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("statusCode")
  public String getStatusCode() {
    return statusCode;
  }

  public void setStatusCode(String statusCode) {
    this.statusCode = statusCode;
  }

  public CommandResponseDto expectedCodes(List<String> expectedCodes) {
    this.expectedCodes = expectedCodes;
    return this;
  }

  public CommandResponseDto addExpectedCodesItem(String expectedCodesItem) {
    if (this.expectedCodes == null) {
      this.expectedCodes = new ArrayList<>();
    }
    this.expectedCodes.add(expectedCodesItem);
    return this;
  }

  /**
   * Get expectedCodes
   * @return expectedCodes
  */
  
  @Schema(name = "expectedCodes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("expectedCodes")
  public List<String> getExpectedCodes() {
    return expectedCodes;
  }

  public void setExpectedCodes(List<String> expectedCodes) {
    this.expectedCodes = expectedCodes;
  }

  public CommandResponseDto postScriptExecutionReport(String postScriptExecutionReport) {
    this.postScriptExecutionReport = postScriptExecutionReport;
    return this;
  }

  /**
   * Get postScriptExecutionReport
   * @return postScriptExecutionReport
  */
  
  @Schema(name = "postScriptExecutionReport", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("postScriptExecutionReport")
  public String getPostScriptExecutionReport() {
    return postScriptExecutionReport;
  }

  public void setPostScriptExecutionReport(String postScriptExecutionReport) {
    this.postScriptExecutionReport = postScriptExecutionReport;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommandResponseDto commandResponse = (CommandResponseDto) o;
    return Objects.equals(this.type, commandResponse.type) &&
        Objects.equals(this.command, commandResponse.command) &&
        Objects.equals(this.connectionInfo, commandResponse.connectionInfo) &&
        Objects.equals(this.commandOutputs, commandResponse.commandOutputs) &&
        Objects.equals(this.sqlResponse, commandResponse.sqlResponse) &&
        Objects.equals(this.htmlPage, commandResponse.htmlPage) &&
        Objects.equals(this.description, commandResponse.description) &&
        Objects.equals(this.errors, commandResponse.errors) &&
        Objects.equals(this.checkStatusCodeFlag, commandResponse.checkStatusCodeFlag) &&
        Objects.equals(this.statusCode, commandResponse.statusCode) &&
        Objects.equals(this.expectedCodes, commandResponse.expectedCodes) &&
        Objects.equals(this.postScriptExecutionReport, commandResponse.postScriptExecutionReport);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, command, connectionInfo, commandOutputs, sqlResponse, htmlPage, description, errors, checkStatusCodeFlag, statusCode, expectedCodes, postScriptExecutionReport);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommandResponseDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    connectionInfo: ").append(toIndentedString(connectionInfo)).append("\n");
    sb.append("    commandOutputs: ").append(toIndentedString(commandOutputs)).append("\n");
    sb.append("    sqlResponse: ").append(toIndentedString(sqlResponse)).append("\n");
    sb.append("    htmlPage: ").append(toIndentedString(htmlPage)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    checkStatusCodeFlag: ").append(toIndentedString(checkStatusCodeFlag)).append("\n");
    sb.append("    statusCode: ").append(toIndentedString(statusCode)).append("\n");
    sb.append("    expectedCodes: ").append(toIndentedString(expectedCodes)).append("\n");
    sb.append("    postScriptExecutionReport: ").append(toIndentedString(postScriptExecutionReport)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

