package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.CommandPrefixDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CommonConfigurationDto
 */

@JsonTypeName("CommonConfiguration")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:34.044919947Z[Etc/UTC]")
public class CommonConfigurationDto {

  private String defaultSystem;

  private Boolean useVariablesInsideVariable;

  private String variableFormat;

  private Boolean saveFilesToWorkingDir;

  private Boolean saveSqlTablesToFile;

  @Valid
  private Map<String, String> commonVariables = new HashMap<>();

  private String nextBillDateSql = "SELECT NEXT_BILL_DTM FROM ACCOUNT WHERE ACCOUNT_NUM =':accountNumber'";

  private String resetCacheSql = "{call gnvsessiongparams.clearcache()}";

  private String ethalonFilesPath = "etalon_files/";

  private String externalEnvironmentPrefix = "";

  private String commandShellSeparator = " ";

  @Valid
  private List<@Valid CommandPrefixDto> commandShellPrefixes;

  private String genevaDateMask;

  private String sshRsaFilePath;

  private Integer linesAmount = 3;

  public CommonConfigurationDto defaultSystem(String defaultSystem) {
    this.defaultSystem = defaultSystem;
    return this;
  }

  /**
   * Get defaultSystem
   * @return defaultSystem
  */
  
  @Schema(name = "defaultSystem", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultSystem")
  public String getDefaultSystem() {
    return defaultSystem;
  }

  public void setDefaultSystem(String defaultSystem) {
    this.defaultSystem = defaultSystem;
  }

  public CommonConfigurationDto useVariablesInsideVariable(Boolean useVariablesInsideVariable) {
    this.useVariablesInsideVariable = useVariablesInsideVariable;
    return this;
  }

  /**
   * Get useVariablesInsideVariable
   * @return useVariablesInsideVariable
  */
  
  @Schema(name = "useVariablesInsideVariable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("useVariablesInsideVariable")
  public Boolean getUseVariablesInsideVariable() {
    return useVariablesInsideVariable;
  }

  public void setUseVariablesInsideVariable(Boolean useVariablesInsideVariable) {
    this.useVariablesInsideVariable = useVariablesInsideVariable;
  }

  public CommonConfigurationDto variableFormat(String variableFormat) {
    this.variableFormat = variableFormat;
    return this;
  }

  /**
   * Get variableFormat
   * @return variableFormat
  */
  
  @Schema(name = "variableFormat", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variableFormat")
  public String getVariableFormat() {
    return variableFormat;
  }

  public void setVariableFormat(String variableFormat) {
    this.variableFormat = variableFormat;
  }

  public CommonConfigurationDto saveFilesToWorkingDir(Boolean saveFilesToWorkingDir) {
    this.saveFilesToWorkingDir = saveFilesToWorkingDir;
    return this;
  }

  /**
   * Get saveFilesToWorkingDir
   * @return saveFilesToWorkingDir
  */
  
  @Schema(name = "saveFilesToWorkingDir", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveFilesToWorkingDir")
  public Boolean getSaveFilesToWorkingDir() {
    return saveFilesToWorkingDir;
  }

  public void setSaveFilesToWorkingDir(Boolean saveFilesToWorkingDir) {
    this.saveFilesToWorkingDir = saveFilesToWorkingDir;
  }

  public CommonConfigurationDto saveSqlTablesToFile(Boolean saveSqlTablesToFile) {
    this.saveSqlTablesToFile = saveSqlTablesToFile;
    return this;
  }

  /**
   * Get saveSqlTablesToFile
   * @return saveSqlTablesToFile
  */
  
  @Schema(name = "saveSqlTablesToFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveSqlTablesToFile")
  public Boolean getSaveSqlTablesToFile() {
    return saveSqlTablesToFile;
  }

  public void setSaveSqlTablesToFile(Boolean saveSqlTablesToFile) {
    this.saveSqlTablesToFile = saveSqlTablesToFile;
  }

  public CommonConfigurationDto commonVariables(Map<String, String> commonVariables) {
    this.commonVariables = commonVariables;
    return this;
  }

  public CommonConfigurationDto putCommonVariablesItem(String key, String commonVariablesItem) {
    if (this.commonVariables == null) {
      this.commonVariables = new HashMap<>();
    }
    this.commonVariables.put(key, commonVariablesItem);
    return this;
  }

  /**
   * Get commonVariables
   * @return commonVariables
  */
  
  @Schema(name = "commonVariables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commonVariables")
  public Map<String, String> getCommonVariables() {
    return commonVariables;
  }

  public void setCommonVariables(Map<String, String> commonVariables) {
    this.commonVariables = commonVariables;
  }

  public CommonConfigurationDto nextBillDateSql(String nextBillDateSql) {
    this.nextBillDateSql = nextBillDateSql;
    return this;
  }

  /**
   * Get nextBillDateSql
   * @return nextBillDateSql
  */
  
  @Schema(name = "nextBillDateSql", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("nextBillDateSql")
  public String getNextBillDateSql() {
    return nextBillDateSql;
  }

  public void setNextBillDateSql(String nextBillDateSql) {
    this.nextBillDateSql = nextBillDateSql;
  }

  public CommonConfigurationDto resetCacheSql(String resetCacheSql) {
    this.resetCacheSql = resetCacheSql;
    return this;
  }

  /**
   * Get resetCacheSql
   * @return resetCacheSql
  */
  
  @Schema(name = "resetCacheSql", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resetCacheSql")
  public String getResetCacheSql() {
    return resetCacheSql;
  }

  public void setResetCacheSql(String resetCacheSql) {
    this.resetCacheSql = resetCacheSql;
  }

  public CommonConfigurationDto ethalonFilesPath(String ethalonFilesPath) {
    this.ethalonFilesPath = ethalonFilesPath;
    return this;
  }

  /**
   * Get ethalonFilesPath
   * @return ethalonFilesPath
  */
  
  @Schema(name = "ethalonFilesPath", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ethalonFilesPath")
  public String getEthalonFilesPath() {
    return ethalonFilesPath;
  }

  public void setEthalonFilesPath(String ethalonFilesPath) {
    this.ethalonFilesPath = ethalonFilesPath;
  }

  public CommonConfigurationDto externalEnvironmentPrefix(String externalEnvironmentPrefix) {
    this.externalEnvironmentPrefix = externalEnvironmentPrefix;
    return this;
  }

  /**
   * Get externalEnvironmentPrefix
   * @return externalEnvironmentPrefix
  */
  
  @Schema(name = "externalEnvironmentPrefix", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalEnvironmentPrefix")
  public String getExternalEnvironmentPrefix() {
    return externalEnvironmentPrefix;
  }

  public void setExternalEnvironmentPrefix(String externalEnvironmentPrefix) {
    this.externalEnvironmentPrefix = externalEnvironmentPrefix;
  }

  public CommonConfigurationDto commandShellSeparator(String commandShellSeparator) {
    this.commandShellSeparator = commandShellSeparator;
    return this;
  }

  /**
   * Get commandShellSeparator
   * @return commandShellSeparator
  */
  
  @Schema(name = "commandShellSeparator", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commandShellSeparator")
  public String getCommandShellSeparator() {
    return commandShellSeparator;
  }

  public void setCommandShellSeparator(String commandShellSeparator) {
    this.commandShellSeparator = commandShellSeparator;
  }

  public CommonConfigurationDto commandShellPrefixes(List<@Valid CommandPrefixDto> commandShellPrefixes) {
    this.commandShellPrefixes = commandShellPrefixes;
    return this;
  }

  public CommonConfigurationDto addCommandShellPrefixesItem(CommandPrefixDto commandShellPrefixesItem) {
    if (this.commandShellPrefixes == null) {
      this.commandShellPrefixes = new ArrayList<>();
    }
    this.commandShellPrefixes.add(commandShellPrefixesItem);
    return this;
  }

  /**
   * Get commandShellPrefixes
   * @return commandShellPrefixes
  */
  @Valid 
  @Schema(name = "commandShellPrefixes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commandShellPrefixes")
  public List<@Valid CommandPrefixDto> getCommandShellPrefixes() {
    return commandShellPrefixes;
  }

  public void setCommandShellPrefixes(List<@Valid CommandPrefixDto> commandShellPrefixes) {
    this.commandShellPrefixes = commandShellPrefixes;
  }

  public CommonConfigurationDto genevaDateMask(String genevaDateMask) {
    this.genevaDateMask = genevaDateMask;
    return this;
  }

  /**
   * Get genevaDateMask
   * @return genevaDateMask
  */
  
  @Schema(name = "genevaDateMask", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("genevaDateMask")
  public String getGenevaDateMask() {
    return genevaDateMask;
  }

  public void setGenevaDateMask(String genevaDateMask) {
    this.genevaDateMask = genevaDateMask;
  }

  public CommonConfigurationDto sshRsaFilePath(String sshRsaFilePath) {
    this.sshRsaFilePath = sshRsaFilePath;
    return this;
  }

  /**
   * Get sshRsaFilePath
   * @return sshRsaFilePath
  */
  
  @Schema(name = "sshRsaFilePath", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sshRsaFilePath")
  public String getSshRsaFilePath() {
    return sshRsaFilePath;
  }

  public void setSshRsaFilePath(String sshRsaFilePath) {
    this.sshRsaFilePath = sshRsaFilePath;
  }

  public CommonConfigurationDto linesAmount(Integer linesAmount) {
    this.linesAmount = linesAmount;
    return this;
  }

  /**
   * Get linesAmount
   * @return linesAmount
  */
  
  @Schema(name = "linesAmount", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("linesAmount")
  public Integer getLinesAmount() {
    return linesAmount;
  }

  public void setLinesAmount(Integer linesAmount) {
    this.linesAmount = linesAmount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommonConfigurationDto commonConfiguration = (CommonConfigurationDto) o;
    return Objects.equals(this.defaultSystem, commonConfiguration.defaultSystem) &&
        Objects.equals(this.useVariablesInsideVariable, commonConfiguration.useVariablesInsideVariable) &&
        Objects.equals(this.variableFormat, commonConfiguration.variableFormat) &&
        Objects.equals(this.saveFilesToWorkingDir, commonConfiguration.saveFilesToWorkingDir) &&
        Objects.equals(this.saveSqlTablesToFile, commonConfiguration.saveSqlTablesToFile) &&
        Objects.equals(this.commonVariables, commonConfiguration.commonVariables) &&
        Objects.equals(this.nextBillDateSql, commonConfiguration.nextBillDateSql) &&
        Objects.equals(this.resetCacheSql, commonConfiguration.resetCacheSql) &&
        Objects.equals(this.ethalonFilesPath, commonConfiguration.ethalonFilesPath) &&
        Objects.equals(this.externalEnvironmentPrefix, commonConfiguration.externalEnvironmentPrefix) &&
        Objects.equals(this.commandShellSeparator, commonConfiguration.commandShellSeparator) &&
        Objects.equals(this.commandShellPrefixes, commonConfiguration.commandShellPrefixes) &&
        Objects.equals(this.genevaDateMask, commonConfiguration.genevaDateMask) &&
        Objects.equals(this.sshRsaFilePath, commonConfiguration.sshRsaFilePath) &&
        Objects.equals(this.linesAmount, commonConfiguration.linesAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultSystem, useVariablesInsideVariable, variableFormat, saveFilesToWorkingDir, saveSqlTablesToFile, commonVariables, nextBillDateSql, resetCacheSql, ethalonFilesPath, externalEnvironmentPrefix, commandShellSeparator, commandShellPrefixes, genevaDateMask, sshRsaFilePath, linesAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommonConfigurationDto {\n");
    sb.append("    defaultSystem: ").append(toIndentedString(defaultSystem)).append("\n");
    sb.append("    useVariablesInsideVariable: ").append(toIndentedString(useVariablesInsideVariable)).append("\n");
    sb.append("    variableFormat: ").append(toIndentedString(variableFormat)).append("\n");
    sb.append("    saveFilesToWorkingDir: ").append(toIndentedString(saveFilesToWorkingDir)).append("\n");
    sb.append("    saveSqlTablesToFile: ").append(toIndentedString(saveSqlTablesToFile)).append("\n");
    sb.append("    commonVariables: ").append(toIndentedString(commonVariables)).append("\n");
    sb.append("    nextBillDateSql: ").append(toIndentedString(nextBillDateSql)).append("\n");
    sb.append("    resetCacheSql: ").append(toIndentedString(resetCacheSql)).append("\n");
    sb.append("    ethalonFilesPath: ").append(toIndentedString(ethalonFilesPath)).append("\n");
    sb.append("    externalEnvironmentPrefix: ").append(toIndentedString(externalEnvironmentPrefix)).append("\n");
    sb.append("    commandShellSeparator: ").append(toIndentedString(commandShellSeparator)).append("\n");
    sb.append("    commandShellPrefixes: ").append(toIndentedString(commandShellPrefixes)).append("\n");
    sb.append("    genevaDateMask: ").append(toIndentedString(genevaDateMask)).append("\n");
    sb.append("    sshRsaFilePath: ").append(toIndentedString(sshRsaFilePath)).append("\n");
    sb.append("    linesAmount: ").append(toIndentedString(linesAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

