package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.ValidatedParametersDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DescriptionDto
 */

@JsonTypeName("Description")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class DescriptionDto {

  private String name;

  @Valid
  private Map<String, String> eventParams = new HashMap<>();

  @Valid
  private Map<String, String> validationParams = new HashMap<>();

  @Valid
  private List<@Valid ValidatedParametersDto> validatedParams;

  @Valid
  private Map<String, String> otherParams = new HashMap<>();

  private Boolean status;

  private Boolean validated;

  private Boolean onMainSheet;

  public DescriptionDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DescriptionDto eventParams(Map<String, String> eventParams) {
    this.eventParams = eventParams;
    return this;
  }

  public DescriptionDto putEventParamsItem(String key, String eventParamsItem) {
    if (this.eventParams == null) {
      this.eventParams = new HashMap<>();
    }
    this.eventParams.put(key, eventParamsItem);
    return this;
  }

  /**
   * Get eventParams
   * @return eventParams
  */
  
  @Schema(name = "eventParams", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("eventParams")
  public Map<String, String> getEventParams() {
    return eventParams;
  }

  public void setEventParams(Map<String, String> eventParams) {
    this.eventParams = eventParams;
  }

  public DescriptionDto validationParams(Map<String, String> validationParams) {
    this.validationParams = validationParams;
    return this;
  }

  public DescriptionDto putValidationParamsItem(String key, String validationParamsItem) {
    if (this.validationParams == null) {
      this.validationParams = new HashMap<>();
    }
    this.validationParams.put(key, validationParamsItem);
    return this;
  }

  /**
   * Get validationParams
   * @return validationParams
  */
  
  @Schema(name = "validationParams", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validationParams")
  public Map<String, String> getValidationParams() {
    return validationParams;
  }

  public void setValidationParams(Map<String, String> validationParams) {
    this.validationParams = validationParams;
  }

  public DescriptionDto validatedParams(List<@Valid ValidatedParametersDto> validatedParams) {
    this.validatedParams = validatedParams;
    return this;
  }

  public DescriptionDto addValidatedParamsItem(ValidatedParametersDto validatedParamsItem) {
    if (this.validatedParams == null) {
      this.validatedParams = new ArrayList<>();
    }
    this.validatedParams.add(validatedParamsItem);
    return this;
  }

  /**
   * Get validatedParams
   * @return validatedParams
  */
  @Valid 
  @Schema(name = "validatedParams", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validatedParams")
  public List<@Valid ValidatedParametersDto> getValidatedParams() {
    return validatedParams;
  }

  public void setValidatedParams(List<@Valid ValidatedParametersDto> validatedParams) {
    this.validatedParams = validatedParams;
  }

  public DescriptionDto otherParams(Map<String, String> otherParams) {
    this.otherParams = otherParams;
    return this;
  }

  public DescriptionDto putOtherParamsItem(String key, String otherParamsItem) {
    if (this.otherParams == null) {
      this.otherParams = new HashMap<>();
    }
    this.otherParams.put(key, otherParamsItem);
    return this;
  }

  /**
   * Get otherParams
   * @return otherParams
  */
  
  @Schema(name = "otherParams", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("otherParams")
  public Map<String, String> getOtherParams() {
    return otherParams;
  }

  public void setOtherParams(Map<String, String> otherParams) {
    this.otherParams = otherParams;
  }

  public DescriptionDto status(Boolean status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("status")
  public Boolean getStatus() {
    return status;
  }

  public void setStatus(Boolean status) {
    this.status = status;
  }

  public DescriptionDto validated(Boolean validated) {
    this.validated = validated;
    return this;
  }

  /**
   * Get validated
   * @return validated
  */
  
  @Schema(name = "validated", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validated")
  public Boolean getValidated() {
    return validated;
  }

  public void setValidated(Boolean validated) {
    this.validated = validated;
  }

  public DescriptionDto onMainSheet(Boolean onMainSheet) {
    this.onMainSheet = onMainSheet;
    return this;
  }

  /**
   * Get onMainSheet
   * @return onMainSheet
  */
  
  @Schema(name = "onMainSheet", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("onMainSheet")
  public Boolean getOnMainSheet() {
    return onMainSheet;
  }

  public void setOnMainSheet(Boolean onMainSheet) {
    this.onMainSheet = onMainSheet;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptionDto description = (DescriptionDto) o;
    return Objects.equals(this.name, description.name) &&
        Objects.equals(this.eventParams, description.eventParams) &&
        Objects.equals(this.validationParams, description.validationParams) &&
        Objects.equals(this.validatedParams, description.validatedParams) &&
        Objects.equals(this.otherParams, description.otherParams) &&
        Objects.equals(this.status, description.status) &&
        Objects.equals(this.validated, description.validated) &&
        Objects.equals(this.onMainSheet, description.onMainSheet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, eventParams, validationParams, validatedParams, otherParams, status, validated, onMainSheet);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptionDto {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    eventParams: ").append(toIndentedString(eventParams)).append("\n");
    sb.append("    validationParams: ").append(toIndentedString(validationParams)).append("\n");
    sb.append("    validatedParams: ").append(toIndentedString(validatedParams)).append("\n");
    sb.append("    otherParams: ").append(toIndentedString(otherParams)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    validated: ").append(toIndentedString(validated)).append("\n");
    sb.append("    onMainSheet: ").append(toIndentedString(onMainSheet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

