package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.CommandResponseDto;
import org.qubership.atp.mia.controllers.api.dto.ExceptionDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessStatusDto;
import org.qubership.atp.mia.controllers.api.dto.SqlResponseDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExecutionResponseDto
 */

@JsonTypeName("ExecutionResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class ExecutionResponseDto {

  private String processName;

  private String executedCommand;

  private CommandResponseDto commandResponse;

  @Valid
  private List<@Valid SqlResponseDto> validations;

  @Valid
  private List<@Valid CommandResponseDto> prerequisites;

  private ProcessStatusDto processStatus;

  private ExceptionDto error;

  @Valid
  private Map<String, String> globalVariables = new HashMap<>();

  private UUID entityId;

  private String entityUrl;

  private Integer duration;

  public ExecutionResponseDto processName(String processName) {
    this.processName = processName;
    return this;
  }

  /**
   * Get processName
   * @return processName
  */
  
  @Schema(name = "processName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processName")
  public String getProcessName() {
    return processName;
  }

  public void setProcessName(String processName) {
    this.processName = processName;
  }

  public ExecutionResponseDto executedCommand(String executedCommand) {
    this.executedCommand = executedCommand;
    return this;
  }

  /**
   * Get executedCommand
   * @return executedCommand
  */
  
  @Schema(name = "executedCommand", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("executedCommand")
  public String getExecutedCommand() {
    return executedCommand;
  }

  public void setExecutedCommand(String executedCommand) {
    this.executedCommand = executedCommand;
  }

  public ExecutionResponseDto commandResponse(CommandResponseDto commandResponse) {
    this.commandResponse = commandResponse;
    return this;
  }

  /**
   * Get commandResponse
   * @return commandResponse
  */
  @Valid 
  @Schema(name = "commandResponse", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commandResponse")
  public CommandResponseDto getCommandResponse() {
    return commandResponse;
  }

  public void setCommandResponse(CommandResponseDto commandResponse) {
    this.commandResponse = commandResponse;
  }

  public ExecutionResponseDto validations(List<@Valid SqlResponseDto> validations) {
    this.validations = validations;
    return this;
  }

  public ExecutionResponseDto addValidationsItem(SqlResponseDto validationsItem) {
    if (this.validations == null) {
      this.validations = new ArrayList<>();
    }
    this.validations.add(validationsItem);
    return this;
  }

  /**
   * Get validations
   * @return validations
  */
  @Valid 
  @Schema(name = "validations", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validations")
  public List<@Valid SqlResponseDto> getValidations() {
    return validations;
  }

  public void setValidations(List<@Valid SqlResponseDto> validations) {
    this.validations = validations;
  }

  public ExecutionResponseDto prerequisites(List<@Valid CommandResponseDto> prerequisites) {
    this.prerequisites = prerequisites;
    return this;
  }

  public ExecutionResponseDto addPrerequisitesItem(CommandResponseDto prerequisitesItem) {
    if (this.prerequisites == null) {
      this.prerequisites = new ArrayList<>();
    }
    this.prerequisites.add(prerequisitesItem);
    return this;
  }

  /**
   * Get prerequisites
   * @return prerequisites
  */
  @Valid 
  @Schema(name = "prerequisites", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("prerequisites")
  public List<@Valid CommandResponseDto> getPrerequisites() {
    return prerequisites;
  }

  public void setPrerequisites(List<@Valid CommandResponseDto> prerequisites) {
    this.prerequisites = prerequisites;
  }

  public ExecutionResponseDto processStatus(ProcessStatusDto processStatus) {
    this.processStatus = processStatus;
    return this;
  }

  /**
   * Get processStatus
   * @return processStatus
  */
  @Valid 
  @Schema(name = "processStatus", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processStatus")
  public ProcessStatusDto getProcessStatus() {
    return processStatus;
  }

  public void setProcessStatus(ProcessStatusDto processStatus) {
    this.processStatus = processStatus;
  }

  public ExecutionResponseDto error(ExceptionDto error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @Valid 
  @Schema(name = "error", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("error")
  public ExceptionDto getError() {
    return error;
  }

  public void setError(ExceptionDto error) {
    this.error = error;
  }

  public ExecutionResponseDto globalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
    return this;
  }

  public ExecutionResponseDto putGlobalVariablesItem(String key, String globalVariablesItem) {
    if (this.globalVariables == null) {
      this.globalVariables = new HashMap<>();
    }
    this.globalVariables.put(key, globalVariablesItem);
    return this;
  }

  /**
   * Get globalVariables
   * @return globalVariables
  */
  
  @Schema(name = "globalVariables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("globalVariables")
  public Map<String, String> getGlobalVariables() {
    return globalVariables;
  }

  public void setGlobalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
  }

  public ExecutionResponseDto entityId(UUID entityId) {
    this.entityId = entityId;
    return this;
  }

  /**
   * Get entityId
   * @return entityId
  */
  @Valid 
  @Schema(name = "entityId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("entityId")
  public UUID getEntityId() {
    return entityId;
  }

  public void setEntityId(UUID entityId) {
    this.entityId = entityId;
  }

  public ExecutionResponseDto entityUrl(String entityUrl) {
    this.entityUrl = entityUrl;
    return this;
  }

  /**
   * Get entityUrl
   * @return entityUrl
  */
  
  @Schema(name = "entityUrl", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("entityUrl")
  public String getEntityUrl() {
    return entityUrl;
  }

  public void setEntityUrl(String entityUrl) {
    this.entityUrl = entityUrl;
  }

  public ExecutionResponseDto duration(Integer duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Get duration
   * @return duration
  */
  
  @Schema(name = "duration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("duration")
  public Integer getDuration() {
    return duration;
  }

  public void setDuration(Integer duration) {
    this.duration = duration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionResponseDto executionResponse = (ExecutionResponseDto) o;
    return Objects.equals(this.processName, executionResponse.processName) &&
        Objects.equals(this.executedCommand, executionResponse.executedCommand) &&
        Objects.equals(this.commandResponse, executionResponse.commandResponse) &&
        Objects.equals(this.validations, executionResponse.validations) &&
        Objects.equals(this.prerequisites, executionResponse.prerequisites) &&
        Objects.equals(this.processStatus, executionResponse.processStatus) &&
        Objects.equals(this.error, executionResponse.error) &&
        Objects.equals(this.globalVariables, executionResponse.globalVariables) &&
        Objects.equals(this.entityId, executionResponse.entityId) &&
        Objects.equals(this.entityUrl, executionResponse.entityUrl) &&
        Objects.equals(this.duration, executionResponse.duration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processName, executedCommand, commandResponse, validations, prerequisites, processStatus, error, globalVariables, entityId, entityUrl, duration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionResponseDto {\n");
    sb.append("    processName: ").append(toIndentedString(processName)).append("\n");
    sb.append("    executedCommand: ").append(toIndentedString(executedCommand)).append("\n");
    sb.append("    commandResponse: ").append(toIndentedString(commandResponse)).append("\n");
    sb.append("    validations: ").append(toIndentedString(validations)).append("\n");
    sb.append("    prerequisites: ").append(toIndentedString(prerequisites)).append("\n");
    sb.append("    processStatus: ").append(toIndentedString(processStatus)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    globalVariables: ").append(toIndentedString(globalVariables)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    entityUrl: ").append(toIndentedString(entityUrl)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

