package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.CommonConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigSectionDto;
import org.qubership.atp.mia.controllers.api.dto.HeaderConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.PotHeaderConfigurationDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * FlowConfigDto
 */

@JsonTypeName("FlowConfig")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:32.397559642Z[Etc/UTC]")
public class FlowConfigDto {

  private String validationResult;

  private HeaderConfigurationDto headerConfiguration;

  private CommonConfigurationDto commonConfiguration;

  private PotHeaderConfigurationDto potHeaderConfiguration;

  private String defaultSystem;

  @Valid
  private List<@Valid FlowConfigSectionDto> sections;

  public FlowConfigDto validationResult(String validationResult) {
    this.validationResult = validationResult;
    return this;
  }

  /**
   * Get validationResult
   * @return validationResult
  */
  
  @Schema(name = "validationResult", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validationResult")
  public String getValidationResult() {
    return validationResult;
  }

  public void setValidationResult(String validationResult) {
    this.validationResult = validationResult;
  }

  public FlowConfigDto headerConfiguration(HeaderConfigurationDto headerConfiguration) {
    this.headerConfiguration = headerConfiguration;
    return this;
  }

  /**
   * Get headerConfiguration
   * @return headerConfiguration
  */
  @Valid 
  @Schema(name = "headerConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("headerConfiguration")
  public HeaderConfigurationDto getHeaderConfiguration() {
    return headerConfiguration;
  }

  public void setHeaderConfiguration(HeaderConfigurationDto headerConfiguration) {
    this.headerConfiguration = headerConfiguration;
  }

  public FlowConfigDto commonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
    return this;
  }

  /**
   * Get commonConfiguration
   * @return commonConfiguration
  */
  @Valid 
  @Schema(name = "commonConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commonConfiguration")
  public CommonConfigurationDto getCommonConfiguration() {
    return commonConfiguration;
  }

  public void setCommonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
  }

  public FlowConfigDto potHeaderConfiguration(PotHeaderConfigurationDto potHeaderConfiguration) {
    this.potHeaderConfiguration = potHeaderConfiguration;
    return this;
  }

  /**
   * Get potHeaderConfiguration
   * @return potHeaderConfiguration
  */
  @Valid 
  @Schema(name = "potHeaderConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("potHeaderConfiguration")
  public PotHeaderConfigurationDto getPotHeaderConfiguration() {
    return potHeaderConfiguration;
  }

  public void setPotHeaderConfiguration(PotHeaderConfigurationDto potHeaderConfiguration) {
    this.potHeaderConfiguration = potHeaderConfiguration;
  }

  public FlowConfigDto defaultSystem(String defaultSystem) {
    this.defaultSystem = defaultSystem;
    return this;
  }

  /**
   * Get defaultSystem
   * @return defaultSystem
  */
  
  @Schema(name = "defaultSystem", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultSystem")
  public String getDefaultSystem() {
    return defaultSystem;
  }

  public void setDefaultSystem(String defaultSystem) {
    this.defaultSystem = defaultSystem;
  }

  public FlowConfigDto sections(List<@Valid FlowConfigSectionDto> sections) {
    this.sections = sections;
    return this;
  }

  public FlowConfigDto addSectionsItem(FlowConfigSectionDto sectionsItem) {
    if (this.sections == null) {
      this.sections = new ArrayList<>();
    }
    this.sections.add(sectionsItem);
    return this;
  }

  /**
   * Get sections
   * @return sections
  */
  @Valid 
  @Schema(name = "sections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sections")
  public List<@Valid FlowConfigSectionDto> getSections() {
    return sections;
  }

  public void setSections(List<@Valid FlowConfigSectionDto> sections) {
    this.sections = sections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowConfigDto flowConfig = (FlowConfigDto) o;
    return Objects.equals(this.validationResult, flowConfig.validationResult) &&
        Objects.equals(this.headerConfiguration, flowConfig.headerConfiguration) &&
        Objects.equals(this.commonConfiguration, flowConfig.commonConfiguration) &&
        Objects.equals(this.potHeaderConfiguration, flowConfig.potHeaderConfiguration) &&
        Objects.equals(this.defaultSystem, flowConfig.defaultSystem) &&
        Objects.equals(this.sections, flowConfig.sections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validationResult, headerConfiguration, commonConfiguration, potHeaderConfiguration, defaultSystem, sections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowConfigDto {\n");
    sb.append("    validationResult: ").append(toIndentedString(validationResult)).append("\n");
    sb.append("    headerConfiguration: ").append(toIndentedString(headerConfiguration)).append("\n");
    sb.append("    commonConfiguration: ").append(toIndentedString(commonConfiguration)).append("\n");
    sb.append("    potHeaderConfiguration: ").append(toIndentedString(potHeaderConfiguration)).append("\n");
    sb.append("    defaultSystem: ").append(toIndentedString(defaultSystem)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

