package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.ExecutableDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * FlowConfigSectionDto
 */

@JsonTypeName("FlowConfigSection")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:32.397559642Z[Etc/UTC]")
public class FlowConfigSectionDto {

  private UUID id;

  private String name;

  @Valid
  private List<@Valid ExecutableDto> processes;

  @Valid
  private List<@Valid FlowConfigSectionDto> sections;

  public FlowConfigSectionDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public FlowConfigSectionDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FlowConfigSectionDto processes(List<@Valid ExecutableDto> processes) {
    this.processes = processes;
    return this;
  }

  public FlowConfigSectionDto addProcessesItem(ExecutableDto processesItem) {
    if (this.processes == null) {
      this.processes = new ArrayList<>();
    }
    this.processes.add(processesItem);
    return this;
  }

  /**
   * Get processes
   * @return processes
  */
  @Valid 
  @Schema(name = "processes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processes")
  public List<@Valid ExecutableDto> getProcesses() {
    return processes;
  }

  public void setProcesses(List<@Valid ExecutableDto> processes) {
    this.processes = processes;
  }

  public FlowConfigSectionDto sections(List<@Valid FlowConfigSectionDto> sections) {
    this.sections = sections;
    return this;
  }

  public FlowConfigSectionDto addSectionsItem(FlowConfigSectionDto sectionsItem) {
    if (this.sections == null) {
      this.sections = new ArrayList<>();
    }
    this.sections.add(sectionsItem);
    return this;
  }

  /**
   * Get sections
   * @return sections
  */
  @Valid 
  @Schema(name = "sections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sections")
  public List<@Valid FlowConfigSectionDto> getSections() {
    return sections;
  }

  public void setSections(List<@Valid FlowConfigSectionDto> sections) {
    this.sections = sections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowConfigSectionDto flowConfigSection = (FlowConfigSectionDto) o;
    return Objects.equals(this.id, flowConfigSection.id) &&
        Objects.equals(this.name, flowConfigSection.name) &&
        Objects.equals(this.processes, flowConfigSection.processes) &&
        Objects.equals(this.sections, flowConfigSection.sections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, processes, sections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowConfigSectionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    processes: ").append(toIndentedString(processes)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

