package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectDirectoryDto
 */

@JsonTypeName("ProjectDirectory")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:32.397559642Z[Etc/UTC]")
public class ProjectDirectoryDto {

  private UUID id;

  private String name;

  private UUID parentDirectoryId;

  /**
   * Default constructor
   * @deprecated Use {@link ProjectDirectoryDto#ProjectDirectoryDto(String)}
   */
  @Deprecated
  public ProjectDirectoryDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ProjectDirectoryDto(String name) {
    this.name = name;
  }

  public ProjectDirectoryDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ProjectDirectoryDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProjectDirectoryDto parentDirectoryId(UUID parentDirectoryId) {
    this.parentDirectoryId = parentDirectoryId;
    return this;
  }

  /**
   * Get parentDirectoryId
   * @return parentDirectoryId
  */
  @Valid 
  @Schema(name = "parentDirectoryId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentDirectoryId")
  public UUID getParentDirectoryId() {
    return parentDirectoryId;
  }

  public void setParentDirectoryId(UUID parentDirectoryId) {
    this.parentDirectoryId = parentDirectoryId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectDirectoryDto projectDirectory = (ProjectDirectoryDto) o;
    return Objects.equals(this.id, projectDirectory.id) &&
        Objects.equals(this.name, projectDirectory.name) &&
        Objects.equals(this.parentDirectoryId, projectDirectory.parentDirectoryId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, parentDirectoryId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectDirectoryDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parentDirectoryId: ").append(toIndentedString(parentDirectoryId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

