package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.QueriesSheetRecordDto;
import org.qubership.atp.mia.controllers.api.dto.QueryDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * QueriesSheetDto
 */

@JsonTypeName("QueriesSheet")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class QueriesSheetDto {

  @Valid
  private List<@Valid QueryDto> queries;

  @Valid
  private List<@Valid QueriesSheetRecordDto> records;

  public QueriesSheetDto queries(List<@Valid QueryDto> queries) {
    this.queries = queries;
    return this;
  }

  public QueriesSheetDto addQueriesItem(QueryDto queriesItem) {
    if (this.queries == null) {
      this.queries = new ArrayList<>();
    }
    this.queries.add(queriesItem);
    return this;
  }

  /**
   * Get queries
   * @return queries
  */
  @Valid 
  @Schema(name = "queries", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("queries")
  public List<@Valid QueryDto> getQueries() {
    return queries;
  }

  public void setQueries(List<@Valid QueryDto> queries) {
    this.queries = queries;
  }

  public QueriesSheetDto records(List<@Valid QueriesSheetRecordDto> records) {
    this.records = records;
    return this;
  }

  public QueriesSheetDto addRecordsItem(QueriesSheetRecordDto recordsItem) {
    if (this.records == null) {
      this.records = new ArrayList<>();
    }
    this.records.add(recordsItem);
    return this;
  }

  /**
   * Get records
   * @return records
  */
  @Valid 
  @Schema(name = "records", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("records")
  public List<@Valid QueriesSheetRecordDto> getRecords() {
    return records;
  }

  public void setRecords(List<@Valid QueriesSheetRecordDto> records) {
    this.records = records;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueriesSheetDto queriesSheet = (QueriesSheetDto) o;
    return Objects.equals(this.queries, queriesSheet.queries) &&
        Objects.equals(this.records, queriesSheet.records);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queries, records);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueriesSheetDto {\n");
    sb.append("    queries: ").append(toIndentedString(queries)).append("\n");
    sb.append("    records: ").append(toIndentedString(records)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

