package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SectionDto
 */

@JsonTypeName("Section")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:32.397559642Z[Etc/UTC]")
public class SectionDto {

  private UUID id;

  private String name;

  private UUID parentSection;

  private Integer place;

  @Valid
  private List<@Valid SectionDto> sections;

  @Valid
  private List<@Valid CompoundDto> compounds;

  @Valid
  private List<@Valid ProcessDto> processes;

  /**
   * Default constructor
   * @deprecated Use {@link SectionDto#SectionDto(String, Integer)}
   */
  @Deprecated
  public SectionDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public SectionDto(String name, Integer place) {
    this.name = name;
    this.place = place;
  }

  public SectionDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public SectionDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SectionDto parentSection(UUID parentSection) {
    this.parentSection = parentSection;
    return this;
  }

  /**
   * Get parentSection
   * @return parentSection
  */
  @Valid 
  @Schema(name = "parentSection", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentSection")
  public UUID getParentSection() {
    return parentSection;
  }

  public void setParentSection(UUID parentSection) {
    this.parentSection = parentSection;
  }

  public SectionDto place(Integer place) {
    this.place = place;
    return this;
  }

  /**
   * Get place
   * @return place
  */
  @NotNull 
  @Schema(name = "place", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("place")
  public Integer getPlace() {
    return place;
  }

  public void setPlace(Integer place) {
    this.place = place;
  }

  public SectionDto sections(List<@Valid SectionDto> sections) {
    this.sections = sections;
    return this;
  }

  public SectionDto addSectionsItem(SectionDto sectionsItem) {
    if (this.sections == null) {
      this.sections = new ArrayList<>();
    }
    this.sections.add(sectionsItem);
    return this;
  }

  /**
   * Get sections
   * @return sections
  */
  @Valid 
  @Schema(name = "sections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sections")
  public List<@Valid SectionDto> getSections() {
    return sections;
  }

  public void setSections(List<@Valid SectionDto> sections) {
    this.sections = sections;
  }

  public SectionDto compounds(List<@Valid CompoundDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public SectionDto addCompoundsItem(CompoundDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("compounds")
  public List<@Valid CompoundDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<@Valid CompoundDto> compounds) {
    this.compounds = compounds;
  }

  public SectionDto processes(List<@Valid ProcessDto> processes) {
    this.processes = processes;
    return this;
  }

  public SectionDto addProcessesItem(ProcessDto processesItem) {
    if (this.processes == null) {
      this.processes = new ArrayList<>();
    }
    this.processes.add(processesItem);
    return this;
  }

  /**
   * Get processes
   * @return processes
  */
  @Valid 
  @Schema(name = "processes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processes")
  public List<@Valid ProcessDto> getProcesses() {
    return processes;
  }

  public void setProcesses(List<@Valid ProcessDto> processes) {
    this.processes = processes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SectionDto section = (SectionDto) o;
    return Objects.equals(this.id, section.id) &&
        Objects.equals(this.name, section.name) &&
        Objects.equals(this.parentSection, section.parentSection) &&
        Objects.equals(this.place, section.place) &&
        Objects.equals(this.sections, section.sections) &&
        Objects.equals(this.compounds, section.compounds) &&
        Objects.equals(this.processes, section.processes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, parentSection, place, sections, compounds, processes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SectionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parentSection: ").append(toIndentedString(parentSection)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    processes: ").append(toIndentedString(processes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

