package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.DbTableDto;
import org.qubership.atp.mia.controllers.api.dto.LinkDto;
import org.qubership.atp.mia.controllers.api.dto.TableMarkerResultDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SqlResponseDto
 */

@JsonTypeName("SqlResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class SqlResponseDto {

  private DbTableDto data;

  private String tableName;

  private String query;

  private String description;

  private Integer records;

  private TableMarkerResultDto tableMarkerResult;

  private String internalPathToFile;

  private LinkDto link;

  private Boolean saveToWordFile;

  private Boolean saveToZipFile;

  @Valid
  private Map<String, String> connectionInfo = new HashMap<>();

  public SqlResponseDto data(DbTableDto data) {
    this.data = data;
    return this;
  }

  /**
   * Get data
   * @return data
  */
  @Valid 
  @Schema(name = "data", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data")
  public DbTableDto getData() {
    return data;
  }

  public void setData(DbTableDto data) {
    this.data = data;
  }

  public SqlResponseDto tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

  /**
   * Get tableName
   * @return tableName
  */
  
  @Schema(name = "tableName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tableName")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public SqlResponseDto query(String query) {
    this.query = query;
    return this;
  }

  /**
   * Get query
   * @return query
  */
  
  @Schema(name = "query", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("query")
  public String getQuery() {
    return query;
  }

  public void setQuery(String query) {
    this.query = query;
  }

  public SqlResponseDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public SqlResponseDto records(Integer records) {
    this.records = records;
    return this;
  }

  /**
   * Get records
   * @return records
  */
  
  @Schema(name = "records", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("records")
  public Integer getRecords() {
    return records;
  }

  public void setRecords(Integer records) {
    this.records = records;
  }

  public SqlResponseDto tableMarkerResult(TableMarkerResultDto tableMarkerResult) {
    this.tableMarkerResult = tableMarkerResult;
    return this;
  }

  /**
   * Get tableMarkerResult
   * @return tableMarkerResult
  */
  @Valid 
  @Schema(name = "tableMarkerResult", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tableMarkerResult")
  public TableMarkerResultDto getTableMarkerResult() {
    return tableMarkerResult;
  }

  public void setTableMarkerResult(TableMarkerResultDto tableMarkerResult) {
    this.tableMarkerResult = tableMarkerResult;
  }

  public SqlResponseDto internalPathToFile(String internalPathToFile) {
    this.internalPathToFile = internalPathToFile;
    return this;
  }

  /**
   * Get internalPathToFile
   * @return internalPathToFile
  */
  
  @Schema(name = "internalPathToFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("internalPathToFile")
  public String getInternalPathToFile() {
    return internalPathToFile;
  }

  public void setInternalPathToFile(String internalPathToFile) {
    this.internalPathToFile = internalPathToFile;
  }

  public SqlResponseDto link(LinkDto link) {
    this.link = link;
    return this;
  }

  /**
   * Get link
   * @return link
  */
  @Valid 
  @Schema(name = "link", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("link")
  public LinkDto getLink() {
    return link;
  }

  public void setLink(LinkDto link) {
    this.link = link;
  }

  public SqlResponseDto saveToWordFile(Boolean saveToWordFile) {
    this.saveToWordFile = saveToWordFile;
    return this;
  }

  /**
   * Get saveToWordFile
   * @return saveToWordFile
  */
  
  @Schema(name = "saveToWordFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveToWordFile")
  public Boolean getSaveToWordFile() {
    return saveToWordFile;
  }

  public void setSaveToWordFile(Boolean saveToWordFile) {
    this.saveToWordFile = saveToWordFile;
  }

  public SqlResponseDto saveToZipFile(Boolean saveToZipFile) {
    this.saveToZipFile = saveToZipFile;
    return this;
  }

  /**
   * Get saveToZipFile
   * @return saveToZipFile
  */
  
  @Schema(name = "saveToZipFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveToZipFile")
  public Boolean getSaveToZipFile() {
    return saveToZipFile;
  }

  public void setSaveToZipFile(Boolean saveToZipFile) {
    this.saveToZipFile = saveToZipFile;
  }

  public SqlResponseDto connectionInfo(Map<String, String> connectionInfo) {
    this.connectionInfo = connectionInfo;
    return this;
  }

  public SqlResponseDto putConnectionInfoItem(String key, String connectionInfoItem) {
    if (this.connectionInfo == null) {
      this.connectionInfo = new HashMap<>();
    }
    this.connectionInfo.put(key, connectionInfoItem);
    return this;
  }

  /**
   * Get connectionInfo
   * @return connectionInfo
  */
  
  @Schema(name = "connectionInfo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("connectionInfo")
  public Map<String, String> getConnectionInfo() {
    return connectionInfo;
  }

  public void setConnectionInfo(Map<String, String> connectionInfo) {
    this.connectionInfo = connectionInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SqlResponseDto sqlResponse = (SqlResponseDto) o;
    return Objects.equals(this.data, sqlResponse.data) &&
        Objects.equals(this.tableName, sqlResponse.tableName) &&
        Objects.equals(this.query, sqlResponse.query) &&
        Objects.equals(this.description, sqlResponse.description) &&
        Objects.equals(this.records, sqlResponse.records) &&
        Objects.equals(this.tableMarkerResult, sqlResponse.tableMarkerResult) &&
        Objects.equals(this.internalPathToFile, sqlResponse.internalPathToFile) &&
        Objects.equals(this.link, sqlResponse.link) &&
        Objects.equals(this.saveToWordFile, sqlResponse.saveToWordFile) &&
        Objects.equals(this.saveToZipFile, sqlResponse.saveToZipFile) &&
        Objects.equals(this.connectionInfo, sqlResponse.connectionInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, tableName, query, description, records, tableMarkerResult, internalPathToFile, link, saveToWordFile, saveToZipFile, connectionInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SqlResponseDto {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    records: ").append(toIndentedString(records)).append("\n");
    sb.append("    tableMarkerResult: ").append(toIndentedString(tableMarkerResult)).append("\n");
    sb.append("    internalPathToFile: ").append(toIndentedString(internalPathToFile)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    saveToWordFile: ").append(toIndentedString(saveToWordFile)).append("\n");
    sb.append("    saveToZipFile: ").append(toIndentedString(saveToZipFile)).append("\n");
    sb.append("    connectionInfo: ").append(toIndentedString(connectionInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

