package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.MainSheetRecordDto;
import org.qubership.atp.mia.controllers.api.dto.ScenarioDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestDataSheetDto
 */

@JsonTypeName("TestDataSheet")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:33.235724277Z[Etc/UTC]")
public class TestDataSheetDto {

  @Valid
  private List<@Valid MainSheetRecordDto> records;

  @Valid
  private List<@Valid ScenarioDto> scenarios;

  public TestDataSheetDto records(List<@Valid MainSheetRecordDto> records) {
    this.records = records;
    return this;
  }

  public TestDataSheetDto addRecordsItem(MainSheetRecordDto recordsItem) {
    if (this.records == null) {
      this.records = new ArrayList<>();
    }
    this.records.add(recordsItem);
    return this;
  }

  /**
   * Get records
   * @return records
  */
  @Valid 
  @Schema(name = "records", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("records")
  public List<@Valid MainSheetRecordDto> getRecords() {
    return records;
  }

  public void setRecords(List<@Valid MainSheetRecordDto> records) {
    this.records = records;
  }

  public TestDataSheetDto scenarios(List<@Valid ScenarioDto> scenarios) {
    this.scenarios = scenarios;
    return this;
  }

  public TestDataSheetDto addScenariosItem(ScenarioDto scenariosItem) {
    if (this.scenarios == null) {
      this.scenarios = new ArrayList<>();
    }
    this.scenarios.add(scenariosItem);
    return this;
  }

  /**
   * Get scenarios
   * @return scenarios
  */
  @Valid 
  @Schema(name = "scenarios", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("scenarios")
  public List<@Valid ScenarioDto> getScenarios() {
    return scenarios;
  }

  public void setScenarios(List<@Valid ScenarioDto> scenarios) {
    this.scenarios = scenarios;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestDataSheetDto testDataSheet = (TestDataSheetDto) o;
    return Objects.equals(this.records, testDataSheet.records) &&
        Objects.equals(this.scenarios, testDataSheet.scenarios);
  }

  @Override
  public int hashCode() {
    return Objects.hash(records, scenarios);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestDataSheetDto {\n");
    sb.append("    records: ").append(toIndentedString(records)).append("\n");
    sb.append("    scenarios: ").append(toIndentedString(scenarios)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

