package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.TableMarkerDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ValidationDto
 */

@JsonTypeName("Validation")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T07:58:34.044919947Z[Etc/UTC]")
public class ValidationDto {

  private String tableName;

  @Valid
  private List<String> referToCommandExecution;

  private TableMarkerDto tableMarker;

  @Valid
  private Map<String, String> exportVariables = new HashMap<>();

  private Boolean saveToWordFile;

  private Boolean saveToZipFile;

  private String name;

  private String type;

  private String system;

  private String value;

  @Valid
  private List<String> values;

  public ValidationDto tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

  /**
   * Get tableName
   * @return tableName
  */
  
  @Schema(name = "tableName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tableName")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public ValidationDto referToCommandExecution(List<String> referToCommandExecution) {
    this.referToCommandExecution = referToCommandExecution;
    return this;
  }

  public ValidationDto addReferToCommandExecutionItem(String referToCommandExecutionItem) {
    if (this.referToCommandExecution == null) {
      this.referToCommandExecution = new ArrayList<>();
    }
    this.referToCommandExecution.add(referToCommandExecutionItem);
    return this;
  }

  /**
   * Get referToCommandExecution
   * @return referToCommandExecution
  */
  
  @Schema(name = "referToCommandExecution", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("referToCommandExecution")
  public List<String> getReferToCommandExecution() {
    return referToCommandExecution;
  }

  public void setReferToCommandExecution(List<String> referToCommandExecution) {
    this.referToCommandExecution = referToCommandExecution;
  }

  public ValidationDto tableMarker(TableMarkerDto tableMarker) {
    this.tableMarker = tableMarker;
    return this;
  }

  /**
   * Get tableMarker
   * @return tableMarker
  */
  @Valid 
  @Schema(name = "tableMarker", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tableMarker")
  public TableMarkerDto getTableMarker() {
    return tableMarker;
  }

  public void setTableMarker(TableMarkerDto tableMarker) {
    this.tableMarker = tableMarker;
  }

  public ValidationDto exportVariables(Map<String, String> exportVariables) {
    this.exportVariables = exportVariables;
    return this;
  }

  public ValidationDto putExportVariablesItem(String key, String exportVariablesItem) {
    if (this.exportVariables == null) {
      this.exportVariables = new HashMap<>();
    }
    this.exportVariables.put(key, exportVariablesItem);
    return this;
  }

  /**
   * Get exportVariables
   * @return exportVariables
  */
  
  @Schema(name = "exportVariables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("exportVariables")
  public Map<String, String> getExportVariables() {
    return exportVariables;
  }

  public void setExportVariables(Map<String, String> exportVariables) {
    this.exportVariables = exportVariables;
  }

  public ValidationDto saveToWordFile(Boolean saveToWordFile) {
    this.saveToWordFile = saveToWordFile;
    return this;
  }

  /**
   * Get saveToWordFile
   * @return saveToWordFile
  */
  
  @Schema(name = "saveToWordFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveToWordFile")
  public Boolean getSaveToWordFile() {
    return saveToWordFile;
  }

  public void setSaveToWordFile(Boolean saveToWordFile) {
    this.saveToWordFile = saveToWordFile;
  }

  public ValidationDto saveToZipFile(Boolean saveToZipFile) {
    this.saveToZipFile = saveToZipFile;
    return this;
  }

  /**
   * Get saveToZipFile
   * @return saveToZipFile
  */
  
  @Schema(name = "saveToZipFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveToZipFile")
  public Boolean getSaveToZipFile() {
    return saveToZipFile;
  }

  public void setSaveToZipFile(Boolean saveToZipFile) {
    this.saveToZipFile = saveToZipFile;
  }

  public ValidationDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ValidationDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ValidationDto system(String system) {
    this.system = system;
    return this;
  }

  /**
   * Get system
   * @return system
  */
  
  @Schema(name = "system", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("system")
  public String getSystem() {
    return system;
  }

  public void setSystem(String system) {
    this.system = system;
  }

  public ValidationDto value(String value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
  */
  
  @Schema(name = "value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public ValidationDto values(List<String> values) {
    this.values = values;
    return this;
  }

  public ValidationDto addValuesItem(String valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

  /**
   * Get values
   * @return values
  */
  
  @Schema(name = "values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("values")
  public List<String> getValues() {
    return values;
  }

  public void setValues(List<String> values) {
    this.values = values;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValidationDto validation = (ValidationDto) o;
    return Objects.equals(this.tableName, validation.tableName) &&
        Objects.equals(this.referToCommandExecution, validation.referToCommandExecution) &&
        Objects.equals(this.tableMarker, validation.tableMarker) &&
        Objects.equals(this.exportVariables, validation.exportVariables) &&
        Objects.equals(this.saveToWordFile, validation.saveToWordFile) &&
        Objects.equals(this.saveToZipFile, validation.saveToZipFile) &&
        Objects.equals(this.name, validation.name) &&
        Objects.equals(this.type, validation.type) &&
        Objects.equals(this.system, validation.system) &&
        Objects.equals(this.value, validation.value) &&
        Objects.equals(this.values, validation.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tableName, referToCommandExecution, tableMarker, exportVariables, saveToWordFile, saveToZipFile, name, type, system, value, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValidationDto {\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    referToCommandExecution: ").append(toIndentedString(referToCommandExecution)).append("\n");
    sb.append("    tableMarker: ").append(toIndentedString(tableMarker)).append("\n");
    sb.append("    exportVariables: ").append(toIndentedString(exportVariables)).append("\n");
    sb.append("    saveToWordFile: ").append(toIndentedString(saveToWordFile)).append("\n");
    sb.append("    saveToZipFile: ").append(toIndentedString(saveToZipFile)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    system: ").append(toIndentedString(system)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

