/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.6.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.mia.controllers.api;

import java.util.List;
import java.util.UUID;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:44.748438219Z[Etc/UTC]")
@Validated
@Tag(name = "mia-file-controller", description = "MIA File Controller")
public interface MiaFileControllerApi {

    /**
     * GET /rest/downloadFile/{projectId}/MIA_FILE_TYPE_LOG/{sessionId}/{logFile}
     * Download file of execution
     *
     * @param projectId projectId (required)
     * @param sessionId sessionId (required)
     * @param logFile logFile (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "downloadFile",
        description = "Download file of execution",
        tags = { "mia-file-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/downloadFile/{projectId}/MIA_FILE_TYPE_LOG/{sessionId}/{logFile}",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> downloadFile(
        @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "sessionId", description = "sessionId", required = true, in = ParameterIn.PATH) @PathVariable("sessionId") UUID sessionId,
        @Parameter(name = "logFile", description = "logFile", required = true, in = ParameterIn.PATH) @PathVariable("logFile") String logFile
    );


    /**
     * GET /rest/downloadFile/{projectId}/MIA_FILE_TYPE_UPLOAD/{sessionId}/{logFile}
     * Download file from uploads
     *
     * @param projectId projectId (required)
     * @param sessionId sessionId (required)
     * @param logFile logFile (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "downloadFileFromUploads",
        description = "Download file from uploads",
        tags = { "mia-file-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/downloadFile/{projectId}/MIA_FILE_TYPE_UPLOAD/{sessionId}/{logFile}",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> downloadFileFromUploads(
        @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "sessionId", description = "sessionId", required = true, in = ParameterIn.PATH) @PathVariable("sessionId") UUID sessionId,
        @Parameter(name = "logFile", description = "logFile", required = true, in = ParameterIn.PATH) @PathVariable("logFile") String logFile
    );


    /**
     * POST /rest/downloadOutputAsZip
     * downloadOutputAsZip
     *
     * @param projectId projectId (required)
     * @param sessionId sessionId (required)
     * @param processName processName (required)
     * @param requestBody filePaths (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "downloadOutputAsZip",
        description = "downloadOutputAsZip",
        tags = { "mia-file-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/rest/downloadOutputAsZip",
        produces = { "application/octet-stream" },
        consumes = { "application/json" }
    )
    ResponseEntity<org.springframework.core.io.Resource> downloadOutputAsZip(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @NotNull @Parameter(name = "sessionId", description = "sessionId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "sessionId", required = true) UUID sessionId,
        @NotNull @Parameter(name = "processName", description = "processName", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "processName", required = true) String processName,
        @Parameter(name = "request_body", description = "filePaths", required = true) @Valid @RequestBody List<String> requestBody
    );


    /**
     * POST /rest/uploadFile
     * Upload file for project.
     *
     * @param projectId projectId (required)
     * @param sessionId sessionId (required)
     * @param needDos2Unix needDos2Unix (optional)
     * @param file file (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "handleFileUpload",
        description = "Upload file for project.",
        tags = { "mia-file-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/rest/uploadFile",
        produces = { "application/json" },
        consumes = { "multipart/form-data" }
    )
    ResponseEntity<String> handleFileUpload(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @NotNull @Parameter(name = "sessionId", description = "sessionId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "sessionId", required = true) UUID sessionId,
        @Parameter(name = "needDos2Unix", description = "needDos2Unix", in = ParameterIn.QUERY) @Valid @RequestParam(value = "needDos2Unix", required = false) Boolean needDos2Unix,
        @Parameter(name = "file", description = "file") @RequestPart(value = "file", required = false) MultipartFile file
    );


    /**
     * POST /rest/uploadTestDataFile
     * handleTestDataFileUpload
     *
     * @param projectId projectId (required)
     * @param sessionId sessionId (optional)
     * @param file file (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "handleTestDataFileUpload",
        description = "handleTestDataFileUpload",
        tags = { "mia-file-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/rest/uploadTestDataFile",
        produces = { "application/json" },
        consumes = { "multipart/form-data" }
    )
    ResponseEntity<String> handleTestDataFileUpload(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @Parameter(name = "sessionId", description = "sessionId", in = ParameterIn.QUERY) @Valid @RequestParam(value = "sessionId", required = false) UUID sessionId,
        @Parameter(name = "file", description = "file") @RequestPart(value = "file", required = false) MultipartFile file
    );

}
