package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.AbstractCompareEntityDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompoundHistoryChangeDto
 */


@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:45.125022847Z[Etc/UTC]")
public class CompoundHistoryChangeDto extends AbstractCompareEntityDto {

  private UUID id;

  private String name;

  private String referToInput;

  @Valid
  private List<String> processes;

  @Valid
  private List<String> inSections;

  /**
   * Default constructor
   * @deprecated Use {@link CompoundHistoryChangeDto#CompoundHistoryChangeDto(String)}
   */
  @Deprecated
  public CompoundHistoryChangeDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public CompoundHistoryChangeDto(String name) {
    super();
    this.name = name;
  }

  public CompoundHistoryChangeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public CompoundHistoryChangeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CompoundHistoryChangeDto referToInput(String referToInput) {
    this.referToInput = referToInput;
    return this;
  }

  /**
   * Get referToInput
   * @return referToInput
  */
  
  @Schema(name = "referToInput", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("referToInput")
  public String getReferToInput() {
    return referToInput;
  }

  public void setReferToInput(String referToInput) {
    this.referToInput = referToInput;
  }

  public CompoundHistoryChangeDto processes(List<String> processes) {
    this.processes = processes;
    return this;
  }

  public CompoundHistoryChangeDto addProcessesItem(String processesItem) {
    if (this.processes == null) {
      this.processes = new ArrayList<>();
    }
    this.processes.add(processesItem);
    return this;
  }

  /**
   * Get processes
   * @return processes
  */
  
  @Schema(name = "processes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processes")
  public List<String> getProcesses() {
    return processes;
  }

  public void setProcesses(List<String> processes) {
    this.processes = processes;
  }

  public CompoundHistoryChangeDto inSections(List<String> inSections) {
    this.inSections = inSections;
    return this;
  }

  public CompoundHistoryChangeDto addInSectionsItem(String inSectionsItem) {
    if (this.inSections == null) {
      this.inSections = new ArrayList<>();
    }
    this.inSections.add(inSectionsItem);
    return this;
  }

  /**
   * Get inSections
   * @return inSections
  */
  
  @Schema(name = "inSections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inSections")
  public List<String> getInSections() {
    return inSections;
  }

  public void setInSections(List<String> inSections) {
    this.inSections = inSections;
  }

  public CompoundHistoryChangeDto createdWhen(Long createdWhen) {
    super.setCreatedWhen(createdWhen);
    return this;
  }

  public CompoundHistoryChangeDto modifiedWhen(Long modifiedWhen) {
    super.setModifiedWhen(modifiedWhen);
    return this;
  }

  public CompoundHistoryChangeDto createdBy(String createdBy) {
    super.setCreatedBy(createdBy);
    return this;
  }

  public CompoundHistoryChangeDto modifiedBy(String modifiedBy) {
    super.setModifiedBy(modifiedBy);
    return this;
  }

  public CompoundHistoryChangeDto entityType(HistoryItemTypeDto entityType) {
    super.setEntityType(entityType);
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompoundHistoryChangeDto compoundHistoryChange = (CompoundHistoryChangeDto) o;
    return Objects.equals(this.id, compoundHistoryChange.id) &&
        Objects.equals(this.name, compoundHistoryChange.name) &&
        Objects.equals(this.referToInput, compoundHistoryChange.referToInput) &&
        Objects.equals(this.processes, compoundHistoryChange.processes) &&
        Objects.equals(this.inSections, compoundHistoryChange.inSections) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, referToInput, processes, inSections, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompoundHistoryChangeDto {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    referToInput: ").append(toIndentedString(referToInput)).append("\n");
    sb.append("    processes: ").append(toIndentedString(processes)).append("\n");
    sb.append("    inSections: ").append(toIndentedString(inSections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

