package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.FlowDataDto;
import org.qubership.atp.mia.controllers.api.dto.RestDto;
import org.qubership.atp.mia.controllers.api.dto.SwitcherDto;
import org.qubership.atp.mia.controllers.api.dto.TestDataFileDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExecutionRequestDto
 */

@JsonTypeName("ExecutionRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:44.361936661Z[Etc/UTC]")
public class ExecutionRequestDto {

  private String process;

  private CompoundDto compound;

  private String command;

  private String type;

  private FlowDataDto flowData;

  private TestDataFileDto testDataFile;

  private UUID sessionId;

  @Valid
  private List<@Valid SwitcherDto> switchers;

  @Valid
  private List<@Valid SwitcherDto> systemSwitchers;

  private RestDto rest;

  public ExecutionRequestDto process(String process) {
    this.process = process;
    return this;
  }

  /**
   * Get process
   * @return process
  */
  
  @Schema(name = "process", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("process")
  public String getProcess() {
    return process;
  }

  public void setProcess(String process) {
    this.process = process;
  }

  public ExecutionRequestDto compound(CompoundDto compound) {
    this.compound = compound;
    return this;
  }

  /**
   * Get compound
   * @return compound
  */
  @Valid 
  @Schema(name = "compound", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("compound")
  public CompoundDto getCompound() {
    return compound;
  }

  public void setCompound(CompoundDto compound) {
    this.compound = compound;
  }

  public ExecutionRequestDto command(String command) {
    this.command = command;
    return this;
  }

  /**
   * Get command
   * @return command
  */
  
  @Schema(name = "command", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("command")
  public String getCommand() {
    return command;
  }

  public void setCommand(String command) {
    this.command = command;
  }

  public ExecutionRequestDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ExecutionRequestDto flowData(FlowDataDto flowData) {
    this.flowData = flowData;
    return this;
  }

  /**
   * Get flowData
   * @return flowData
  */
  @Valid 
  @Schema(name = "flowData", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowData")
  public FlowDataDto getFlowData() {
    return flowData;
  }

  public void setFlowData(FlowDataDto flowData) {
    this.flowData = flowData;
  }

  public ExecutionRequestDto testDataFile(TestDataFileDto testDataFile) {
    this.testDataFile = testDataFile;
    return this;
  }

  /**
   * Get testDataFile
   * @return testDataFile
  */
  @Valid 
  @Schema(name = "testDataFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("testDataFile")
  public TestDataFileDto getTestDataFile() {
    return testDataFile;
  }

  public void setTestDataFile(TestDataFileDto testDataFile) {
    this.testDataFile = testDataFile;
  }

  public ExecutionRequestDto sessionId(UUID sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  /**
   * Get sessionId
   * @return sessionId
  */
  @Valid 
  @Schema(name = "sessionId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sessionId")
  public UUID getSessionId() {
    return sessionId;
  }

  public void setSessionId(UUID sessionId) {
    this.sessionId = sessionId;
  }

  public ExecutionRequestDto switchers(List<@Valid SwitcherDto> switchers) {
    this.switchers = switchers;
    return this;
  }

  public ExecutionRequestDto addSwitchersItem(SwitcherDto switchersItem) {
    if (this.switchers == null) {
      this.switchers = new ArrayList<>();
    }
    this.switchers.add(switchersItem);
    return this;
  }

  /**
   * Get switchers
   * @return switchers
  */
  @Valid 
  @Schema(name = "switchers", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("switchers")
  public List<@Valid SwitcherDto> getSwitchers() {
    return switchers;
  }

  public void setSwitchers(List<@Valid SwitcherDto> switchers) {
    this.switchers = switchers;
  }

  public ExecutionRequestDto systemSwitchers(List<@Valid SwitcherDto> systemSwitchers) {
    this.systemSwitchers = systemSwitchers;
    return this;
  }

  public ExecutionRequestDto addSystemSwitchersItem(SwitcherDto systemSwitchersItem) {
    if (this.systemSwitchers == null) {
      this.systemSwitchers = new ArrayList<>();
    }
    this.systemSwitchers.add(systemSwitchersItem);
    return this;
  }

  /**
   * Get systemSwitchers
   * @return systemSwitchers
  */
  @Valid 
  @Schema(name = "systemSwitchers", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("systemSwitchers")
  public List<@Valid SwitcherDto> getSystemSwitchers() {
    return systemSwitchers;
  }

  public void setSystemSwitchers(List<@Valid SwitcherDto> systemSwitchers) {
    this.systemSwitchers = systemSwitchers;
  }

  public ExecutionRequestDto rest(RestDto rest) {
    this.rest = rest;
    return this;
  }

  /**
   * Get rest
   * @return rest
  */
  @Valid 
  @Schema(name = "rest", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("rest")
  public RestDto getRest() {
    return rest;
  }

  public void setRest(RestDto rest) {
    this.rest = rest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionRequestDto executionRequest = (ExecutionRequestDto) o;
    return Objects.equals(this.process, executionRequest.process) &&
        Objects.equals(this.compound, executionRequest.compound) &&
        Objects.equals(this.command, executionRequest.command) &&
        Objects.equals(this.type, executionRequest.type) &&
        Objects.equals(this.flowData, executionRequest.flowData) &&
        Objects.equals(this.testDataFile, executionRequest.testDataFile) &&
        Objects.equals(this.sessionId, executionRequest.sessionId) &&
        Objects.equals(this.switchers, executionRequest.switchers) &&
        Objects.equals(this.systemSwitchers, executionRequest.systemSwitchers) &&
        Objects.equals(this.rest, executionRequest.rest);
  }

  @Override
  public int hashCode() {
    return Objects.hash(process, compound, command, type, flowData, testDataFile, sessionId, switchers, systemSwitchers, rest);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionRequestDto {\n");
    sb.append("    process: ").append(toIndentedString(process)).append("\n");
    sb.append("    compound: ").append(toIndentedString(compound)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    flowData: ").append(toIndentedString(flowData)).append("\n");
    sb.append("    testDataFile: ").append(toIndentedString(testDataFile)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    switchers: ").append(toIndentedString(switchers)).append("\n");
    sb.append("    systemSwitchers: ").append(toIndentedString(systemSwitchers)).append("\n");
    sb.append("    rest: ").append(toIndentedString(rest)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

