package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemDto;
import org.qubership.atp.mia.controllers.api.dto.PageInfoDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * HistoryItemResponseDto
 */

@JsonTypeName("HistoryItemResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:45.125022847Z[Etc/UTC]")
public class HistoryItemResponseDto {

  private PageInfoDto pageInfo;

  @Valid
  private List<@Valid HistoryItemDto> historyItems;

  public HistoryItemResponseDto pageInfo(PageInfoDto pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Get pageInfo
   * @return pageInfo
  */
  @Valid 
  @Schema(name = "pageInfo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageInfo")
  public PageInfoDto getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfoDto pageInfo) {
    this.pageInfo = pageInfo;
  }

  public HistoryItemResponseDto historyItems(List<@Valid HistoryItemDto> historyItems) {
    this.historyItems = historyItems;
    return this;
  }

  public HistoryItemResponseDto addHistoryItemsItem(HistoryItemDto historyItemsItem) {
    if (this.historyItems == null) {
      this.historyItems = new ArrayList<>();
    }
    this.historyItems.add(historyItemsItem);
    return this;
  }

  /**
   * Get historyItems
   * @return historyItems
  */
  @Valid 
  @Schema(name = "historyItems", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("historyItems")
  public List<@Valid HistoryItemDto> getHistoryItems() {
    return historyItems;
  }

  public void setHistoryItems(List<@Valid HistoryItemDto> historyItems) {
    this.historyItems = historyItems;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryItemResponseDto historyItemResponse = (HistoryItemResponseDto) o;
    return Objects.equals(this.pageInfo, historyItemResponse.pageInfo) &&
        Objects.equals(this.historyItems, historyItemResponse.historyItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageInfo, historyItems);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryItemResponseDto {\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    historyItems: ").append(toIndentedString(historyItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

