package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.ProcessSettingsDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProcessDto
 */

@JsonTypeName("Process")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:44.361936661Z[Etc/UTC]")
public class ProcessDto {

  private UUID id;

  private String name;

  private ProcessSettingsDto processSettings;

  @Valid
  private List<UUID> inSections;

  @Valid
  private List<UUID> inCompounds;

  /**
   * Default constructor
   * @deprecated Use {@link ProcessDto#ProcessDto(String)}
   */
  @Deprecated
  public ProcessDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ProcessDto(String name) {
    this.name = name;
  }

  public ProcessDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ProcessDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProcessDto processSettings(ProcessSettingsDto processSettings) {
    this.processSettings = processSettings;
    return this;
  }

  /**
   * Get processSettings
   * @return processSettings
  */
  @Valid 
  @Schema(name = "processSettings", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processSettings")
  public ProcessSettingsDto getProcessSettings() {
    return processSettings;
  }

  public void setProcessSettings(ProcessSettingsDto processSettings) {
    this.processSettings = processSettings;
  }

  public ProcessDto inSections(List<UUID> inSections) {
    this.inSections = inSections;
    return this;
  }

  public ProcessDto addInSectionsItem(UUID inSectionsItem) {
    if (this.inSections == null) {
      this.inSections = new ArrayList<>();
    }
    this.inSections.add(inSectionsItem);
    return this;
  }

  /**
   * Get inSections
   * @return inSections
  */
  @Valid 
  @Schema(name = "inSections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inSections")
  public List<UUID> getInSections() {
    return inSections;
  }

  public void setInSections(List<UUID> inSections) {
    this.inSections = inSections;
  }

  public ProcessDto inCompounds(List<UUID> inCompounds) {
    this.inCompounds = inCompounds;
    return this;
  }

  public ProcessDto addInCompoundsItem(UUID inCompoundsItem) {
    if (this.inCompounds == null) {
      this.inCompounds = new ArrayList<>();
    }
    this.inCompounds.add(inCompoundsItem);
    return this;
  }

  /**
   * Get inCompounds
   * @return inCompounds
  */
  @Valid 
  @Schema(name = "inCompounds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inCompounds")
  public List<UUID> getInCompounds() {
    return inCompounds;
  }

  public void setInCompounds(List<UUID> inCompounds) {
    this.inCompounds = inCompounds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessDto process = (ProcessDto) o;
    return Objects.equals(this.id, process.id) &&
        Objects.equals(this.name, process.name) &&
        Objects.equals(this.processSettings, process.processSettings) &&
        Objects.equals(this.inSections, process.inSections) &&
        Objects.equals(this.inCompounds, process.inCompounds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, processSettings, inSections, inCompounds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    processSettings: ").append(toIndentedString(processSettings)).append("\n");
    sb.append("    inSections: ").append(toIndentedString(inSections)).append("\n");
    sb.append("    inCompounds: ").append(toIndentedString(inCompounds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

