package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.CommandDto;
import org.qubership.atp.mia.controllers.api.dto.InputDto;
import org.qubership.atp.mia.controllers.api.dto.PrerequisiteDto;
import org.qubership.atp.mia.controllers.api.dto.ValidationDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProcessSettingsDto
 */

@JsonTypeName("ProcessSettings")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:45.125022847Z[Etc/UTC]")
public class ProcessSettingsDto {

  @Valid
  private List<@Valid PrerequisiteDto> prerequisites;

  private CommandDto command;

  @Valid
  private List<@Valid ValidationDto> validations;

  @Valid
  private Map<String, String> globalVariables = new HashMap<>();

  private String name;

  @Valid
  private List<@Valid InputDto> inputs;

  @Valid
  private List<@Valid ValidationDto> currentStatement;

  private String referToInput;

  public ProcessSettingsDto prerequisites(List<@Valid PrerequisiteDto> prerequisites) {
    this.prerequisites = prerequisites;
    return this;
  }

  public ProcessSettingsDto addPrerequisitesItem(PrerequisiteDto prerequisitesItem) {
    if (this.prerequisites == null) {
      this.prerequisites = new ArrayList<>();
    }
    this.prerequisites.add(prerequisitesItem);
    return this;
  }

  /**
   * Get prerequisites
   * @return prerequisites
  */
  @Valid 
  @Schema(name = "prerequisites", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("prerequisites")
  public List<@Valid PrerequisiteDto> getPrerequisites() {
    return prerequisites;
  }

  public void setPrerequisites(List<@Valid PrerequisiteDto> prerequisites) {
    this.prerequisites = prerequisites;
  }

  public ProcessSettingsDto command(CommandDto command) {
    this.command = command;
    return this;
  }

  /**
   * Get command
   * @return command
  */
  @Valid 
  @Schema(name = "command", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("command")
  public CommandDto getCommand() {
    return command;
  }

  public void setCommand(CommandDto command) {
    this.command = command;
  }

  public ProcessSettingsDto validations(List<@Valid ValidationDto> validations) {
    this.validations = validations;
    return this;
  }

  public ProcessSettingsDto addValidationsItem(ValidationDto validationsItem) {
    if (this.validations == null) {
      this.validations = new ArrayList<>();
    }
    this.validations.add(validationsItem);
    return this;
  }

  /**
   * Get validations
   * @return validations
  */
  @Valid 
  @Schema(name = "validations", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validations")
  public List<@Valid ValidationDto> getValidations() {
    return validations;
  }

  public void setValidations(List<@Valid ValidationDto> validations) {
    this.validations = validations;
  }

  public ProcessSettingsDto globalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
    return this;
  }

  public ProcessSettingsDto putGlobalVariablesItem(String key, String globalVariablesItem) {
    if (this.globalVariables == null) {
      this.globalVariables = new HashMap<>();
    }
    this.globalVariables.put(key, globalVariablesItem);
    return this;
  }

  /**
   * Get globalVariables
   * @return globalVariables
  */
  
  @Schema(name = "globalVariables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("globalVariables")
  public Map<String, String> getGlobalVariables() {
    return globalVariables;
  }

  public void setGlobalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
  }

  public ProcessSettingsDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProcessSettingsDto inputs(List<@Valid InputDto> inputs) {
    this.inputs = inputs;
    return this;
  }

  public ProcessSettingsDto addInputsItem(InputDto inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

  /**
   * Get inputs
   * @return inputs
  */
  @Valid 
  @Schema(name = "inputs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputs")
  public List<@Valid InputDto> getInputs() {
    return inputs;
  }

  public void setInputs(List<@Valid InputDto> inputs) {
    this.inputs = inputs;
  }

  public ProcessSettingsDto currentStatement(List<@Valid ValidationDto> currentStatement) {
    this.currentStatement = currentStatement;
    return this;
  }

  public ProcessSettingsDto addCurrentStatementItem(ValidationDto currentStatementItem) {
    if (this.currentStatement == null) {
      this.currentStatement = new ArrayList<>();
    }
    this.currentStatement.add(currentStatementItem);
    return this;
  }

  /**
   * Get currentStatement
   * @return currentStatement
  */
  @Valid 
  @Schema(name = "currentStatement", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("currentStatement")
  public List<@Valid ValidationDto> getCurrentStatement() {
    return currentStatement;
  }

  public void setCurrentStatement(List<@Valid ValidationDto> currentStatement) {
    this.currentStatement = currentStatement;
  }

  public ProcessSettingsDto referToInput(String referToInput) {
    this.referToInput = referToInput;
    return this;
  }

  /**
   * Get referToInput
   * @return referToInput
  */
  
  @Schema(name = "referToInput", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("referToInput")
  public String getReferToInput() {
    return referToInput;
  }

  public void setReferToInput(String referToInput) {
    this.referToInput = referToInput;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessSettingsDto processSettings = (ProcessSettingsDto) o;
    return Objects.equals(this.prerequisites, processSettings.prerequisites) &&
        Objects.equals(this.command, processSettings.command) &&
        Objects.equals(this.validations, processSettings.validations) &&
        Objects.equals(this.globalVariables, processSettings.globalVariables) &&
        Objects.equals(this.name, processSettings.name) &&
        Objects.equals(this.inputs, processSettings.inputs) &&
        Objects.equals(this.currentStatement, processSettings.currentStatement) &&
        Objects.equals(this.referToInput, processSettings.referToInput);
  }

  @Override
  public int hashCode() {
    return Objects.hash(prerequisites, command, validations, globalVariables, name, inputs, currentStatement, referToInput);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessSettingsDto {\n");
    sb.append("    prerequisites: ").append(toIndentedString(prerequisites)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    validations: ").append(toIndentedString(validations)).append("\n");
    sb.append("    globalVariables: ").append(toIndentedString(globalVariables)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    currentStatement: ").append(toIndentedString(currentStatement)).append("\n");
    sb.append("    referToInput: ").append(toIndentedString(referToInput)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

