package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.CommonConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.HeaderConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.PotHeaderConfigurationDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectConfigurationDto
 */

@JsonTypeName("ProjectConfiguration")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:43.499729142Z[Etc/UTC]")
public class ProjectConfigurationDto {

  private UUID projectId;

  private String gitUrl;

  private String validationResult;

  private CommonConfigurationDto commonConfiguration;

  private HeaderConfigurationDto headerConfiguration;

  private PotHeaderConfigurationDto potHeaderConfiguration;

  public ProjectConfigurationDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("projectId")
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public ProjectConfigurationDto gitUrl(String gitUrl) {
    this.gitUrl = gitUrl;
    return this;
  }

  /**
   * Get gitUrl
   * @return gitUrl
  */
  
  @Schema(name = "gitUrl", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("gitUrl")
  public String getGitUrl() {
    return gitUrl;
  }

  public void setGitUrl(String gitUrl) {
    this.gitUrl = gitUrl;
  }

  public ProjectConfigurationDto validationResult(String validationResult) {
    this.validationResult = validationResult;
    return this;
  }

  /**
   * Get validationResult
   * @return validationResult
  */
  
  @Schema(name = "validationResult", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validationResult")
  public String getValidationResult() {
    return validationResult;
  }

  public void setValidationResult(String validationResult) {
    this.validationResult = validationResult;
  }

  public ProjectConfigurationDto commonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
    return this;
  }

  /**
   * Get commonConfiguration
   * @return commonConfiguration
  */
  @Valid 
  @Schema(name = "commonConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commonConfiguration")
  public CommonConfigurationDto getCommonConfiguration() {
    return commonConfiguration;
  }

  public void setCommonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
  }

  public ProjectConfigurationDto headerConfiguration(HeaderConfigurationDto headerConfiguration) {
    this.headerConfiguration = headerConfiguration;
    return this;
  }

  /**
   * Get headerConfiguration
   * @return headerConfiguration
  */
  @Valid 
  @Schema(name = "headerConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("headerConfiguration")
  public HeaderConfigurationDto getHeaderConfiguration() {
    return headerConfiguration;
  }

  public void setHeaderConfiguration(HeaderConfigurationDto headerConfiguration) {
    this.headerConfiguration = headerConfiguration;
  }

  public ProjectConfigurationDto potHeaderConfiguration(PotHeaderConfigurationDto potHeaderConfiguration) {
    this.potHeaderConfiguration = potHeaderConfiguration;
    return this;
  }

  /**
   * Get potHeaderConfiguration
   * @return potHeaderConfiguration
  */
  @Valid 
  @Schema(name = "potHeaderConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("potHeaderConfiguration")
  public PotHeaderConfigurationDto getPotHeaderConfiguration() {
    return potHeaderConfiguration;
  }

  public void setPotHeaderConfiguration(PotHeaderConfigurationDto potHeaderConfiguration) {
    this.potHeaderConfiguration = potHeaderConfiguration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectConfigurationDto projectConfiguration = (ProjectConfigurationDto) o;
    return Objects.equals(this.projectId, projectConfiguration.projectId) &&
        Objects.equals(this.gitUrl, projectConfiguration.gitUrl) &&
        Objects.equals(this.validationResult, projectConfiguration.validationResult) &&
        Objects.equals(this.commonConfiguration, projectConfiguration.commonConfiguration) &&
        Objects.equals(this.headerConfiguration, projectConfiguration.headerConfiguration) &&
        Objects.equals(this.potHeaderConfiguration, projectConfiguration.potHeaderConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, gitUrl, validationResult, commonConfiguration, headerConfiguration, potHeaderConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectConfigurationDto {\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    gitUrl: ").append(toIndentedString(gitUrl)).append("\n");
    sb.append("    validationResult: ").append(toIndentedString(validationResult)).append("\n");
    sb.append("    commonConfiguration: ").append(toIndentedString(commonConfiguration)).append("\n");
    sb.append("    headerConfiguration: ").append(toIndentedString(headerConfiguration)).append("\n");
    sb.append("    potHeaderConfiguration: ").append(toIndentedString(potHeaderConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

