package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.ProjectFileDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectDirectoriesDto
 */

@JsonTypeName("ProjectDirectories")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:43.499729142Z[Etc/UTC]")
public class ProjectDirectoriesDto {

  private UUID id;

  private String name;

  @Valid
  private List<@Valid ProjectDirectoriesDto> directories;

  @Valid
  private List<@Valid ProjectFileDto> files;

  /**
   * Default constructor
   * @deprecated Use {@link ProjectDirectoriesDto#ProjectDirectoriesDto(String)}
   */
  @Deprecated
  public ProjectDirectoriesDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ProjectDirectoriesDto(String name) {
    this.name = name;
  }

  public ProjectDirectoriesDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ProjectDirectoriesDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProjectDirectoriesDto directories(List<@Valid ProjectDirectoriesDto> directories) {
    this.directories = directories;
    return this;
  }

  public ProjectDirectoriesDto addDirectoriesItem(ProjectDirectoriesDto directoriesItem) {
    if (this.directories == null) {
      this.directories = new ArrayList<>();
    }
    this.directories.add(directoriesItem);
    return this;
  }

  /**
   * Get directories
   * @return directories
  */
  @Valid 
  @Schema(name = "directories", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("directories")
  public List<@Valid ProjectDirectoriesDto> getDirectories() {
    return directories;
  }

  public void setDirectories(List<@Valid ProjectDirectoriesDto> directories) {
    this.directories = directories;
  }

  public ProjectDirectoriesDto files(List<@Valid ProjectFileDto> files) {
    this.files = files;
    return this;
  }

  public ProjectDirectoriesDto addFilesItem(ProjectFileDto filesItem) {
    if (this.files == null) {
      this.files = new ArrayList<>();
    }
    this.files.add(filesItem);
    return this;
  }

  /**
   * Get files
   * @return files
  */
  @Valid 
  @Schema(name = "files", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("files")
  public List<@Valid ProjectFileDto> getFiles() {
    return files;
  }

  public void setFiles(List<@Valid ProjectFileDto> files) {
    this.files = files;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectDirectoriesDto projectDirectories = (ProjectDirectoriesDto) o;
    return Objects.equals(this.id, projectDirectories.id) &&
        Objects.equals(this.name, projectDirectories.name) &&
        Objects.equals(this.directories, projectDirectories.directories) &&
        Objects.equals(this.files, projectDirectories.files);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, directories, files);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectDirectoriesDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    directories: ").append(toIndentedString(directories)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

