package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.DBTypesDto;
import org.qubership.atp.mia.controllers.api.dto.ValidateValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * QueryDto
 */

@JsonTypeName("Query")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:44.361936661Z[Etc/UTC]")
public class QueryDto {

  private String query;

  private DBTypesDto type;

  @Valid
  private List<@Valid ValidateValueDto> validateValue;

  public QueryDto query(String query) {
    this.query = query;
    return this;
  }

  /**
   * Get query
   * @return query
  */
  
  @Schema(name = "query", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("query")
  public String getQuery() {
    return query;
  }

  public void setQuery(String query) {
    this.query = query;
  }

  public QueryDto type(DBTypesDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public DBTypesDto getType() {
    return type;
  }

  public void setType(DBTypesDto type) {
    this.type = type;
  }

  public QueryDto validateValue(List<@Valid ValidateValueDto> validateValue) {
    this.validateValue = validateValue;
    return this;
  }

  public QueryDto addValidateValueItem(ValidateValueDto validateValueItem) {
    if (this.validateValue == null) {
      this.validateValue = new ArrayList<>();
    }
    this.validateValue.add(validateValueItem);
    return this;
  }

  /**
   * Get validateValue
   * @return validateValue
  */
  @Valid 
  @Schema(name = "validateValue", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validateValue")
  public List<@Valid ValidateValueDto> getValidateValue() {
    return validateValue;
  }

  public void setValidateValue(List<@Valid ValidateValueDto> validateValue) {
    this.validateValue = validateValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryDto query = (QueryDto) o;
    return Objects.equals(this.query, query.query) &&
        Objects.equals(this.type, query.type) &&
        Objects.equals(this.validateValue, query.validateValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, type, validateValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryDto {\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validateValue: ").append(toIndentedString(validateValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

