package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.DescriptionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ScenarioDto
 */

@JsonTypeName("Scenario")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T08:58:44.361936661Z[Etc/UTC]")
public class ScenarioDto {

  private String name;

  @Valid
  private List<@Valid DescriptionDto> descriptions;

  public ScenarioDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ScenarioDto descriptions(List<@Valid DescriptionDto> descriptions) {
    this.descriptions = descriptions;
    return this;
  }

  public ScenarioDto addDescriptionsItem(DescriptionDto descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

  /**
   * Get descriptions
   * @return descriptions
  */
  @Valid 
  @Schema(name = "descriptions", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("descriptions")
  public List<@Valid DescriptionDto> getDescriptions() {
    return descriptions;
  }

  public void setDescriptions(List<@Valid DescriptionDto> descriptions) {
    this.descriptions = descriptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScenarioDto scenario = (ScenarioDto) o;
    return Objects.equals(this.name, scenario.name) &&
        Objects.equals(this.descriptions, scenario.descriptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, descriptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScenarioDto {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

