/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.config;

import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.repo.ContextRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ContextInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ContextInterceptor.class);
    private final MiaContext miaContext;
    private final ContextRepository contextRepository;
    private final MetricsAggregateService metricsService;

    @After(value="execution(* org.qubership.atp.mia.controllers..*Controller.*(..))")
    public void afterController(JoinPoint joinPoint) {
        log.debug("Remove ThreadLocal in afterCompletion");
        this.contextRepository.removeContext();
    }

    @AfterThrowing(value="execution(* org.qubership.atp.mia.controllers..*Controller.*(..))", throwing="exception")
    public void afterExceptionInController(JoinPoint joinPoint, Exception exception) {
        log.debug("Remove ThreadLocal in afterException");
        this.contextRepository.removeContext();
    }

    @Before(value="execution(* org.qubership.atp.mia.controllers.MiaConfigurationController.*(..))|| execution(* org.qubership.atp.mia.controllers.MiaCacheController.*(..))|| execution(* org.qubership.atp.mia.controllers.MiaServiceController.*(..))")
    public void beforeController(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length <= 0) {
            throw new IllegalArgumentException("No projectId found as parameter");
        }
        String projectId = joinPoint.getArgs()[0].toString();
        log.debug("Set mia context with project ID '{}'", (Object)projectId);
        this.miaContext.setContext(UUID.fromString(projectId), null);
    }

    @Before(value="execution(* org.qubership.atp.mia.controllers.MiaFileController.*(..))")
    public void beforeFileController(JoinPoint joinPoint) {
        UUID sessionId;
        String projectId;
        if (joinPoint.getArgs().length > 1) {
            projectId = joinPoint.getArgs()[0].toString();
            try {
                sessionId = UUID.fromString(joinPoint.getArgs()[1].toString());
            }
            catch (Exception e) {
                sessionId = UUID.randomUUID();
            }
        } else {
            throw new IllegalArgumentException("No projectId or sessionId found as parameter");
        }
        log.debug("Set mia context with project ID '{}' and sessionID '{}'", (Object)projectId, (Object)sessionId);
        this.miaContext.setContext(UUID.fromString(projectId), sessionId);
    }

    @Before(value="execution(* org.qubership.atp.mia.controllers.MiaExecutionController.*(..))")
    public void beforeMiaExecutionController(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length > 2) {
            UUID projectId = (UUID)joinPoint.getArgs()[0];
            String env = joinPoint.getArgs()[1].toString();
            ExecutionRequest executionRequest = (ExecutionRequest)joinPoint.getArgs()[2];
            log.debug("Set mia context with project ID '{}'", (Object)projectId);
            this.miaContext.setContext(executionRequest, projectId, env);
            if (executionRequest.getFlowData() != null && executionRequest.getFlowData().getParameters() != null) {
                this.metricsService.requestContextSize(executionRequest.getFlowData().getParameters().size());
            }
        } else {
            throw new IllegalArgumentException("No projectId found as parameter");
        }
    }

    @Before(value="execution(* org.qubership.atp.mia.controllers.MiaProofOfTestingController.*(..))")
    public void beforeMiaProofOfTestingController(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length >= 2) {
            UUID projectId = (UUID)joinPoint.getArgs()[0];
            UUID sessionId = (UUID)joinPoint.getArgs()[1];
            log.debug("Set mia context with project ID #{} and session ID {}", (Object)projectId, (Object)sessionId);
            this.miaContext.setContext(projectId, sessionId);
            if (joinPoint.getArgs().length > 2) {
                this.miaContext.setFlowDataFromRequest((ExecutionRequest)joinPoint.getArgs()[2]);
            }
        } else {
            throw new IllegalArgumentException("No projectId or sessionId found as parameter");
        }
    }

    public ContextInterceptor(MiaContext miaContext, ContextRepository contextRepository, MetricsAggregateService metricsService) {
        this.miaContext = miaContext;
        this.contextRepository = contextRepository;
        this.metricsService = metricsService;
    }
}

