/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.config;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.modelmapper.AbstractConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.qubership.atp.mia.kafka.producers.MiaExecutionFinishProducer;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MiaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MiaConfiguration.class);
    @Value(value="${configPath:prod}")
    private String profile;
    @Value(value="${atp.service.internal:false}")
    private boolean isInternalGateWayEnabled;
    @Value(value="${catalogue.url}")
    private String catalogueUrl;
    @Value(value="${atp.service.path:/api/atp-mia/v1}")
    private String servicePath;

    @Bean(value={"miaConfigPath"})
    public Path miaConfigPath() {
        if ("test".equals(this.profile)) {
            return Paths.get("src", "main", "config");
        }
        return Paths.get("config", new String[0]);
    }

    @ConditionalOnProperty(value={"kafka.enable"}, havingValue="false")
    @Bean
    public MiaExecutionFinishProducer miaExecutionFinishProducer() {
        return new MiaExecutionFinishProducer(null);
    }

    @Bean
    public ExecutorService executorServiceForSql(@Value(value="${mia.sql.threadPool.minThreads:#{50}}") int minThreads, @Value(value="${mia.sql.threadPool.maxThreads:#{100}}") int maxThreads, @Value(value="${mia.sql.threadPool.aliveTimeMs:#{0L}}") long aliveTime) {
        return new ThreadPoolExecutor(minThreads, maxThreads, aliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Bean(value={"fileDownloadPrefix"})
    public String fileDownloadPrefix() {
        String internalGatewayFileDownloadPathPrefix = "";
        if (this.isInternalGateWayEnabled) {
            if (this.catalogueUrl != null && this.catalogueUrl.length() > 0) {
                if (this.servicePath != null && this.servicePath.length() > 0) {
                    if (this.servicePath.endsWith("/**")) {
                        this.servicePath = this.servicePath.substring(0, this.servicePath.length() - 3);
                    }
                } else {
                    log.warn("Service Path is empty & setting to default value");
                    this.servicePath = "/api/atp-mia/v1";
                }
                log.debug("InternalGateway is Enabled & setting the file download URL prefix");
                try {
                    internalGatewayFileDownloadPathPrefix = new URI(this.catalogueUrl + "/redirect-uri/" + this.servicePath).normalize().toString();
                }
                catch (URISyntaxException e) {
                    log.error("Problem in download file URL Prefix Formation. {}", (Object)e.getMessage());
                }
                log.info("File download URL Prefix set to {}", (Object)internalGatewayFileDownloadPathPrefix);
            } else {
                log.error("invalid catalog URL. Please set environment variable FEIGN_ATP_CATALOGUE_URL");
                log.warn("File download URL Prefix set to empty");
            }
        } else {
            log.info("InternalGateway is not enabled. File download URL prefix did not set and not required");
        }
        return internalGatewayFileDownloadPathPrefix;
    }

    @Bean(value={"miaEntityUrlFormat"})
    public String miaEntityUrlFormat() {
        String entityUrlPrefix = Strings.isNullOrEmpty((String)this.catalogueUrl) ? "" : this.catalogueUrl;
        return entityUrlPrefix + "/project/%s/mia/execution?entityId=%s";
    }

    @Bean(value={"miaPotTemplate"})
    public String miaPotTemplate() {
        if ("test".equals(this.profile)) {
            return ".." + File.separator + "atp-mia-distribution" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "POT_template.docx";
        }
        return "config" + File.separator + "POT_template.docx";
    }

    @Bean
    public ModelMapper modelMapper() {
        ModelMapper modelMapper = new ModelMapper();
        AbstractConverter<SectionConfiguration, UUID> sectionConfigurationUuidConverter = new AbstractConverter<SectionConfiguration, UUID>(){

            protected UUID convert(SectionConfiguration source) {
                if (source != null) {
                    return source.getId();
                }
                return null;
            }
        };
        AbstractConverter<ProcessConfiguration, UUID> processConfigurationUuidConverter = new AbstractConverter<ProcessConfiguration, UUID>(){

            protected UUID convert(ProcessConfiguration source) {
                if (source != null) {
                    return source.getId();
                }
                return null;
            }
        };
        AbstractConverter<CompoundConfiguration, UUID> compoundConfigurationUuidConverter = new AbstractConverter<CompoundConfiguration, UUID>(){

            protected UUID convert(CompoundConfiguration source) {
                if (source != null) {
                    return source.getId();
                }
                return null;
            }
        };
        AbstractConverter<ProjectDirectory, UUID> projectDirectoryUuidConverter = new AbstractConverter<ProjectDirectory, UUID>(){

            protected UUID convert(ProjectDirectory source) {
                if (source != null) {
                    return source.getId();
                }
                return null;
            }
        };
        modelMapper.addConverter((Converter)sectionConfigurationUuidConverter);
        modelMapper.addConverter((Converter)processConfigurationUuidConverter);
        modelMapper.addConverter((Converter)compoundConfigurationUuidConverter);
        modelMapper.addConverter((Converter)projectDirectoryUuidConverter);
        modelMapper.getConfiguration().setSkipNullEnabled(true);
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        return modelMapper;
    }
}

