/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.controllers.api.MiaServiceControllerApi;
import org.qubership.atp.mia.service.execution.TimeShiftService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MiaServiceController
implements MiaServiceControllerApi {
    private final GridFsService gridFsService;
    private final TimeShiftService timeShiftService;

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'READ')")
    @AuditAction(auditAction="Get dbSize called from project {{#projectId}}")
    public ResponseEntity<String> dbSize(UUID projectId) {
        return ResponseEntity.ok((Object)this.gridFsService.getCollectionsSize());
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'READ')")
    @AuditAction(auditAction="Time shifting check in Project : {{#projectId}}")
    public ResponseEntity<Boolean> getTimeShifting(UUID projectId, String systemId) {
        return ResponseEntity.ok((Object)this.timeShiftService.checkTimeShifting(systemId));
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Update TimeShifting value (Enable/Disable), in Project : {{#projectId}}")
    public ResponseEntity<Boolean> updateTimeShifting(UUID projectId, UUID systemId, Boolean value) {
        this.timeShiftService.updateTimeShifting(systemId, value);
        return ResponseEntity.ok((Object)true);
    }

    public MiaServiceController(GridFsService gridFsService, TimeShiftService timeShiftService) {
        this.gridFsService = gridFsService;
        this.timeShiftService = timeShiftService;
    }
}

