/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.project.AbstractConfiguratorModelDto;
import org.qubership.atp.mia.controllers.api.dto.project.EnvironmentDto;
import org.qubership.atp.mia.controllers.api.dto.project.ProjectDto;
import org.qubership.atp.mia.controllers.api.dto.project.SystemEnvironmentsViewDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="project-controller", description="Project Controller")
public interface ProjectControllerApi {
    @Operation(operationId="getEnvironments", summary="getEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AbstractConfiguratorModelDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/environments"}, produces={"application/json"})
    public ResponseEntity<List<AbstractConfiguratorModelDto>> getEnvironments(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) String var1);

    @Operation(operationId="getEnvironmentsFull", summary="getEnvironmentsFull", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/environments/full"}, produces={"application/json"})
    public ResponseEntity<EnvironmentDto> getEnvironmentsFull(@NotNull @Parameter(name="environmentId", description="environmentId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="environmentId", required=true) String var1, @NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) String var2);

    @Operation(operationId="getProject", summary="getProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/project"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProject(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) String var1);

    @Operation(operationId="getProjects", summary="getProjects", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AbstractConfiguratorModelDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/projects"}, produces={"application/json"})
    public ResponseEntity<List<AbstractConfiguratorModelDto>> getProjects();

    @Operation(operationId="getSystemsForProject", summary="getSystemsForProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemEnvironmentsViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/environments/systems"}, produces={"application/json"})
    public ResponseEntity<SystemEnvironmentsViewDto> getSystemsForProject(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) String var1);
}

