/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.qubership.atp.mia.controllers.api.dto.CommandOutputDto;
import org.qubership.atp.mia.controllers.api.dto.CommandTypesEnumDto;
import org.qubership.atp.mia.controllers.api.dto.ExceptionDto;
import org.qubership.atp.mia.controllers.api.dto.HtmlPageDto;
import org.qubership.atp.mia.controllers.api.dto.SqlResponseDto;

@JsonTypeName(value="CommandResponse")
public class CommandResponseDto {
    private CommandTypesEnumDto type;
    private String command;
    @Valid
    private Map<String, String> connectionInfo = new HashMap<String, String>();
    @Valid
    private @Valid List<@Valid CommandOutputDto> commandOutputs;
    private SqlResponseDto sqlResponse;
    private HtmlPageDto htmlPage;
    @Valid
    private List<String> description;
    @Valid
    private @Valid List<@Valid ExceptionDto> errors;
    private Boolean checkStatusCodeFlag;
    private String statusCode;
    @Valid
    private List<String> expectedCodes;
    private String postScriptExecutionReport;

    public CommandResponseDto type(CommandTypesEnumDto type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public CommandTypesEnumDto getType() {
        return this.type;
    }

    public void setType(CommandTypesEnumDto type) {
        this.type = type;
    }

    public CommandResponseDto command(String command) {
        this.command = command;
        return this;
    }

    @Schema(name="command", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public CommandResponseDto connectionInfo(Map<String, String> connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public CommandResponseDto putConnectionInfoItem(String key, String connectionInfoItem) {
        if (this.connectionInfo == null) {
            this.connectionInfo = new HashMap<String, String>();
        }
        this.connectionInfo.put(key, connectionInfoItem);
        return this;
    }

    @Schema(name="connectionInfo", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="connectionInfo")
    public Map<String, String> getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(Map<String, String> connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public CommandResponseDto commandOutputs(List<@Valid CommandOutputDto> commandOutputs) {
        this.commandOutputs = commandOutputs;
        return this;
    }

    public CommandResponseDto addCommandOutputsItem(CommandOutputDto commandOutputsItem) {
        if (this.commandOutputs == null) {
            this.commandOutputs = new ArrayList<CommandOutputDto>();
        }
        this.commandOutputs.add(commandOutputsItem);
        return this;
    }

    @Valid
    @Schema(name="commandOutputs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="commandOutputs")
    public @Valid List<@Valid CommandOutputDto> getCommandOutputs() {
        return this.commandOutputs;
    }

    public void setCommandOutputs(List<@Valid CommandOutputDto> commandOutputs) {
        this.commandOutputs = commandOutputs;
    }

    public CommandResponseDto sqlResponse(SqlResponseDto sqlResponse) {
        this.sqlResponse = sqlResponse;
        return this;
    }

    @Valid
    @Schema(name="sqlResponse", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sqlResponse")
    public SqlResponseDto getSqlResponse() {
        return this.sqlResponse;
    }

    public void setSqlResponse(SqlResponseDto sqlResponse) {
        this.sqlResponse = sqlResponse;
    }

    public CommandResponseDto htmlPage(HtmlPageDto htmlPage) {
        this.htmlPage = htmlPage;
        return this;
    }

    @Valid
    @Schema(name="htmlPage", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="htmlPage")
    public HtmlPageDto getHtmlPage() {
        return this.htmlPage;
    }

    public void setHtmlPage(HtmlPageDto htmlPage) {
        this.htmlPage = htmlPage;
    }

    public CommandResponseDto description(List<String> description) {
        this.description = description;
        return this;
    }

    public CommandResponseDto addDescriptionItem(String descriptionItem) {
        if (this.description == null) {
            this.description = new ArrayList<String>();
        }
        this.description.add(descriptionItem);
        return this;
    }

    @Schema(name="description", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public CommandResponseDto errors(List<@Valid ExceptionDto> errors) {
        this.errors = errors;
        return this;
    }

    public CommandResponseDto addErrorsItem(ExceptionDto errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ExceptionDto>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Valid
    @Schema(name="errors", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errors")
    public @Valid List<@Valid ExceptionDto> getErrors() {
        return this.errors;
    }

    public void setErrors(List<@Valid ExceptionDto> errors) {
        this.errors = errors;
    }

    public CommandResponseDto checkStatusCodeFlag(Boolean checkStatusCodeFlag) {
        this.checkStatusCodeFlag = checkStatusCodeFlag;
        return this;
    }

    @Schema(name="checkStatusCodeFlag", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="checkStatusCodeFlag")
    public Boolean getCheckStatusCodeFlag() {
        return this.checkStatusCodeFlag;
    }

    public void setCheckStatusCodeFlag(Boolean checkStatusCodeFlag) {
        this.checkStatusCodeFlag = checkStatusCodeFlag;
    }

    public CommandResponseDto statusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Schema(name="statusCode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="statusCode")
    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public CommandResponseDto expectedCodes(List<String> expectedCodes) {
        this.expectedCodes = expectedCodes;
        return this;
    }

    public CommandResponseDto addExpectedCodesItem(String expectedCodesItem) {
        if (this.expectedCodes == null) {
            this.expectedCodes = new ArrayList<String>();
        }
        this.expectedCodes.add(expectedCodesItem);
        return this;
    }

    @Schema(name="expectedCodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="expectedCodes")
    public List<String> getExpectedCodes() {
        return this.expectedCodes;
    }

    public void setExpectedCodes(List<String> expectedCodes) {
        this.expectedCodes = expectedCodes;
    }

    public CommandResponseDto postScriptExecutionReport(String postScriptExecutionReport) {
        this.postScriptExecutionReport = postScriptExecutionReport;
        return this;
    }

    @Schema(name="postScriptExecutionReport", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="postScriptExecutionReport")
    public String getPostScriptExecutionReport() {
        return this.postScriptExecutionReport;
    }

    public void setPostScriptExecutionReport(String postScriptExecutionReport) {
        this.postScriptExecutionReport = postScriptExecutionReport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResponseDto commandResponse = (CommandResponseDto)o;
        return Objects.equals((Object)this.type, (Object)commandResponse.type) && Objects.equals(this.command, commandResponse.command) && Objects.equals(this.connectionInfo, commandResponse.connectionInfo) && Objects.equals(this.commandOutputs, commandResponse.commandOutputs) && Objects.equals(this.sqlResponse, commandResponse.sqlResponse) && Objects.equals(this.htmlPage, commandResponse.htmlPage) && Objects.equals(this.description, commandResponse.description) && Objects.equals(this.errors, commandResponse.errors) && Objects.equals(this.checkStatusCodeFlag, commandResponse.checkStatusCodeFlag) && Objects.equals(this.statusCode, commandResponse.statusCode) && Objects.equals(this.expectedCodes, commandResponse.expectedCodes) && Objects.equals(this.postScriptExecutionReport, commandResponse.postScriptExecutionReport);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.command, this.connectionInfo, this.commandOutputs, this.sqlResponse, this.htmlPage, this.description, this.errors, this.checkStatusCodeFlag, this.statusCode, this.expectedCodes, this.postScriptExecutionReport});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommandResponseDto {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    connectionInfo: ").append(this.toIndentedString(this.connectionInfo)).append("\n");
        sb.append("    commandOutputs: ").append(this.toIndentedString(this.commandOutputs)).append("\n");
        sb.append("    sqlResponse: ").append(this.toIndentedString(this.sqlResponse)).append("\n");
        sb.append("    htmlPage: ").append(this.toIndentedString(this.htmlPage)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    checkStatusCodeFlag: ").append(this.toIndentedString(this.checkStatusCodeFlag)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    expectedCodes: ").append(this.toIndentedString(this.expectedCodes)).append("\n");
        sb.append("    postScriptExecutionReport: ").append(this.toIndentedString(this.postScriptExecutionReport)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

