/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.ProjectFileDto;

@JsonTypeName(value="ProjectDirectories")
public class ProjectDirectoriesDto {
    private UUID id;
    private String name;
    @Valid
    private @Valid List<@Valid ProjectDirectoriesDto> directories;
    @Valid
    private @Valid List<@Valid ProjectFileDto> files;

    @Deprecated
    public ProjectDirectoriesDto() {
    }

    public ProjectDirectoriesDto(String name) {
        this.name = name;
    }

    public ProjectDirectoriesDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ProjectDirectoriesDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectDirectoriesDto directories(List<@Valid ProjectDirectoriesDto> directories) {
        this.directories = directories;
        return this;
    }

    public ProjectDirectoriesDto addDirectoriesItem(ProjectDirectoriesDto directoriesItem) {
        if (this.directories == null) {
            this.directories = new ArrayList<ProjectDirectoriesDto>();
        }
        this.directories.add(directoriesItem);
        return this;
    }

    @Valid
    @Schema(name="directories", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="directories")
    public @Valid List<@Valid ProjectDirectoriesDto> getDirectories() {
        return this.directories;
    }

    public void setDirectories(List<@Valid ProjectDirectoriesDto> directories) {
        this.directories = directories;
    }

    public ProjectDirectoriesDto files(List<@Valid ProjectFileDto> files) {
        this.files = files;
        return this;
    }

    public ProjectDirectoriesDto addFilesItem(ProjectFileDto filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<ProjectFileDto>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Valid
    @Schema(name="files", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="files")
    public @Valid List<@Valid ProjectFileDto> getFiles() {
        return this.files;
    }

    public void setFiles(List<@Valid ProjectFileDto> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDirectoriesDto projectDirectories = (ProjectDirectoriesDto)o;
        return Objects.equals(this.id, projectDirectories.id) && Objects.equals(this.name, projectDirectories.name) && Objects.equals(this.directories, projectDirectories.directories) && Objects.equals(this.files, projectDirectories.files);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.directories, this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectDirectoriesDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    directories: ").append(this.toIndentedString(this.directories)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

