/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;

@JsonTypeName(value="Section")
public class SectionDto {
    private UUID id;
    private String name;
    private UUID parentSection;
    private Integer place;
    @Valid
    private @Valid List<@Valid SectionDto> sections;
    @Valid
    private @Valid List<@Valid CompoundDto> compounds;
    @Valid
    private @Valid List<@Valid ProcessDto> processes;

    @Deprecated
    public SectionDto() {
    }

    public SectionDto(String name, Integer place) {
        this.name = name;
        this.place = place;
    }

    public SectionDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SectionDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SectionDto parentSection(UUID parentSection) {
        this.parentSection = parentSection;
        return this;
    }

    @Valid
    @Schema(name="parentSection", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentSection")
    public UUID getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(UUID parentSection) {
        this.parentSection = parentSection;
    }

    public SectionDto place(Integer place) {
        this.place = place;
        return this;
    }

    @NotNull
    @Schema(name="place", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="place")
    public Integer getPlace() {
        return this.place;
    }

    public void setPlace(Integer place) {
        this.place = place;
    }

    public SectionDto sections(List<@Valid SectionDto> sections) {
        this.sections = sections;
        return this;
    }

    public SectionDto addSectionsItem(SectionDto sectionsItem) {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionDto>();
        }
        this.sections.add(sectionsItem);
        return this;
    }

    @Valid
    @Schema(name="sections", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sections")
    public @Valid List<@Valid SectionDto> getSections() {
        return this.sections;
    }

    public void setSections(List<@Valid SectionDto> sections) {
        this.sections = sections;
    }

    public SectionDto compounds(List<@Valid CompoundDto> compounds) {
        this.compounds = compounds;
        return this;
    }

    public SectionDto addCompoundsItem(CompoundDto compoundsItem) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundDto>();
        }
        this.compounds.add(compoundsItem);
        return this;
    }

    @Valid
    @Schema(name="compounds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="compounds")
    public @Valid List<@Valid CompoundDto> getCompounds() {
        return this.compounds;
    }

    public void setCompounds(List<@Valid CompoundDto> compounds) {
        this.compounds = compounds;
    }

    public SectionDto processes(List<@Valid ProcessDto> processes) {
        this.processes = processes;
        return this;
    }

    public SectionDto addProcessesItem(ProcessDto processesItem) {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessDto>();
        }
        this.processes.add(processesItem);
        return this;
    }

    @Valid
    @Schema(name="processes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processes")
    public @Valid List<@Valid ProcessDto> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<@Valid ProcessDto> processes) {
        this.processes = processes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SectionDto section = (SectionDto)o;
        return Objects.equals(this.id, section.id) && Objects.equals(this.name, section.name) && Objects.equals(this.parentSection, section.parentSection) && Objects.equals(this.place, section.place) && Objects.equals(this.sections, section.sections) && Objects.equals(this.compounds, section.compounds) && Objects.equals(this.processes, section.processes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.parentSection, this.place, this.sections, this.compounds, this.processes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SectionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentSection: ").append(this.toIndentedString(this.parentSection)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    sections: ").append(this.toIndentedString(this.sections)).append("\n");
        sb.append("    compounds: ").append(this.toIndentedString(this.compounds)).append("\n");
        sb.append("    processes: ").append(this.toIndentedString(this.processes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

