/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;
import org.qubership.atp.mia.model.ei.ExportImportProcess;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderProcess
extends ImportLoader<ExportImportEntities, ProcessConfiguration, ExportImportProcess> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderProcess.class);

    public ImportLoaderProcess(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportProcess> getClazz() {
        return ExportImportProcess.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_PROCESSES;
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        ArrayList loadedProcesses = new ArrayList();
        List importProcesses = this.loadConfiguration(importData, path);
        importProcesses.forEach(p -> this.loadProcess(projectConfiguration, loadedProcesses, (ExportImportProcess)p, importData));
        loadedProcesses.forEach(p -> this.mergeProcessOrAdd(projectConfiguration, (ProcessConfiguration)p));
    }

    @Override
    public ProcessConfiguration toEntity(ProjectConfiguration projectConfiguration, ExportImportProcess exportImportProcess) {
        return ((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)new ProcessConfiguration().toBuilder()).id(exportImportProcess.getId())).name(exportImportProcess.getName())).sourceId(exportImportProcess.getSourceId())).processSettings(exportImportProcess.getProcessSettings())).inSections(new ArrayList<SectionConfiguration>())).inCompounds(new ArrayList<CompoundConfiguration>())).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        List importProcesses = this.loadConfiguration(importData, path);
        importProcesses.forEach(p -> this.loadProcess(projectConfiguration, (List<ProcessConfiguration>)new ArrayList<ProcessConfiguration>(), (ExportImportProcess)p, importData));
        return importProcesses.stream().map(ExportImportIdentifier::getId).collect(Collectors.toList());
    }

    private void loadProcess(ProjectConfiguration projectConfiguration, List<ProcessConfiguration> loadedProcesses, ExportImportProcess importProcess, ExportImportData importData) {
        if (loadedProcesses.stream().noneMatch(s -> importProcess.getId().equals(s.getId()))) {
            ProcessConfiguration process = this.toEntity(projectConfiguration, importProcess);
            List<SectionConfiguration> inSections = SectionConfigurationService.filterSectionsByIdOrSourceId(projectConfiguration.getSections(), importData.isInterProjectImport() || importData.isCreateNewProject() ? this.replaceIdsBack(importProcess.getInSections(), importData.getReplacementMap()) : importProcess.getInSections());
            process.setInSections(inSections);
            loadedProcesses.add(process);
        }
    }

    private void mergeProcessOrAdd(ProjectConfiguration projectConfiguration, ProcessConfiguration process) {
        if (process.getSourceId() != null) {
            this.mergeProcessOrAdd(projectConfiguration, process, process.getSourceId());
        } else {
            this.mergeProcessOrAdd(projectConfiguration, process, process.getId());
        }
    }

    private void mergeProcessOrAdd(ProjectConfiguration projectConfiguration, ProcessConfiguration process, UUID processId) {
        Optional<ProcessConfiguration> realProcessOptional = projectConfiguration.getProcesses().stream().filter(realS -> processId.equals(realS.getId()) || processId.equals(realS.getSourceId())).findFirst();
        if (realProcessOptional.isPresent()) {
            ProcessConfiguration realProcess = realProcessOptional.get();
            realProcess.setName(process.getName());
            realProcess.setSourceId(process.getSourceId());
            realProcess.setProcessSettings(process.getProcessSettings());
            process.getInSections().forEach(s -> s.addProcess(realProcess));
            HashSet<SectionConfiguration> sections = new HashSet<SectionConfiguration>(realProcess.getInSections());
            sections.addAll(process.getInSections());
            realProcess.setInSections(new ArrayList<SectionConfiguration>(sections));
        } else {
            Optional<ProcessConfiguration> realProcessTheSameNameOptional = projectConfiguration.getProcesses().stream().filter(realS -> process.getName().equals(realS.getName())).findFirst();
            if (realProcessTheSameNameOptional.isPresent()) {
                process.setName(process.getName() + "_ei_" + UUID.randomUUID());
            }
            process.setProjectConfiguration(projectConfiguration);
            process.getInSections().forEach(s -> s.addProcess(process));
            projectConfiguration.getProcesses().add(process);
        }
    }
}

