/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.executor;

import java.nio.file.Path;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.mia.ei.component.ExportStrategiesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtpMiaExportExecutor
implements ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(AtpMiaExportExecutor.class);
    private final ExportStrategiesRegistry exportStrategiesRegistry;
    @Value(value="${spring.application.name}")
    private String implementationName;

    @Transactional
    public void exportToFolder(ExportImportData exportData, Path path) throws ExportException {
        log.info("Start export. Request {}", (Object)exportData);
        this.exportStrategiesRegistry.getExportStrategy(exportData.getFormat()).export(exportData, path);
        log.info("End export. Request {}", (Object)exportData);
    }

    public String getExportImplementationName() {
        return this.implementationName;
    }

    public AtpMiaExportExecutor(ExportStrategiesRegistry exportStrategiesRegistry) {
        this.exportStrategiesRegistry = exportStrategiesRegistry;
    }
}

