/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.executor;

import java.nio.file.Path;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.mia.ei.service.ImportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AtpMiaImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(AtpMiaImportExecutor.class);
    private final ImportStrategy importStrategy;

    public void importData(ExportImportData importData, Path path) {
        log.info("Request for import with data: {}", (Object)importData);
        this.importStrategy.miaImport(importData, path);
        log.info("End export. Request {}", (Object)importData);
    }

    public ValidationResult preValidateData(ExportImportData importData, Path workDir) {
        return null;
    }

    public ValidationResult validateData(ExportImportData importData, Path workDir) {
        log.info("Request for validate with data: {}", (Object)importData);
        return this.importStrategy.validateData(importData, workDir);
    }

    public AtpMiaImportExecutor(ImportStrategy importStrategy) {
        this.importStrategy = importStrategy;
    }
}

